
package org.bidib.wizard.mvc.main.view.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JPanel;

import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.InputPortListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.listener.PortTableLayoutListener;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.mvc.main.controller.InputPortPanelController;
import org.bidib.wizard.mvc.main.model.InputPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.InputPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.InputPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class InputPortListPanel
    extends
    SimpleHierarchicalPortListPanel<InputPortTableModel, InputPortStatus, InputPort, InputPortListener, InputPortModelListener>
    implements TabVisibilityProvider, PortTableLayoutListener, TabPanelProvider, TabComponentCreator {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortListPanel.class);

    private final MainModel mainModel;

    private final TabVisibilityListener tabVisibilityListener;

    public InputPortListPanel(final InputPortPanelController controller, final InputPortTableModel tableModel,
        final MainModel mainModel, final TabVisibilityListener tabVisibilityListener,
        final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(InputPortListPanel.class, "emptyTable"), portConfigChangeEventSubject,
            mainModel);

        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    @Override
    protected AbstractPortHierarchicalTable<InputPort> createPortTable(
        InputPortTableModel tableModel, String emptyTableText) {

        return new InputPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(
        final InputPortTableModel tableModel, String emptyTableText,
        final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {

        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);

        // create the portlist menu listener to handle the port menu
        final PortListMenuListener portListMenuListener =
            createPortListMenuListener(this.table, nodeSelectionProvider, null);
        table.setPortListMenuListener(portListMenuListener);

    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TabComponentCreator) {
            TabComponentCreator creator = (TabComponentCreator) other;
            // TODO if more than a single instance is available this must be changed
            if (creator.getCreator() instanceof InputPortListPanel) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void processListChanged() {
        super.processListChanged();

        tabVisibilityListener.setTabVisible(this, isTabVisible());

        final NodeInterface node = mainModel.getSelectedNode();
        portTableLayoutChanged(node);
    }

    @Override
    public void portTableLayoutChanged(final NodeInterface node) {
        boolean hasPortIdentifiers = false;

        final List<InputPort> ports = new ArrayList<>();
        ports.addAll(getPorts());

        LOGGER.info("Number of ports: {}", ports.size());

        synchronized (ports) {
            for (InputPort port : ports) {
                if (port.isRemappingEnabled()) {
                    hasPortIdentifiers = true;
                    break;
                }
            }
        }

        // keep the column index of the column to insert in the view
        int viewColumnIndex = InputPortTableModel.COLUMN_IO_BEHAVIOUR;

        if (node != null) {

            LOGGER.info("A node is selected.");
            boolean hasInputPortConfig = false;
            if (node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty(node.getEnabledInputPorts())) {
                LOGGER.info("Check if the at least one input port has the input port config available.");
                for (InputPort port : node.getEnabledInputPorts()) {
                    hasInputPortConfig = port.isHasInputPortConfig();
                    if (hasInputPortConfig) {
                        // found one -> show the column
                        break;
                    }
                }
            }
            LOGGER
                .info("List has changed, hasPortIdentifiers: {}, hasInputPortConfig: {}", hasPortIdentifiers,
                    hasInputPortConfig);

            viewColumnIndex =
                table.setColumnVisible(InputPortTableModel.COLUMN_IO_BEHAVIOUR, viewColumnIndex, hasInputPortConfig);
            // viewColumnIndex =
            // table.setColumnVisible(InputPortTableModel.COLUMN_SWITCH_OFF_TIME, viewColumnIndex, hasInputPortConfig);
        }

        // show/hide the port identifiers
        table.setColumnVisible(InputPortTableModel.COLUMN_PORT_IDENTIFIER, viewColumnIndex, hasPortIdentifiers);
    }

    @Override
    public Class<?> getPortClass() {
        return InputPort.class;
    }

    @Override
    public boolean isTabVisible() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasInputPorts();
            LOGGER.debug("Check if tab is visible: {}", isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<InputPort> getPorts() {
        final NodeInterface node = mainModel.getSelectedNode();
        if (node != null) {
            List<InputPort> ports = new LinkedList<>();
            ports.addAll(node.getInputPorts());

            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        listChanged();
    }
}
