/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.menu;

import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.listener.AccessoryListener;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.AccessorySelectionListener;
import org.bidib.wizard.mvc.main.view.menu.listener.AccessoryTableMenuListener;

public class AccessoryTableMenu
extends BasicPopupMenu
implements AccessoryListener {
    private static final long serialVersionUID = 1L;
    public static final KeyStroke KEYSTROKE_DELETE = KeyStroke.getKeyStroke(127, 0);
    public static final KeyStroke KEYSTROKE_PASTE = KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    public static final KeyStroke KEYSTROKE_CUT = KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    public static final KeyStroke KEYSTROKE_COPY = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    private final Collection<AccessoryTableMenuListener> menuListeners = new LinkedList();
    private final JMenuItem insertEmptyBefore = new JMenuItem(Resources.getString(this.getClass(), (String)"insertEmptyBefore"));
    private final JMenuItem insertEmptyAfter = new JMenuItem(Resources.getString(this.getClass(), (String)"insertEmptyAfter"));
    private final JMenuItem delete = new JMenuItem(Resources.getString(this.getClass(), (String)"delete"));
    private final JMenuItem selectAll = new JMenuItem(Resources.getString(this.getClass(), (String)"selectAll"));
    private final JMenuItem cut = new JMenuItem(Resources.getString(this.getClass(), (String)"cut"));
    private final JMenuItem copy = new JMenuItem(Resources.getString(this.getClass(), (String)"copy"));
    private final JMenuItem pasteAfter = new JMenuItem(Resources.getString(this.getClass(), (String)"pasteAfter"));
    private Accessory accessory = null;

    public AccessoryTableMenu(MainModel model) {
        this.cut.setAccelerator(KEYSTROKE_CUT);
        this.cut.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.cut);
        this.copy.setAccelerator(KEYSTROKE_COPY);
        this.copy.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.copy);
        this.pasteAfter.setAccelerator(KEYSTROKE_PASTE);
        this.pasteAfter.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.pasteAfter);
        this.insertEmptyBefore.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.insertEmptyBefore);
        this.insertEmptyAfter.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.insertEmptyAfter);
        this.delete.setAccelerator(KEYSTROKE_DELETE);
        this.delete.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add(this.delete);
        this.addSeparator();
        this.selectAll.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.selectAll.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.selectAll.setEnabled(false);
        this.add(this.selectAll);
        model.addAccessorySelectionListener((AccessorySelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addMenuListener(AccessoryTableMenuListener l) {
        this.menuListeners.add(l);
    }

    private void enableMenuItems(Accessory accessory) {
        if (accessory != null) {
            boolean accessoryEmpty = accessory.getAspectCount() == 0;
            boolean accessoryFull = accessory.getAspectCount() >= accessory.getMaximumMacroMappedAspects();
            boolean accessoryMacroMapped = accessory.isMacroMapped() && accessory.getTotalAspects() > 0;
            this.insertEmptyBefore.setEnabled(!accessoryFull);
            this.insertEmptyAfter.setEnabled(!accessoryFull);
            this.pasteAfter.setEnabled(!accessoryFull);
            this.copy.setEnabled(!accessoryEmpty);
            this.cut.setEnabled(!accessoryEmpty);
            this.delete.setEnabled(!accessoryEmpty && accessoryMacroMapped);
            this.selectAll.setEnabled(!accessoryEmpty);
        } else {
            this.insertEmptyBefore.setEnabled(false);
            this.insertEmptyAfter.setEnabled(false);
            this.pasteAfter.setEnabled(false);
            this.copy.setEnabled(false);
            this.cut.setEnabled(false);
            this.delete.setEnabled(false);
            this.selectAll.setEnabled(false);
        }
    }

    public void updateImmutableMenuItems() {
        this.insertEmptyBefore.setEnabled(false);
        this.insertEmptyAfter.setEnabled(false);
        this.pasteAfter.setEnabled(false);
        this.copy.setEnabled(false);
        this.cut.setEnabled(false);
        this.delete.setEnabled(false);
        this.selectAll.setEnabled(false);
    }

    public void fireDelete() {
        if (!this.delete.isEnabled()) {
            return;
        }
        for (AccessoryTableMenuListener l : this.menuListeners) {
            l.delete();
        }
    }

    private void fireInsertEmptyAfter() {
        if (!this.insertEmptyAfter.isEnabled()) {
            return;
        }
        for (AccessoryTableMenuListener l : this.menuListeners) {
            l.insertEmptyAfter();
        }
    }

    private void fireInsertEmptyBefore() {
        if (!this.insertEmptyBefore.isEnabled()) {
            return;
        }
        for (AccessoryTableMenuListener l : this.menuListeners) {
            l.insertEmptyBefore();
        }
    }

    private void fireSelectAll() {
        if (!this.selectAll.isEnabled()) {
            return;
        }
        for (AccessoryTableMenuListener l : this.menuListeners) {
            l.selectAll();
        }
    }

    public void fireCopy() {
        if (!this.copy.isEnabled()) {
            return;
        }
        for (AccessoryTableMenuListener l : this.menuListeners) {
            l.copy();
        }
    }

    public void fireCut() {
        if (!this.cut.isEnabled()) {
            return;
        }
        for (AccessoryTableMenuListener l : this.menuListeners) {
            l.cut();
        }
    }

    public void firePasteAfter() {
        if (!this.pasteAfter.isEnabled()) {
            return;
        }
        for (AccessoryTableMenuListener l : this.menuListeners) {
            l.pasteAfter();
        }
    }

    public Accessory getAccessory() {
        return this.accessory;
    }

    public void setAccessory(Accessory accessory) {
        this.accessory = accessory;
    }

    public void labelChanged(String label) {
    }

    public void macrosChanged() {
        this.enableMenuItems(this.accessory);
    }

    public void accessoryStateChanged(Integer accessoryId, Integer aspect) {
    }
}

