/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberCellEditor.class);
    private static final long serialVersionUID = 1L;
    private final JPanel panel = new JPanel();
    private final JFormattedTextField textField = new JFormattedTextField((Object)3);
    private final NumberFormatter formatter = new /* Unavailable Anonymous Inner Class!! */;

    public NumberCellEditor() {
        this(255);
    }

    public NumberCellEditor(int maximum) {
        this.formatter.setMaximum(Integer.valueOf(maximum));
        this.textField.setFormatterFactory(new DefaultFormatterFactory(this.formatter, this.formatter, this.formatter));
        this.textField.setHorizontalAlignment(4);
        this.panel.setFocusCycleRoot(true);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.textField, "Center");
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.panel.setForeground(table.getSelectionForeground());
            this.panel.setBackground(table.getSelectionBackground());
        } else {
            this.panel.setForeground(table.getForeground());
            this.panel.setBackground(table.getBackground());
        }
        this.textField.setText(value != null ? value.toString() : "");
        return this.panel;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.textField.getText())) {
                return Integer.parseInt(this.textField.getText());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Parse textfield value failed.", (Throwable)ex);
        }
        LOGGER.debug("Allow empty string in text field. Return minimum value: {}", this.formatter.getMinimum());
        Comparable<?> minValue = this.formatter.getMinimum();
        if (minValue instanceof Number) {
            Number numMinValue = (Number)((Object)minValue);
            return numMinValue.intValue();
        }
        return 0;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.textField.getText())) {
                int value = Integer.valueOf(this.textField.getText());
                if (value < 0) {
                    LOGGER.warn("Invalid value detected: {}", (Object)value);
                    throw new NumberFormatException("Invalid value detected: " + value);
                }
            } else {
                LOGGER.info("Allow empty string in text field.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Parse text value failed: {}", (Object)ex.getMessage());
            return false;
        }
        return super.stopCellEditing();
    }
}

