package org.bidib.wizard.mvc.stepcontrol.model;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.Model;

public class StepControlAspect extends Model implements AspectReference, Comparable<StepControlAspect> {

    private static final Logger LOGGER = LoggerFactory.getLogger(StepControlAspect.class);

    private static final long serialVersionUID = 1L;

    public static final String PROPERTYNAME_ASPECT_NUMBER = "aspectNumber";

    public static final String PROPERTYNAME_POSITION = "position";

    public static final String PROPERTYNAME_OPPOSITE_POSITION = "oppositePosition";

    public static final String PROPERTYNAME_POLARITY = "polarity";

    public static final String PROPERTYNAME_OPPOSITE_POLARITY = "oppositePolarity";

    public static final String PROPERTYNAME_STATUS = "status";

    public static final String PROPERTYNAME_OPPOSITE_ASPECT = "oppositeAspect";

    public enum AspectPersistanceStatus {
        statusTransient, statusPersistent;
    }

    public enum Polarity {
        normal(0), inverted(1);

        int cvValue;

        Polarity(int cvValue) {
            this.cvValue = cvValue;
        }

        public int getCvValue() {
            return cvValue;
        }

        public static Polarity valueOf(int cvValue) {
            Polarity polarity = null;
            for (Polarity e : values()) {
                if (e.getCvValue() == cvValue) {
                    polarity = e;
                    break;
                }
            }
            if (polarity == null) {
                throw new IllegalArgumentException("Cannot map " + cvValue + " to a polarity.");
            }
            return polarity;
        }
    }

    @Deprecated
    private Integer aspectNumber;

    private Long position;

    private Long oppositePosition;

    private Polarity polarity;

    private Polarity oppositePolarity;

    private AspectPersistanceStatus status = AspectPersistanceStatus.statusTransient;

    private transient AspectReference oppositeAspect;

    public StepControlAspect(Integer aspectNumber, Long position, Polarity polarity) {
        this(aspectNumber, position, polarity, null, Polarity.normal);
    }

    public StepControlAspect(Integer aspectNumber, Long position, Polarity polarity, Long oppositePosition,
        Polarity oppositePolarity) {
        this.aspectNumber = aspectNumber;
        this.position = position;
        this.oppositePosition = oppositePosition;
        this.polarity = polarity;
        this.setOppositePolarity(oppositePolarity);
    }

    /**
     * @return the aspectNumber
     */
    public Integer getAspectNumber() {
        return aspectNumber;
    }

    /**
     * @param aspectNumber
     *            the aspectNumber to set
     */
    public void setAspectNumber(Integer aspectNumber) {
        Integer oldValue = this.aspectNumber;
        this.aspectNumber = aspectNumber;

        firePropertyChange(PROPERTYNAME_ASPECT_NUMBER, oldValue, aspectNumber);
    }

    /**
     * @return the position
     */
    public Long getPosition() {
        return position;
    }

    /**
     * @param position
     *            the position to set
     */
    public void setPosition(Long position) {
        Long oldValue = this.position;
        this.position = position;

        firePropertyChange(PROPERTYNAME_POSITION, oldValue, position);
    }

    /**
     * @return the opposite position
     */
    public Long getOppositePosition() {
        return oppositePosition;
    }

    /**
     * @param oppositePosition
     *            the position opposite to set
     */
    public void setOppositePosition(Long oppositePosition) {
        Long oldValue = this.oppositePosition;
        this.oppositePosition = oppositePosition;

        firePropertyChange(PROPERTYNAME_OPPOSITE_POSITION, oldValue, oppositePosition);
    }

    /**
     * @return the polarity
     */
    public Polarity getPolarity() {
        return polarity;
    }

    /**
     * @param polarity
     *            the polarity to set
     */
    public void setPolarity(Polarity polarity) {
        Polarity oldValue = this.polarity;
        this.polarity = polarity;

        firePropertyChange(PROPERTYNAME_POLARITY, oldValue, polarity);
    }

    /**
     * @return the oppositePolarity
     */
    public Polarity getOppositePolarity() {
        return oppositePolarity;
    }

    /**
     * @param oppositePolarity
     *            the oppositePolarity to set
     */
    public void setOppositePolarity(Polarity oppositePolarity) {
        Polarity oldValue = this.oppositePolarity;
        this.oppositePolarity = oppositePolarity;

        firePropertyChange(PROPERTYNAME_OPPOSITE_POLARITY, oldValue, oppositePolarity);
    }

    /**
     * @return the persistance status
     */
    public AspectPersistanceStatus getStatus() {
        LOGGER.info("Get the persistence status: {}", status);
        return status;
    }

    /**
     * @param status
     *            the persistance status to set
     */
    public void setStatus(AspectPersistanceStatus status) {
        AspectPersistanceStatus oldStatus = this.status;
        LOGGER.info("Set the persistence status: {}, old: {}", status, oldStatus);
        this.status = status;

        firePropertyChange(PROPERTYNAME_STATUS, oldStatus, status);
    }

    /**
     * @return the oppositeAspect
     */
    public AspectReference getOppositeAspect() {
        return oppositeAspect;
    }

    /**
     * @param oppositeAspect
     *            the oppositeAspect to set
     */
    public void setOppositeAspect(AspectReference oppositeAspect) {

        // final WeakReference<AspectReference> oppositeAspectReference = new WeakReference<>(oppositeAspect);

        // WeakReference<AspectReference> oldValue = this.oppositeAspect;
        AspectReference oldValue = this.oppositeAspect;
        this.oppositeAspect = oppositeAspect;

        firePropertyChange(PROPERTYNAME_OPPOSITE_ASPECT, oldValue, oppositeAspect);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj, false);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this, false);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean isValid() {
        return getPosition() != null && getPolarity() != null;
    }

    public boolean isOppositeValid() {
        return getOppositePosition() != null && getOppositePolarity() != null;
    }

    @Override
    public int compareTo(StepControlAspect other) {
        if (getPosition() != null && other.getPosition() != null) {
            return getPosition().compareTo(other.getPosition());
        }
        return -1;
    }

}
