package org.bidib.wizard.mvc.loco.view.speedo;

import java.lang.reflect.InvocationTargetException;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproveSpeedRangeDialogTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApproveSpeedRangeDialogTest.class);

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {

        SwingUtilities.invokeAndWait(() -> {

            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | InstantiationException | IllegalAccessException
                | UnsupportedLookAndFeelException ex) {
                LOGGER.warn("Set L&F failed.", ex);
            }

            JFrame frame = new JFrame("Test");

            final SpeedScaleBeanModel speedScaleBeanModelIn = new SpeedScaleBeanModel();
            speedScaleBeanModelIn.setMeasuredMinSpeed(7);
            speedScaleBeanModelIn.setMeasuredMaxSpeed(121);
            speedScaleBeanModelIn.setTargetMinSpeed(5);
            speedScaleBeanModelIn.setTargetMaxSpeed(100);

            int result = JOptionPane.CANCEL_OPTION;
            ApproveSpeedRangeDialog dialog = new ApproveSpeedRangeDialog(frame, speedScaleBeanModelIn);

            result = dialog.getResult();
            LOGGER.info("Result: {}", result);

            System.exit(0);
        });
    }
}
