package org.bidib.wizard.mvc.loco.view.speedo;

import java.awt.BorderLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.WindowConstants;

import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.bidib.wizard.client.common.text.LabeledTextField;
import org.bidib.wizard.client.common.text.TrailingLabeledTextField;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.OverlayableIconsFactory;
import com.jidesoft.swing.OverlayableUtils;

public class OverlayTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(OverlayTest.class);

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref:grow";

    private static final String ENCODED_DIALOG_ROW_SPECS = "p, 3dlu, p";

    public static void main(String[] args) throws InvocationTargetException, InterruptedException {

        SwingUtilities.invokeAndWait(() -> {

            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | InstantiationException | IllegalAccessException
                | UnsupportedLookAndFeelException ex) {
                LOGGER.warn("Set L&F failed.", ex);
            }

            JFrame frame = new JFrame("Test");
            frame.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

            FormBuilder formBuilder =
                FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS);
            formBuilder.border(Paddings.DIALOG);

            boolean manualMeasurement = true;

            final SpeedometerProgBeanModel speedometerProgBeanModel = new SpeedometerProgBeanModel();

            ValueModel vSpeedStep1ValueModel =
                new PropertyAdapter<SpeedometerProgBeanModel>(speedometerProgBeanModel,
                    SpeedometerProgBeanModel.PROPERTYNAME_CV35, true);

            final ValueModel vSpeedStep1ConverterModel =
                new ConverterValueModel(vSpeedStep1ValueModel, new StringConverter(new DecimalFormat("#")));

            LabeledTextField vSpeedStep1 =
                WizardComponentFactory.createLabeledTextField(vSpeedStep1ConverterModel, false, "mm/s", null);
            vSpeedStep1.getTextField().setEditable(manualMeasurement);
            vSpeedStep1.setHintText("CV35");

            JLabel dirtyIcon = new JLabel(OverlayableUtils.getPredefinedOverlayIcon(OverlayableIconsFactory.CORRECT));
            DefaultOverlayable overlayableTextField =
                new DefaultOverlayable(vSpeedStep1, dirtyIcon, DefaultOverlayable.SOUTH_WEST);
            overlayableTextField.setOverlayLocationInsets(new Insets(0, 5, 5, 0));

            formBuilder.add("vMin").xy(1, 1);
            formBuilder.add(overlayableTextField).xy(3, 1);

            InputValidationDocument numericDocument = new InputValidationDocument(3, InputValidationDocument.NUMERIC);
            numericDocument.setDocumentFilter(new IntegerRangeFilter(0, 255));

            TrailingLabeledTextField vSpeedStep2 =
                WizardComponentFactory
                    .createTrailingLabeledTextField(vSpeedStep1ConverterModel, false, "mm/s", numericDocument);
            vSpeedStep2.getTextField().setEditable(manualMeasurement);
            vSpeedStep2.setHintText("CV35");

            JLabel dirtyIcon2 = new JLabel(OverlayableUtils.getPredefinedOverlayIcon(OverlayableIconsFactory.CORRECT));
            DefaultOverlayable overlayableTextField2 =
                new DefaultOverlayable(vSpeedStep2, dirtyIcon2, DefaultOverlayable.NORTH_EAST);
            // overlayableTextField2.setOverlayLocationInsets(new Insets(0, 5, 5, 0));

            formBuilder.add("vMin").xy(1, 3);
            formBuilder.add(overlayableTextField2).xy(3, 3);

            frame.getContentPane().add(formBuilder.build(), BorderLayout.CENTER);

            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);

            // System.exit(0);
        });
    }
}
