/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.ifnet.view;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Objects;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.field.IPTextField;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.model.IpAddress;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.ifnet.model.IFnetConfigurationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IFnetConfigurationDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(IFnetConfigurationDialog.class);
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, max(pref;100dlu)";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private final JButton cancelButton = new JButton(Resources.getString(IFnetConfigurationDialog.class, (String)"cancel"));
    private final JButton applyButton = new JButton(Resources.getString(IFnetConfigurationDialog.class, (String)"apply"));
    private final NodeService nodeService;
    private final NodeInterface selectedNode;
    private Trigger trigger;
    private PresentationModel<IFnetConfigurationModel> presentationModel;
    private ValueModel ipModeModel;

    public IFnetConfigurationDialog(Frame frame, String title, NodeService nodeService, NodeInterface selectedNode) {
        super(frame, title, true);
        this.nodeService = nodeService;
        this.selectedNode = selectedNode;
    }

    private JPanel createPanel(IFnetConfigurationModel iFnetConfigurationModel) {
        FormBuilder builder = null;
        boolean debug = false;
        builder = debug ? FormBuilder.create().columns("pref, 3dlu, max(pref;100dlu)", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]).panel((JPanel)new FormDebugPanel()) : FormBuilder.create().columns("pref, 3dlu, max(pref;100dlu)", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]).panel(new JPanel());
        builder.border((Border)Paddings.TABBED_DIALOG);
        this.trigger = new Trigger();
        this.presentationModel = new PresentationModel((Object)iFnetConfigurationModel, (ValueModel)this.trigger);
        int row = 1;
        builder.add(Resources.getString(IFnetConfigurationDialog.class, (String)"ipMode"), new Object[0]).xy(1, row);
        FormBuilder ipModeBuilder = FormBuilder.create().columns("pref, 3dlu, pref", new Object[0]).rows("p, 3dlu, p", new Object[0]);
        this.ipModeModel = new PropertyAdapter((Object)iFnetConfigurationModel, "ipMode", true);
        int column = 1;
        for (int i = 0; i < 2; ++i) {
            IFnetConfigurationModel.IpMode ipMode = null;
            switch (i) {
                case 0: {
                    ipMode = IFnetConfigurationModel.IpMode.DHCP;
                    break;
                }
                default: {
                    ipMode = IFnetConfigurationModel.IpMode.STATIC;
                }
            }
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)this.ipModeModel, (Object)ipMode, (String)Resources.getString(IFnetConfigurationDialog.class, (String)ipMode.getKey()));
            ipModeBuilder.add((Component)radio).xy(column, 1);
            column += 2;
        }
        builder.add((Component)ipModeBuilder.build()).xy(3, row);
        BufferedValueModel staticAddressModel = this.presentationModel.getBufferedModel("staticAddress");
        IPTextField staticAddress = WizardComponentFactory.createIPTextField((ValueModel)staticAddressModel, (boolean)false);
        builder.add(Resources.getString(this.getClass(), (String)"staticAddress") + ":", new Object[0]).xy(1, row += 2);
        builder.add((Component)staticAddress).xyw(3, row, 1);
        staticAddress.setEnabled(false);
        BufferedValueModel subnetMaskModel = this.presentationModel.getBufferedModel("subnetMask");
        IPTextField subnetMask = WizardComponentFactory.createIPTextField((ValueModel)subnetMaskModel, (boolean)false);
        builder.add(Resources.getString(this.getClass(), (String)"subnetMask") + ":", new Object[0]).xy(1, row += 2);
        builder.add((Component)subnetMask).xyw(3, row, 1);
        subnetMask.setEnabled(false);
        BufferedValueModel gatewayModel = this.presentationModel.getBufferedModel("gateway");
        IPTextField gateway = WizardComponentFactory.createIPTextField((ValueModel)gatewayModel, (boolean)false);
        builder.add(Resources.getString(this.getClass(), (String)"gateway") + ":", new Object[0]).xy(1, row += 2);
        builder.add((Component)gateway).xyw(3, row, 1);
        gateway.setEnabled(false);
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.applyButton, this.cancelButton}).build();
        builder.add((Component)buttons).xyw(1, row += 2, 3);
        this.applyButton.setEnabled(false);
        JPanel contentPanel = builder.build();
        this.ipModeModel.addValueChangeListener(pce -> this.updateIpModeComponents(enabled -> {
            staticAddress.setEnabled(enabled.booleanValue());
            subnetMask.setEnabled(enabled.booleanValue());
            gateway.setEnabled(enabled.booleanValue());
        }));
        return contentPanel;
    }

    private void updateIpModeComponents(Consumer<Boolean> enableCallback) {
        LOGGER.info("The ipMode has been changed: {}", this.ipModeModel.getValue());
        IFnetConfigurationModel.IpMode ipMode = IFnetConfigurationModel.IpMode.DHCP;
        if (this.ipModeModel.getValue() instanceof IFnetConfigurationModel.IpMode) {
            ipMode = (IFnetConfigurationModel.IpMode)this.ipModeModel.getValue();
        }
        if (IFnetConfigurationModel.IpMode.STATIC == ipMode) {
            enableCallback.accept(true);
        } else {
            enableCallback.accept(false);
        }
    }

    protected PresentationModel<IFnetConfigurationModel> getPresentationModel() {
        return this.presentationModel;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private static Integer findCvValue(List<ConfigurationVariable> cvValues, String cvNumber) {
        Integer cvValue = cvValues.stream().filter(cv -> Objects.equals((Object)cv.getName(), (Object)cvNumber)).findFirst().map(cv -> Integer.valueOf(cv.getValue())).orElse(null);
        return cvValue;
    }

    public void showDialog() {
        IFnetConfigurationModel iFnetConfigurationModel = new IFnetConfigurationModel();
        ArrayList<ConfigurationVariable> configVariables = new ArrayList<ConfigurationVariable>();
        configVariables.add(new ConfigurationVariable("3073", null));
        configVariables.add(new ConfigurationVariable("3081", null));
        configVariables.add(new ConfigurationVariable("3082", null));
        configVariables.add(new ConfigurationVariable("3083", null));
        configVariables.add(new ConfigurationVariable("3084", null));
        configVariables.add(new ConfigurationVariable("3085", null));
        configVariables.add(new ConfigurationVariable("3086", null));
        configVariables.add(new ConfigurationVariable("3087", null));
        configVariables.add(new ConfigurationVariable("3088", null));
        configVariables.add(new ConfigurationVariable("3089", null));
        configVariables.add(new ConfigurationVariable("3090", null));
        configVariables.add(new ConfigurationVariable("3091", null));
        configVariables.add(new ConfigurationVariable("3092", null));
        List cvValues = this.nodeService.queryConfigVariables("main", this.selectedNode, configVariables);
        this.selectedNode.updateConfigVariableValues(cvValues, true);
        Integer ipModeValue = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3073");
        if (ipModeValue != null && ipModeValue == 1) {
            iFnetConfigurationModel.setIpMode(IFnetConfigurationModel.IpMode.STATIC);
        } else {
            iFnetConfigurationModel.setIpMode(IFnetConfigurationModel.IpMode.DHCP);
        }
        Integer staticIpByte1Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3081");
        Integer staticIpByte2Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3082");
        Integer staticIpByte3Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3083");
        Integer staticIpByte4Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3084");
        Object staticAddress = "";
        if (staticIpByte1Value != null) {
            staticAddress = (String)staticAddress + staticIpByte1Value.toString();
        }
        staticAddress = (String)staticAddress + ".";
        if (staticIpByte2Value != null) {
            staticAddress = (String)staticAddress + staticIpByte2Value.toString();
        }
        staticAddress = (String)staticAddress + ".";
        if (staticIpByte3Value != null) {
            staticAddress = (String)staticAddress + staticIpByte3Value.toString();
        }
        staticAddress = (String)staticAddress + ".";
        if (staticIpByte4Value != null) {
            staticAddress = (String)staticAddress + staticIpByte4Value.toString();
        }
        LOGGER.info("Prepared staticAddress: {}", staticAddress);
        iFnetConfigurationModel.setStaticAddress((String)staticAddress);
        Integer subnetMaskByte1Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3085");
        Integer subnetMaskByte2Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3086");
        Integer subnetMaskByte3Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3087");
        Integer subnetMaskByte4Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3088");
        Object subnetMask = "";
        if (subnetMaskByte1Value != null) {
            subnetMask = (String)subnetMask + subnetMaskByte1Value.toString();
        }
        subnetMask = (String)subnetMask + ".";
        if (subnetMaskByte2Value != null) {
            subnetMask = (String)subnetMask + subnetMaskByte2Value.toString();
        }
        subnetMask = (String)subnetMask + ".";
        if (subnetMaskByte3Value != null) {
            subnetMask = (String)subnetMask + subnetMaskByte3Value.toString();
        }
        subnetMask = (String)subnetMask + ".";
        if (subnetMaskByte4Value != null) {
            subnetMask = (String)subnetMask + subnetMaskByte4Value.toString();
        }
        LOGGER.info("Prepared subnetMask: {}", subnetMask);
        iFnetConfigurationModel.setSubnetMask((String)subnetMask);
        Integer gatewayByte1Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3089");
        Integer gatewayByte2Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3090");
        Integer gatewayByte3Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3091");
        Integer gatewayByte4Value = IFnetConfigurationDialog.findCvValue((List)cvValues, (String)"3092");
        Object gateway = "";
        if (gatewayByte1Value != null) {
            gateway = (String)gateway + gatewayByte1Value.toString();
        }
        gateway = (String)gateway + ".";
        if (gatewayByte2Value != null) {
            gateway = (String)gateway + gatewayByte2Value.toString();
        }
        gateway = (String)gateway + ".";
        if (gatewayByte3Value != null) {
            gateway = (String)gateway + gatewayByte3Value.toString();
        }
        gateway = (String)gateway + ".";
        if (gatewayByte4Value != null) {
            gateway = (String)gateway + gatewayByte4Value.toString();
        }
        LOGGER.info("Prepared gateway: {}", gateway);
        iFnetConfigurationModel.setGateway((String)gateway);
        this.add((Component)this.createPanel(iFnetConfigurationModel), (Object)"Center");
        Consumer<IFnetConfigurationModel> saveConsumer = model -> this.writeCvValueToNode(model);
        this.applyButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        PropertyConnector.connect((Object)this.presentationModel, (String)"changed", (Object)this.applyButton, (String)"enabled");
        this.pack();
        this.setLocationRelativeTo((Component)this.getParent());
        this.setVisible(true);
    }

    private void writeCvValueToNode(IFnetConfigurationModel model) {
        ArrayList<ConfigurationVariable> configVariables = new ArrayList<ConfigurationVariable>();
        configVariables.add(new ConfigurationVariable("3073", model.getIpMode().getValue()));
        IpAddress staticAddress = IpAddress.parseValue((String)model.getStaticAddress());
        configVariables.add(new ConfigurationVariable("3081", Integer.toString(staticAddress.getByte1())));
        configVariables.add(new ConfigurationVariable("3082", Integer.toString(staticAddress.getByte2())));
        configVariables.add(new ConfigurationVariable("3083", Integer.toString(staticAddress.getByte3())));
        configVariables.add(new ConfigurationVariable("3084", Integer.toString(staticAddress.getByte4())));
        IpAddress subnetMask = IpAddress.parseValue((String)model.getSubnetMask());
        configVariables.add(new ConfigurationVariable("3085", Integer.toString(subnetMask.getByte1())));
        configVariables.add(new ConfigurationVariable("3086", Integer.toString(subnetMask.getByte2())));
        configVariables.add(new ConfigurationVariable("3087", Integer.toString(subnetMask.getByte3())));
        configVariables.add(new ConfigurationVariable("3088", Integer.toString(subnetMask.getByte4())));
        IpAddress gateway = IpAddress.parseValue((String)model.getGateway());
        configVariables.add(new ConfigurationVariable("3089", Integer.toString(gateway.getByte1())));
        configVariables.add(new ConfigurationVariable("3090", Integer.toString(gateway.getByte2())));
        configVariables.add(new ConfigurationVariable("3091", Integer.toString(gateway.getByte3())));
        configVariables.add(new ConfigurationVariable("3092", Integer.toString(gateway.getByte4())));
        List cvValues = this.nodeService.setConfigVariables("main", this.selectedNode, configVariables);
        this.selectedNode.updateConfigVariableValues(cvValues, true);
    }
}

