/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.model;

import com.jgoodies.common.bean.Bean;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.wizard.mvc.loco.model.SpeedometerModel;
import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.bidib.wizard.mvc.loco.model.command.PomRequestProcessor;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedometerModel
extends Bean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpeedometerModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTYNAME_ACTIVE = "active";
    public static final String PROPERTYNAME_INACTIVE = "inactive";
    public static final String PROPERTYNAME_CV2_VMIN = "cv2Vmin";
    public static final String PROPERTYNAME_CV37_SCALE = "cv37Scale";
    public static final String PROPERTYNAME_DYNSTATEENERGY = "dynStateEnergy";
    public static final String PROPERTYNAME_REPORTEDSPEED = "reportedSpeed";
    public static final String PROPERTYNAME_SPEED = "speed";
    public static final String PROPERTYNAME_SPEEDMEASUREMENTSTAGE = "speedMeasurementStage";
    private AtomicBoolean active = new AtomicBoolean(false);
    private Integer cv2Vmin;
    private Integer cv37Scale;
    private Integer dynStateEnergy;
    private Integer reportedSpeed;
    private Integer speed;
    private SpeedMeasurementStage speedMeasurementStage = SpeedMeasurementStage.IDLE;
    private PomProgrammerModel pomProgrammerModel;
    private CompositeDisposable compositeDisposable;
    private PomRequestProcessor<SpeedometerProgBeanModel> pomRequestProcessor;
    private List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> pomProgCommands;
    private SingleObserver<String> completeAction;

    public void clearValues() {
        LOGGER.info("Clear the values of the speedometer model.");
        this.setActive(false);
        this.setCv2Vmin(null);
        this.setCv37Scale(null);
        this.setDynStateEnergy(null);
        this.setReportedSpeed(null);
        this.setSpeed(null);
        this.setSpeedMeasurementStage(SpeedMeasurementStage.IDLE);
        this.setCompleteAction(null);
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean isInactive() {
        return !this.active.get();
    }

    public void setActive(boolean active) {
        LOGGER.info("Set the active flag: {}", (Object)active);
        boolean oldValue = this.active.get();
        this.active.set(active);
        this.firePropertyChange(PROPERTYNAME_ACTIVE, oldValue, active);
        this.firePropertyChange(PROPERTYNAME_INACTIVE, !oldValue, !active);
    }

    public Integer getDynStateEnergy() {
        return this.dynStateEnergy;
    }

    public void setDynStateEnergy(Integer dynStateEnergy) {
        Integer oldValue = this.dynStateEnergy;
        this.dynStateEnergy = dynStateEnergy;
        this.firePropertyChange(PROPERTYNAME_DYNSTATEENERGY, (Object)oldValue, (Object)dynStateEnergy);
    }

    public Integer getReportedSpeed() {
        return this.reportedSpeed;
    }

    public void setReportedSpeed(Integer reportedSpeed) {
        Integer oldValue = this.reportedSpeed;
        this.reportedSpeed = reportedSpeed;
        LOGGER.info("New reported speed: {}", (Object)this.reportedSpeed);
        this.firePropertyChange(PROPERTYNAME_REPORTEDSPEED, (Object)oldValue, (Object)reportedSpeed);
    }

    public Integer getSpeed() {
        return this.speed;
    }

    public void setSpeed(Integer speed) {
        Integer oldValue = this.speed;
        this.speed = speed;
        this.firePropertyChange(PROPERTYNAME_SPEED, (Object)oldValue, (Object)speed);
    }

    public SpeedMeasurementStage getSpeedMeasurementStage() {
        return this.speedMeasurementStage;
    }

    public void setSpeedMeasurementStage(SpeedMeasurementStage speedMeasurementStage) {
        LOGGER.info("Set the speedMeasurementStage: {}", (Object)speedMeasurementStage);
        SpeedMeasurementStage oldValue = this.speedMeasurementStage;
        this.speedMeasurementStage = speedMeasurementStage;
        this.firePropertyChange(PROPERTYNAME_SPEEDMEASUREMENTSTAGE, (Object)oldValue, (Object)speedMeasurementStage);
    }

    public List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> getPomProgCommands() {
        return this.pomProgCommands;
    }

    public void setPomProgCommands(List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> pomProgCommands) {
        LOGGER.info("Set the pomProgCommands: {}", pomProgCommands);
        this.pomProgCommands = pomProgCommands;
    }

    public SingleObserver<String> getCompleteAction() {
        return this.completeAction;
    }

    public void setCompleteAction(SingleObserver<String> completeAction) {
        LOGGER.info("Set the complete action:{}", completeAction);
        this.completeAction = completeAction;
    }

    public Integer getCv2Vmin() {
        return this.cv2Vmin;
    }

    public void setCv2Vmin(Integer cv2Vmin) {
        Integer oldValue = this.cv2Vmin;
        this.cv2Vmin = cv2Vmin;
        this.firePropertyChange(PROPERTYNAME_CV2_VMIN, (Object)oldValue, (Object)cv2Vmin);
    }

    public Integer getCv37Scale() {
        return this.cv37Scale;
    }

    public void setCv37Scale(Integer cv37Scale) {
        Integer oldValue = this.cv37Scale;
        this.cv37Scale = cv37Scale;
        this.firePropertyChange(PROPERTYNAME_CV37_SCALE, (Object)oldValue, (Object)cv37Scale);
    }

    public PomProgrammerModel getPomProgrammerModel() {
        return this.pomProgrammerModel;
    }

    public void setPomProgrammerModel(PomProgrammerModel pomProgrammerModel) {
        this.pomProgrammerModel = pomProgrammerModel;
    }

    public CompositeDisposable getCompositeDisposable() {
        return this.compositeDisposable;
    }

    public void setCompositeDisposable(CompositeDisposable compositeDisposable) {
        this.compositeDisposable = compositeDisposable;
    }

    public PomRequestProcessor<SpeedometerProgBeanModel> getPomRequestProcessor() {
        return this.pomRequestProcessor;
    }

    public void setPomRequestProcessor(PomRequestProcessor<SpeedometerProgBeanModel> pomRequestProcessor) {
        this.pomRequestProcessor = pomRequestProcessor;
    }
}

