/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.function.Function;
import org.bidib.wizard.client.common.table.AbstractStatusEmptyTable;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.MacroTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.menu.AccessoryTableMenu;
import org.bidib.wizard.mvc.main.view.menu.MacroTableMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.MacroTableMenuListener;
import org.bidib.wizard.mvc.main.view.table.MacroTableRowTransferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroContentPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroContentPanel.class);
    private final MainModel model;
    private final MacroTableModel tableModel;
    private final AbstractStatusEmptyTable table;
    private final MacroTableMenu macroTableMenu;
    private Function<?>[] functionsClipBoard;
    private final String emptyPortLabel;

    public MacroContentPanel(MainModel model) {
        this.macroTableMenu = new MacroTableMenu(model);
        this.model = model;
        this.setLayout((LayoutManager)new BorderLayout());
        this.setBorder((Border)new EmptyBorder(5, 2, 5, 3));
        this.emptyPortLabel = Resources.getString(Port.class, (String)"portNone");
        this.macroTableMenu.addMenuListener((MacroTableMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tableModel = new MacroTableModel(model);
        this.table = new /* Unavailable Anonymous Inner Class!! */;
        this.table.adjustRowHeight();
        this.table.getInputMap(1).put(MacroTableMenu.KEYSTROKE_CUT, "cut");
        this.table.getActionMap().put("cut", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.table.getInputMap(1).put(MacroTableMenu.KEYSTROKE_COPY, "copy");
        this.table.getActionMap().put("copy", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.table.getInputMap(1).put(MacroTableMenu.KEYSTROKE_PASTE, "paste");
        this.table.getActionMap().put("paste", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.table.getInputMap(1).put(AccessoryTableMenu.KEYSTROKE_DELETE, "delete");
        this.table.getActionMap().put("delete", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.table.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.table.setAutoResizeMode(0);
        this.table.setSortable(false);
        this.table.setDragEnabled(true);
        this.table.setSelectionMode(1);
        this.table.setDropMode(DropMode.INSERT_ROWS);
        this.table.setTransferHandler((TransferHandler)new MacroTableRowTransferHandler((JTable)this.table));
        block5: for (int i = 0; i < this.table.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(40);
                    continue block5;
                }
                case 1: {
                    column.setPreferredWidth(120);
                    continue block5;
                }
                case 5: {
                    column.setPreferredWidth(120);
                    continue block5;
                }
                default: {
                    column.setPreferredWidth(200);
                }
            }
        }
        this.setMinimumSize(new Dimension(400, 100));
        this.setPreferredSize(new Dimension(600, 200));
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.table));
        this.tableModel.addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.table.getEmptyTableText() + ":f:gray}")));
        this.add((Component)overlayTable, (Object)"Center");
        model.addMacroSelectionListener((MacroSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Function<? extends BidibStatus>[] getFunctions(int[] rows) {
        Function[] result = new Function[rows.length];
        for (int index = 0; index < rows.length; ++index) {
            result[index] = this.model.getSelectedMacro().getFunction(rows[index]);
        }
        return result;
    }

    private int getRow(Point point) {
        return this.table.rowAtPoint(point);
    }

    private void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger()) {
            int row = this.getRow(e.getPoint());
            if (this.table.getSelectedRowCount() == 0 && this.table.getRowCount() > 0 && row >= 0 && row < this.table.getRowCount()) {
                this.table.setRowSelectionInterval(row, row);
            }
            this.table.grabFocus();
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void setFunctionsToClipboard(Function<?>[] functions) {
        if (functions != null) {
            try {
                this.functionsClipBoard = new Function[functions.length];
                for (int index = 0; index < functions.length; ++index) {
                    if (functions[index] == null) continue;
                    this.functionsClipBoard[index] = (Function)functions[index].clone();
                }
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.functionsClipBoard = null;
        }
    }

    private Function<?>[] getFunctionsFromClipboard() {
        Function[] result = null;
        if (this.functionsClipBoard != null) {
            try {
                result = new Function[this.functionsClipBoard.length];
                for (int index = 0; index < this.functionsClipBoard.length; ++index) {
                    if (this.functionsClipBoard[index] == null) continue;
                    result[index] = (Function)this.functionsClipBoard[index].clone();
                }
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void fireCopy(int[] rows) {
        Function[] functions = this.getFunctions(rows);
        this.setFunctionsToClipboard(functions);
    }

    private void fireCut(int[] rows) {
        Function[] functions = this.getFunctions(rows);
        this.setFunctionsToClipboard(functions);
        for (int index = rows.length - 1; index >= 0; --index) {
            this.model.getSelectedMacro().removeFunction(rows[index]);
        }
    }

    private void fireDelete(int[] rows) {
        for (int index = rows.length - 1; index >= 0; --index) {
            this.model.getSelectedMacro().removeFunction(rows[index]);
        }
    }

    private void fireInsertEmptyAfter(int row) {
        this.model.getSelectedMacro().addFunctionsAfter(row, null);
    }

    private void fireInsertEmptyBefore(int row) {
        this.model.getSelectedMacro().addFunctionsBefore(row >= 0 ? row : 0, null);
    }

    private void firePasteAfter(int row) {
        this.model.getSelectedMacro().addFunctionsAfter(row, this.getFunctionsFromClipboard());
    }

    private void firePasteBefore(int row) {
        this.model.getSelectedMacro().addFunctionsBefore(row >= 0 ? row : 0, this.getFunctionsFromClipboard());
    }

    private void firePasteInvertedAfter(int row) {
        this.model.getSelectedMacro().addFunctionsInvertedAfter(row, this.getFunctionsFromClipboard());
    }

    public void refreshView() {
        LOGGER.info("Refresh the macro panel.");
        Macro macro = this.model.getSelectedMacro();
        LOGGER.info("The macro has changed: {}", (Object)macro);
        this.tableModel.setMacro(macro);
    }
}

