/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jidesoft.grid.AbstractTableCellEditorRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.view.table.PortComboBoxWithButtonEditorRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortComboBoxWithButtonEditorRenderer<E extends BidibStatus>
extends AbstractTableCellEditorRenderer
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(PortComboBoxWithButtonEditorRenderer.class);
    private final Collection<ButtonListener> buttonListeners = new LinkedList();
    private int row;
    private int column;
    private final E[] items;
    private final String buttonText;
    private final String resourceClazz;
    private final Integer instanceColumn;

    public PortComboBoxWithButtonEditorRenderer(E[] items, String buttonText, Class<?> resourceClazz, Integer instanceColumn) {
        this(items, buttonText, Resources.trimWizardPackage((String)resourceClazz.getName()), instanceColumn);
    }

    public PortComboBoxWithButtonEditorRenderer(E[] items, String buttonText, String resourceClazz, Integer instanceColumn) {
        this.items = items;
        this.buttonText = buttonText;
        this.resourceClazz = resourceClazz;
        this.instanceColumn = instanceColumn;
    }

    public void addButtonListener(ButtonListener l) {
        this.buttonListeners.add(l);
    }

    private void fireButtonPressed() {
        for (ButtonListener l : this.buttonListeners) {
            l.buttonPressed(this.row, this.column, this.getCellEditorValue());
        }
    }

    @Override
    public Object getCellEditorValue() {
        Component comp = this._editorComponent;
        Object value = null;
        if (comp instanceof RendererPanel) {
            RendererPanel p = (RendererPanel)comp;
            value = p.getComboBox().getSelectedItem();
        }
        LOGGER.info("Current cellEditor value: {}", value);
        return value;
    }

    private JComboBox<E> getComboBox() {
        Component comp = this._editorComponent;
        if (comp instanceof RendererPanel) {
            RendererPanel p = (RendererPanel)comp;
            return p.getComboBox();
        }
        return null;
    }

    protected void setSelectedValue(Port<? extends BidibStatus> port) {
        LOGGER.info("Set the selected value from port: {}", port);
        this.getComboBox().setSelectedItem(port.getStatus());
    }

    protected void setSelectedValue(E status) {
        LOGGER.info("Set the selected value: {}", status);
        this.getComboBox().setSelectedItem(status);
    }

    protected boolean isPortEnabled(ConfigurablePort<?> port) {
        return port.isEnabled();
    }

    public void configureTableCellEditorRendererComponent(JTable table, Component editorRendererComponent, boolean forRenderer, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ConfigurablePort port;
        LOGGER.debug("Current row: {}, value: {}, forRenderer: {}", new Object[]{row, value, forRenderer});
        JComboBox comboBox = null;
        JButton button = null;
        if (editorRendererComponent instanceof RendererPanel) {
            RendererPanel p = (RendererPanel)editorRendererComponent;
            comboBox = p.getComboBox();
            button = p.getButton();
        }
        if (forRenderer) {
            if (value instanceof ConfigurablePort) {
                port = (ConfigurablePort)value;
                boolean isPortEnabled = this.isPortEnabled(port);
                LOGGER.debug("Port is enabled: {}, port: {}", (Object)isPortEnabled, (Object)port);
                editorRendererComponent.setEnabled(isPortEnabled);
                comboBox.setEnabled(isPortEnabled);
                button.setEnabled(isPortEnabled);
                comboBox.setSelectedItem(port);
            } else if (value instanceof BidibStatus) {
                boolean isPortEnabled = true;
                if (this.instanceColumn != null) {
                    ConfigurablePort port2 = (ConfigurablePort)table.getModel().getValueAt(row, this.instanceColumn);
                    isPortEnabled = this.isPortEnabled(port2);
                }
                editorRendererComponent.setEnabled(isPortEnabled);
                comboBox.setEnabled(isPortEnabled);
                button.setEnabled(isPortEnabled);
                comboBox.setSelectedItem(value);
            } else {
                if (value != null) {
                    LOGGER.warn("Invalid value: {}", value);
                }
                editorRendererComponent.setEnabled(false);
                comboBox.setEnabled(false);
                button.setEnabled(false);
            }
        } else if (value instanceof ConfigurablePort) {
            port = (ConfigurablePort)value;
            comboBox.setSelectedItem(port);
        } else if (value instanceof BidibStatus) {
            comboBox.setSelectedItem(value);
        } else {
            LOGGER.warn("Invalid value: {}", value);
        }
        if (isSelected) {
            editorRendererComponent.setForeground(table.getSelectionForeground());
            editorRendererComponent.setBackground(table.getSelectionBackground());
        } else {
            editorRendererComponent.setForeground(table.getForeground());
            editorRendererComponent.setBackground(table.getBackground());
            comboBox.setForeground(table.getForeground());
            comboBox.setBackground(table.getBackground());
            button.setForeground(table.getForeground());
            button.setBackground(table.getBackground());
        }
    }

    public Component createTableCellEditorRendererComponent(JTable table, int row, int column) {
        this.row = row;
        this.column = column;
        JComboBox<BidibStatus> comboBox = new JComboBox<BidibStatus>((BidibStatus[])this.items.clone());
        comboBox.setRenderer((ListCellRenderer<BidibStatus>)new BidibStatusListRenderer(this.resourceClazz));
        JButton button = new JButton(this.buttonText);
        RendererPanel panel = new RendererPanel(comboBox, button);
        button.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        panel.setLayout((LayoutManager)new GridBagLayout());
        panel.setFocusCycleRoot(true);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 0, 2);
        c.weightx = 1.0;
        panel.add(comboBox, (Object)c);
        c.anchor = 24;
        ++c.gridx;
        c.weightx = 0.0;
        panel.add((Component)button, (Object)c);
        return panel;
    }

    static /* synthetic */ void access$000(PortComboBoxWithButtonEditorRenderer x0) {
        x0.fireEditingStopped();
    }
}

