package org.bidib.wizard.mvc.comparison.controller;

import com.vlsolutions.swing.docking.DockingDesktop;

import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.core.schema.bidib2.Node;
import org.bidib.jbidibc.core.schema.bidib2.Nodes;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.core.model.connection.ConnectionRegistry;
import org.bidib.wizard.core.service.ConnectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

public class ComparisonController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ComparisonController.class);

    private final DockingDesktop desktop;

    @Autowired
    private ConnectionService connectionService;

    public ComparisonController(final DockingDesktop desktop) {
        this.desktop = desktop;
    }

    public BiDiB exportNodeTreeToComparison() {
        LOGGER.info("Export node tree for comparison.");

        final BidibConnection connection = connectionService.find(ConnectionRegistry.CONNECTION_ID_MAIN);

        // we must fetch the nodes
        final NodeProvider nodeProvider = connection.getNodeProvider();
        final NodeInterface rootNode = nodeProvider.findNodeByAddress(org.bidib.jbidibc.messages.Node.ROOTNODE_ADDR);

        final BiDiB bidib = new BiDiB().withSchemaVersion("2.1");
        final Nodes bidibNodes = new Nodes();
        bidib.setNodes(bidibNodes);

        final Node bidibNode = createBidibNode(rootNode);
        bidibNodes.getNode().add(bidibNode);

        final List<NodeInterface> subNodes = nodeProvider.findSubNodes(rootNode);
        if (CollectionUtils.isNotEmpty(subNodes)) {
            addSubNodes(nodeProvider, bidibNode, subNodes);
        }

        LOGGER.info("Prepared bidib: {}", bidib);

        return bidib;
    }

    private Node createBidibNode(final NodeInterface node) {
        final Node bidibNode = new Node();
        bidibNode.withUniqueId(node.getUniqueId());
        bidibNode.withVidPid(ByteUtils.getUniqueIdAsString(node.getUniqueId()));
        bidibNode.withProductName(node.getNode().getStoredString(StringData.INDEX_PRODUCTNAME));
        bidibNode.withUserName(node.getNode().getStoredString(StringData.INDEX_USERNAME));
        return bidibNode;
    }

    private void addSubNodes(final NodeProvider nodeProvider, final Node parentBidibNode, final List<NodeInterface> nodes) {
        for (NodeInterface node : nodes) {
            final Node bidibNode = createBidibNode(node);
            parentBidibNode.getNode().add(bidibNode);

            final List<NodeInterface> subNodes = nodeProvider.findSubNodes(node);
            if (CollectionUtils.isNotEmpty(subNodes)) {
                addSubNodes(nodeProvider, bidibNode, subNodes);
            }
        }
    }


}
