package org.bidib.wizard.mvc.main.view.component;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;

public class RemovePortConfirmDialog extends EscapeDialog {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(RemovePortConfirmDialog.class);

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, pref, 3dlu, pref:grow";

    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 10dlu, top:30dlu, 10dlu, pref";

    private int result = JOptionPane.CANCEL_OPTION;

    public RemovePortConfirmDialog(Frame frame, boolean modal) {
        super(frame, Resources.getString(RemovePortConfirmDialog.class, "title"), modal);

        getContentPane().setLayout(new BorderLayout());

        boolean debug = false;
        FormBuilder builder =
            FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).debug(debug);
        builder.border(Paddings.DIALOG);

        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));

        int row = 1;
        builder.add(iconLabel).xywh(1, row, 1, 2);

        JLabel messageLabel = new JLabel(Resources.getString(getClass(), "message-info"));
        Font font = messageLabel.getFont();
        font = font.deriveFont(16.0f);
        messageLabel.setFont(font);
        messageLabel.setForeground(UIManager.getColor("Console.red"));

        builder.add(messageLabel).xyw(3, row, 3);
        row += 2;

        JLabel messageInfoLabel = new JLabel(Resources.getString(getClass(), "message"));
        builder.add(messageInfoLabel).xyw(3, row, 3);
        row += 2;

        // buttons
        JButton continueButton = new JButton(Resources.getString(getClass(), "continue"));

        continueButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                fireContinue();
            }
        });

        JButton cancel = new JButton(Resources.getString(getClass(), "cancel"));

        cancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                fireCancel();
            }
        });

        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(continueButton, cancel).build();

        builder.add(buttons).xyw(3, row, 3);
        getContentPane().add(builder.build());

        pack();

        setLocationRelativeTo(frame);
        setMinimumSize(getSize());
        setVisible(true);
    }

    private void fireContinue() {
        LOGGER.info("Continue operation.");

        result = JOptionPane.YES_OPTION;
    }

    private void fireCancel() {

    }

    public int getResult() {
        return result;
    }
}
