/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.client.spring;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.WizardUtils;
import org.bidib.wizard.client.spring.SettingsLocationEnvironmentPostProcessor;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.ConfigDataEnvironmentUpdateListener;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ResourceLoader;

public class SettingsLocationEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int ORDER = -2147483641;
    private final Log logger;
    private final ConfigurableBootstrapContext bootstrapContext;
    private final ConfigDataEnvironmentUpdateListener environmentUpdateListener;
    private static final String WIZARD_SETTINGSFILE_LOCATION_REFERENCE = "wizard2.properties";
    private static final String WIZARD_SETTINGSFILE_LOCATION_PROPERTY = "wizard.settings.file-location";
    private static final String WIZARD_DEVELOPER_MODE_ENABLED_PROPERTY = "wizard.settings.developer-mode-enabled";
    private static final String WIZARD_CONFIGURATION_FILE_LOCATION_PROPERTY = "wizard.configuration.file-location";
    private String wizardConfigurationFileLocationReference;
    private Boolean developerModeEnabled = Boolean.FALSE;

    public SettingsLocationEnvironmentPostProcessor(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext) {
        this(logFactory, bootstrapContext, null);
    }

    public SettingsLocationEnvironmentPostProcessor(DeferredLogFactory logFactory, ConfigurableBootstrapContext bootstrapContext, ConfigDataEnvironmentUpdateListener environmentUpdateListener) {
        this.logger = logFactory.getLog(this.getClass());
        this.bootstrapContext = bootstrapContext;
        this.environmentUpdateListener = environmentUpdateListener;
    }

    public int getOrder() {
        return -2147483641;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        this.postProcessEnvironment(environment, application.getResourceLoader(), (Collection)application.getAdditionalProfiles());
    }

    void postProcessEnvironment(ConfigurableEnvironment environment, ResourceLoader resourceLoader, Collection<String> additionalProfiles) {
        try {
            this.wizardConfigurationFileLocationReference = environment.getProperty(WIZARD_SETTINGSFILE_LOCATION_PROPERTY, "${user.home}/.bidib");
            this.wizardConfigurationFileLocationReference = environment.resolvePlaceholders(this.wizardConfigurationFileLocationReference);
            this.logger.info((Object)("Location of settings file location reference: " + this.wizardConfigurationFileLocationReference));
            File file = new File(this.wizardConfigurationFileLocationReference, WIZARD_SETTINGSFILE_LOCATION_REFERENCE);
            if (!file.exists()) {
                this.logger.info((Object)"The settings file location reference was not found.");
                this.selectLocation(environment, file);
            } else {
                this.logger.info((Object)"The settings file location reference was found.");
                try (FileInputStream is = new FileInputStream(file);){
                    Properties props = new Properties();
                    props.load(is);
                    this.wizardConfigurationFileLocationReference = props.getProperty(WIZARD_SETTINGSFILE_LOCATION_PROPERTY);
                    this.developerModeEnabled = Boolean.parseBoolean(props.getProperty(WIZARD_DEVELOPER_MODE_ENABLED_PROPERTY, "false"));
                    this.logger.info((Object)("Read wizardSettingsFileLocationReference from location: " + file.getPath() + ", wizardConfigurationFileLocationReference: " + this.wizardConfigurationFileLocationReference + ", developerModeEnabled: " + this.developerModeEnabled));
                    File location = new File(this.wizardConfigurationFileLocationReference);
                    if (!location.exists()) {
                        try {
                            FileUtils.forceMkdir((File)location);
                        }
                        catch (Exception ex) {
                            this.logger.warn((Object)"Create directory for wizardSettingsFiles failed.", (Throwable)ex);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.warn((Object)("Failed to read the wizardSettingsFileLocationReference from location: " + file.getPath()), (Throwable)ex);
                    throw new RuntimeException("Failed to read the wizardSettingsFileLocationReference from location: " + file.getPath());
                }
            }
            environment.getSystemProperties().put(WIZARD_CONFIGURATION_FILE_LOCATION_PROPERTY, this.wizardConfigurationFileLocationReference);
            environment.getSystemProperties().put(WIZARD_DEVELOPER_MODE_ENABLED_PROPERTY, this.developerModeEnabled);
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Fetch the location of settings file location reference failed.", (Throwable)ex);
        }
    }

    private void selectLocation(ConfigurableEnvironment environment, File file) {
        String userHome = environment.resolvePlaceholders("${user.home}");
        this.logger.info((Object)"Select the location for wizard settings files.");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            this.logger.warn((Object)"Set look and feel failed", (Throwable)ex);
        }
        boolean foundAndUseOldLocation = false;
        boolean copyWizardConfigFromOldLocation = false;
        try {
            File oldWizardConfigurationFile = new File(userHome, ".bidib/wizard.yml");
            if (oldWizardConfigurationFile.exists()) {
                this.logger.info((Object)("Found the wizard.yml in the old default directory: " + oldWizardConfigurationFile.getPath()));
                int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(null), Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"keep-old-location.message", (Object[])new Object[]{oldWizardConfigurationFile.getParentFile().getPath()}), Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"keep-old-location.title"), 0, 3);
                if (result == 0) {
                    this.logger.info((Object)"User accepted to use old configuration location.");
                    this.wizardConfigurationFileLocationReference = oldWizardConfigurationFile.getParentFile().getPath();
                    this.logger.info((Object)("Found and use the configuration from the old location: " + this.wizardConfigurationFileLocationReference));
                    foundAndUseOldLocation = true;
                } else {
                    this.logger.info((Object)"User declined to use old configuration location.");
                    copyWizardConfigFromOldLocation = true;
                }
            }
        }
        catch (Exception ex) {
            this.logger.warn((Object)"Check if the wizard.yml exists in the 'old default directory' failed.", (Throwable)ex);
        }
        if (!foundAndUseOldLocation) {
            File defaultDirectory = new File(userHome, WizardUtils.getDefaultConfigSubDir());
            this.logger.info((Object)("Prepared the default location directory: " + defaultDirectory.getPath()));
            this.logger.info((Object)"Prepare and show the settings location dialog.");
            SettingsLocationDialog chooser = new SettingsLocationDialog(null, this.logger, defaultDirectory, location -> {
                this.wizardConfigurationFileLocationReference = location.getPath();
                if (!location.exists()) {
                    this.logger.info((Object)("The selected location does not exist and will be created: " + this.wizardConfigurationFileLocationReference));
                    try {
                        FileUtils.forceMkdir((File)location);
                    }
                    catch (Exception ex) {
                        this.logger.warn((Object)"Create directory for wizardSettingsFiles failed.", (Throwable)ex);
                    }
                } else {
                    this.logger.info((Object)("The selected location does exist: " + this.wizardConfigurationFileLocationReference));
                }
            });
            chooser.setVisible(null);
            this.logger.info((Object)("Use the wizardSettingsFileLocationReference: " + this.wizardConfigurationFileLocationReference));
        }
        if (!file.getParentFile().exists()) {
            try {
                FileUtils.forceMkdir((File)file.getParentFile());
            }
            catch (Exception ex) {
                this.logger.warn((Object)"Create directory for wizardSettingsFileLocationReference failed.", (Throwable)ex);
            }
        }
        try (FileOutputStream os = new FileOutputStream(file);){
            Properties props = new Properties();
            props.put(WIZARD_SETTINGSFILE_LOCATION_PROPERTY, this.wizardConfigurationFileLocationReference);
            props.store(os, "Added by Wizard 2");
            this.logger.info((Object)("Wrote wizardSettingsFileLocationReference to location: " + file.getPath()));
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Write the wizardSettingsFileLocationReference failed: " + String.valueOf(file)), (Throwable)ex);
            throw new RuntimeException("Write the wizardSettingsFileLocationReference failed: " + String.valueOf(file));
        }
        if (copyWizardConfigFromOldLocation) {
            try {
                File oldDirectory = new File(userHome, ".bidib");
                File newLocationConfigurationFile = new File(this.wizardConfigurationFileLocationReference, "wizard.yml");
                if (!newLocationConfigurationFile.exists()) {
                    this.logger.info((Object)"copy the existing wizard configuration files to the new location.");
                    int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(null), Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"copy-config-from-old-location.message", (Object[])new Object[]{oldDirectory.getPath()}), Resources.getString(SettingsLocationEnvironmentPostProcessor.class, (String)"copy-config-from-old-location.title"), 0, 3);
                    if (result == 0) {
                        this.logger.info((Object)"User accepted to copy existing configuration files.");
                        File oldWizardConfigurationFile = new File(oldDirectory, "wizard.yml");
                        this.copyFile(oldWizardConfigurationFile, newLocationConfigurationFile);
                        WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{"wizardmodule_*.yml"}).get();
                        File[] files = oldDirectory.listFiles((FileFilter)fileFilter);
                        if (files != null && files.length > 0) {
                            for (File sourceFile : files) {
                                File targetFile = new File(this.wizardConfigurationFileLocationReference, sourceFile.getName());
                                this.copyFile(sourceFile, targetFile);
                            }
                        } else {
                            this.logger.info((Object)"No wizard module configuration files found.");
                        }
                    } else {
                        this.logger.info((Object)"User declined to copy existing configuration files.");
                    }
                } else {
                    this.logger.info((Object)"The wizard configuration file exists in the new location already. Skip copy existing files.");
                }
            }
            catch (Exception ex) {
                this.logger.warn((Object)("Write the wizardSettingsFileLocationReference failed: " + String.valueOf(file)), (Throwable)ex);
            }
        }
    }

    private void copyFile(File source, File target) {
        try (FileInputStream sourceStream = new FileInputStream(source);
             FileOutputStream targetStream = new FileOutputStream(target);){
            IOUtils.copy((InputStream)sourceStream, (OutputStream)targetStream);
        }
        catch (Exception ex) {
            this.logger.warn((Object)("Copy configuration file failed: " + String.valueOf(source)), (Throwable)ex);
        }
    }
}

