/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.logback;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class CleanAtStartRollingFileAppender<E>
extends RollingFileAppender<E> {
    public void start() {
        if (!this.append) {
            this.deleteBackupFiles();
        }
        super.start();
    }

    private void deleteBackupFiles() {
        this.addInfo("Delete logfiles before start appender.");
        try {
            RollingPolicy triggeringPolicy;
            String currentFileName = super.getFile();
            File currentFile = new File(currentFileName);
            if (currentFile.exists()) {
                this.addInfo("Delete the current file: " + currentFileName);
                currentFile.delete();
            }
            if ((triggeringPolicy = this.getRollingPolicy()) instanceof RollingPolicyBase) {
                RollingPolicyBase base = (RollingPolicyBase)triggeringPolicy;
                Context context = this.getContext();
                FileNamePattern fileNamePattern = new FileNamePattern(base.getFileNamePattern(), context);
                if (fileNamePattern != null && this.fileName != null) {
                    String regex = fileNamePattern.toRegex();
                    this.addInfo("Current filename regex: " + regex);
                    File dir = new File(this.fileName).getParentFile();
                    String path = dir.getPath();
                    path = FileFilterUtil.slashify((String)path);
                    RegexFileFilter fileFilter = new RegexFileFilter(regex.substring(path.length() + 1));
                    File[] files = dir.listFiles((FileFilter)fileFilter);
                    for (int i = 0; i < files.length; ++i) {
                        files[i].delete();
                    }
                }
            }
        }
        catch (Exception ex) {
            this.addWarn("Delete existing logfiles failed.", (Throwable)ex);
        }
    }
}

