/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.controller;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.extras.FlatAnimatedLafChange;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.jserialcomm.PortIdentifierUtils;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.exception.InvalidLibraryException;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.jbidibc.scm.ScmPortIdentifierUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.api.model.event.ConsoleMessageEvent;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.client.common.preferences.view.panel.SettingsPanelInterface;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.Misc2SettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.model.settings.types.LookAndFeel;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.core.model.settings.ExperimentalSettings;
import org.bidib.wizard.core.model.settings.GlobalSettings;
import org.bidib.wizard.core.model.settings.Misc2Settings;
import org.bidib.wizard.core.model.settings.MiscSettings;
import org.bidib.wizard.core.model.settings.NetBidibSettings;
import org.bidib.wizard.core.model.settings.WizardSettings;
import org.bidib.wizard.core.utils.AopUtils;
import org.bidib.wizard.mvc.preferences.model.PreferencesModel;
import org.bidib.wizard.mvc.preferences.view.PreferencesView;
import org.bidib.wizard.mvc.preferences.view.listener.PreferencesViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.togglz.core.manager.FeatureManager;

public class PreferencesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesController.class);
    private final JFrame parent;
    private PreferencesModel model;
    @Autowired
    private GlobalSettingsInterface globalSettings;
    @Autowired
    private WizardSettingsInterface wizardSettings;
    @Autowired
    private MiscSettingsInterface miscSettings;
    @Autowired
    private Misc2SettingsInterface misc2Settings;
    @Autowired
    private ExperimentalSettingsInterface experimentalSettings;
    @Autowired
    private NetBidibSettingsInterface netBidibSettings;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private PairingStore pairingStore;
    @Autowired
    private ObjectMapper serializingObjectMapper;
    @Autowired
    private LookupService lookupService;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private ApplicationEventPublisher errorEventPublisher;
    private final List<SettingsPanelInterface> settingsPanelInterfaces;

    public PreferencesController(JFrame parent, List<SettingsPanelInterface> settingsPanelInterfaces) {
        this.parent = parent;
        this.settingsPanelInterfaces = settingsPanelInterfaces;
    }

    private void loadCommPorts() {
        if (this.globalSettings.isSerialPortsEnabled()) {
            LOGGER.info("Load the comm ports, model: {}", (Object)this.model);
            HashSet<CommPort> commPorts = new HashSet<CommPort>();
            try {
                Set detectedComPorts = this.lookupService.getDetectedComPorts();
                List portIdentifiers = null;
                switch (this.miscSettings.getSelectedSerialPortProvider()) {
                    case "SCM": {
                        portIdentifiers = ScmPortIdentifierUtils.getPortIdentifiers();
                        break;
                    }
                    case "SPSW": {
                        portIdentifiers = org.bidib.jbidibc.purejavacomm.PortIdentifierUtils.getPortIdentifiers();
                        break;
                    }
                    case "JSerialComm": {
                        portIdentifiers = PortIdentifierUtils.getPortIdentifiers();
                        break;
                    }
                    case "PureJavaComm": {
                        portIdentifiers = org.bidib.jbidibc.purejavacomm.PortIdentifierUtils.getPortIdentifiers();
                        break;
                    }
                    case "FTDI": {
                        portIdentifiers = org.bidib.jbidibc.ftdi.serial.PortIdentifierUtils.getPortIdentifiers();
                        break;
                    }
                    default: {
                        portIdentifiers = org.bidib.jbidibc.rxtx.PortIdentifierUtils.getPortIdentifiers();
                    }
                }
                if (portIdentifiers != null) {
                    for (String id : portIdentifiers) {
                        LOGGER.info("Add new CommPort with id: {}", (Object)id);
                        CommPort detectedComPort = null;
                        for (CommPort commPort : detectedComPorts) {
                            if (!id.equals(commPort.getName())) continue;
                            detectedComPort = commPort;
                            LOGGER.info("Found detected comm port: {}", (Object)detectedComPort);
                            break;
                        }
                        if (detectedComPort != null) {
                            commPorts.add(detectedComPort);
                            continue;
                        }
                        commPorts.add(new CommPort(id));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)this.globalSettings.getPreviousSelectedComPort())) {
                    LOGGER.info("Add the previous selected COM Port: {}", (Object)this.globalSettings.getPreviousSelectedComPort());
                    commPorts.add(new CommPort(this.globalSettings.getPreviousSelectedComPort().trim()));
                }
            }
            catch (InvalidLibraryException ex) {
                LOGGER.warn("Fetch port identifiers failed. This can be caused because the ext/lib directory of the Java installation contains an old RXTXComm.jar!", (Throwable)ex);
                JOptionPane.showMessageDialog(this.parent, Resources.getString(PreferencesController.class, (String)"fetch-port-identifiers-failed", (Object[])new Object[]{new File(SystemUtils.getJavaHome(), "lib/ext").getPath()}), Resources.getString(PreferencesController.class, (String)"title-error"), 0);
            }
            catch (Exception ex) {
                LOGGER.warn("Fetch port identifiers failed.", (Throwable)ex);
            }
            this.model.setAvailableCommPorts(commPorts);
        } else {
            LOGGER.info("No comm ports loaded because serial enabled flag is not set.");
        }
    }

    private void loadNetBidibServices() {
        try {
            Set detectedNetBidibServices = this.lookupService.getDetectedNetBidibServices();
            this.model.setDetectedNetBidibServices(detectedNetBidibServices);
        }
        catch (Exception ex) {
            LOGGER.warn("Fetch netBidib services failed.", (Throwable)ex);
            this.model.setDetectedNetBidibServices(Collections.emptySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LOGGER.debug("Start the preferences controller.");
        try {
            GlobalSettings globalSettings = (GlobalSettings)this.serializingObjectMapper.treeToValue((TreeNode)this.serializingObjectMapper.valueToTree(AopUtils.getTargetObject((Object)this.globalSettings)), GlobalSettings.class);
            WizardSettingsInterface wizardSettings = (WizardSettingsInterface)this.serializingObjectMapper.treeToValue((TreeNode)this.serializingObjectMapper.valueToTree(AopUtils.getTargetObject((Object)this.wizardSettings)), WizardSettings.class);
            MiscSettingsInterface miscSettings = (MiscSettingsInterface)this.serializingObjectMapper.treeToValue((TreeNode)this.serializingObjectMapper.valueToTree(AopUtils.getTargetObject((Object)this.miscSettings)), MiscSettings.class);
            Misc2SettingsInterface misc2Settings = (Misc2SettingsInterface)this.serializingObjectMapper.treeToValue((TreeNode)this.serializingObjectMapper.valueToTree(AopUtils.getTargetObject((Object)this.misc2Settings)), Misc2Settings.class);
            ExperimentalSettingsInterface experimentalSettings = (ExperimentalSettingsInterface)this.serializingObjectMapper.treeToValue((TreeNode)this.serializingObjectMapper.valueToTree(AopUtils.getTargetObject((Object)this.experimentalSettings)), ExperimentalSettings.class);
            NetBidibSettingsInterface netBidibSettings = (NetBidibSettingsInterface)this.serializingObjectMapper.treeToValue((TreeNode)this.serializingObjectMapper.valueToTree(AopUtils.getTargetObject((Object)this.netBidibSettings)), NetBidibSettings.class);
            this.model = new PreferencesModel((GlobalSettingsInterface)globalSettings, wizardSettings, miscSettings, misc2Settings, experimentalSettings, netBidibSettings, this.pairingStore);
            if (globalSettings.isSerialPortsEnabled()) {
                LOGGER.info("Load the comm ports of the system.");
                this.loadCommPorts();
            }
            if (globalSettings.isNetBidibEnabled()) {
                LOGGER.info("Load the detected netBidib services of the system.");
                this.loadNetBidibServices();
            }
            PreferencesView view = new PreferencesView(this.parent, this.model, this.settingsPanelInterfaces, this.featureManager);
            PropertyChangeListener pcl = evt -> {
                LOGGER.info("The look and feel has been changed. New value: {}", evt.getNewValue());
                LookAndFeel lookAndFeel = experimentalSettings.getLookAndFeel();
                FlatAnimatedLafChange.showSnapshot();
                try {
                    UIManager.setLookAndFeel((javax.swing.LookAndFeel)(lookAndFeel == LookAndFeel.FlatLight ? new FlatLightLaf() : new FlatDarkLaf()));
                }
                catch (Exception ex) {
                    LOGGER.warn("Set L&F failed.", (Throwable)ex);
                }
                FlatLaf.updateUI();
                FlatAnimatedLafChange.hideSnapshotWithAnimation();
            };
            try {
                this.experimentalSettings.addPropertyChangeListener("lookAndFeel", pcl);
                view.addPreferencesViewListener((PreferencesViewListener)new /* Unavailable Anonymous Inner Class!! */);
                view.showView();
            }
            finally {
                LOGGER.info("The preferences view was closed.");
                this.experimentalSettings.removePropertyChangeListener("lookAndFeel", pcl);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Prepare and open preferences view failed.", (Throwable)ex);
        }
    }

    private void handleError(RuntimeException ex) {
        LOGGER.warn("Handle error from underlying components: {}", (Object)ex.getMessage());
        ConsoleMessageEvent errorEvent = ex instanceof InvalidConfigurationException ? new ConsoleMessageEvent(ConsoleColor.red, ex.getMessage()) : new ConsoleMessageEvent(ConsoleColor.red, ex.getMessage());
        this.errorEventPublisher.publishEvent((Object)errorEvent);
    }
}

