/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadCheckingRepaintManager
extends RepaintManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadCheckingRepaintManager.class);
    private boolean completeCheck = true;
    private boolean checkIsShowing = false;

    public ThreadCheckingRepaintManager() {
    }

    public ThreadCheckingRepaintManager(boolean checkIsShowing) {
        this.checkIsShowing = checkIsShowing;
    }

    public boolean isCompleteCheck() {
        return this.completeCheck;
    }

    public void setCompleteCheck(boolean completeCheck) {
        this.completeCheck = completeCheck;
    }

    @Override
    public synchronized void addInvalidComponent(JComponent jComponent) {
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    @Override
    public synchronized void addDirtyRegion(JComponent jComponent, int x, int y, int width, int height) {
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, x, y, width, height);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.completeCheck || this.checkIsShowing(c))) {
            StackTraceElement[] stackTrace;
            Exception exception = new Exception();
            boolean repaint = false;
            boolean fromSwing = false;
            for (StackTraceElement st : stackTrace = exception.getStackTrace()) {
                if (repaint && st.getClassName().startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (!"repaint".equals(st.getMethodName())) continue;
                repaint = true;
            }
            if (repaint && !fromSwing) {
                return;
            }
            LOGGER.warn("----------Wrong Thread START");
            LOGGER.warn(this.getStrackTraceAsString(exception));
            LOGGER.warn("----------Wrong Thread END");
        }
    }

    private boolean checkIsShowing(JComponent c) {
        if (this.checkIsShowing) {
            return c.isShowing();
        }
        return true;
    }

    private String getStrackTraceAsString(Exception e) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        e.printStackTrace(printStream);
        printStream.flush();
        return byteArrayOutputStream.toString();
    }
}

