package org.bidib.wizard.mvc.main.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.SoftwareVersion;

import com.jgoodies.binding.beans.Model;

public class InfoModel extends Model {

    public static final String PROPERTY_DESCRIPTION = "description";

    public static final String PROPERTY_PRODUCTNAME = "productName";

    public static final String PROPERTY_VENDOR = "vendor";

    public static final String PROPERTY_HOMEPAGE = "homepage";

    public static final String PROPERTY_UNIQUEID = "uniqueId";

    public static final String PROPERTY_USERNAME = "userName";

    public static final String PROPERTY_ADDRESS = "address";

    public static final String PROPERTY_FIRMWARE = "firmware";

    public static final String PROPERTY_PROTOCOL = "protocol";

    public static final String PROPERTY_FEATURES = "features";

    private String description;

    private String productName;

    private String vendor;

    private String homepage;

    private Long uniqueId;

    private String userName;

    private String address;

    private SoftwareVersion firmware;

    private String protocol;

    private final List<Feature> features = new ArrayList<>();

    public InfoModel() {
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        String oldValue = this.description;
        this.description = description;

        firePropertyChange(PROPERTY_DESCRIPTION, oldValue, description);
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        String oldValue = this.productName;
        this.productName = productName;

        firePropertyChange(PROPERTY_PRODUCTNAME, oldValue, productName);
    }

    public String getVendor() {
        return vendor;
    }

    public void setVendor(String vendor) {
        String oldValue = this.vendor;
        this.vendor = vendor;

        firePropertyChange(PROPERTY_VENDOR, oldValue, vendor);
    }

    public String getHomepage() {
        return homepage;
    }

    public void setHomepage(String homepage) {
        String oldValue = this.homepage;
        this.homepage = homepage;

        firePropertyChange(PROPERTY_HOMEPAGE, oldValue, homepage);
    }

    public Long getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        Long oldValue = this.uniqueId;
        this.uniqueId = uniqueId;

        firePropertyChange(PROPERTY_UNIQUEID, oldValue, uniqueId);
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        String oldValue = this.userName;
        this.userName = userName;

        firePropertyChange(PROPERTY_USERNAME, oldValue, userName);
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        String oldValue = this.address;
        this.address = address;

        firePropertyChange(PROPERTY_ADDRESS, oldValue, address);
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        String oldValue = this.protocol;
        this.protocol = protocol;

        firePropertyChange(PROPERTY_PROTOCOL, oldValue, protocol);
    }

    public SoftwareVersion getFirmware() {
        return firmware;
    }

    public void setFirmware(SoftwareVersion firmware) {
        SoftwareVersion oldValue = this.firmware;
        this.firmware = firmware;

        firePropertyChange(PROPERTY_FIRMWARE, oldValue, firmware);
    }

    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(features);
    }

    public void setFeatures(List<Feature> features) {
        List<Feature> oldValue = new ArrayList<>(this.features);
        this.features.clear();
        if (features != null) {
            this.features.addAll(features);
        }

        firePropertyChange(PROPERTY_FEATURES, oldValue, this.features);
    }
}
