package org.bidib.wizard.mvc.main.view.table;

import javax.swing.JComboBox;

import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.client.common.view.renderer.PortRenderer;

public class PortComboBoxEditor<E extends Port<?>> extends ComboBoxEditor<E> {

    private static final long serialVersionUID = 1L;

    public PortComboBoxEditor(JComboBox<E> combobox) {
        super(combobox);
    }

    public static <E extends Port<?>> PortComboBoxEditor<E> prepareEditor(E[] items, final String emptyPortLabel) {

        JComboBox<E> comboBox = new JComboBox<>(items);
        comboBox.setRenderer(new PortRenderer(emptyPortLabel));

        PortComboBoxEditor<E> editor = new PortComboBoxEditor<>(comboBox);

        return editor;
    }
}
