package org.bidib.wizard.mvc.preferences.model;

import java.time.LocalDateTime;
import java.util.Objects;

import org.bidib.jbidibc.messages.ProtocolVersion;

import com.jgoodies.binding.beans.Model;

public class PairingStoreEntryModel extends Model {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_UID = "uid";

    public static final String PROPERTY_REQUESTOR_NAME = "requestorName";

    public static final String PROPERTY_PRODUCT_NAME = "productName";

    public static final String PROPERTY_USER_NAME = "userName";

    public static final String PROPERTY_PROTOCOL_VERSION = "protocolVersion";

    public static final String PROPERTY_PAIRED = "paired";

    public static final String PROPERTY_LAST_SEEN = "lastSeen";

    private String uid;

    private String requestorName;

    private String productName;

    private String userName;

    private ProtocolVersion protocolVersion;

    private boolean paired;

    private LocalDateTime lastSeen;

    public PairingStoreEntryModel() {

    }

    /**
     * @return the uid
     */
    public String getUid() {
        return uid;
    }

    /**
     * @param uid
     *            the uid to set
     */
    public void setUid(String uid) {
        String oldValue = this.uid;
        this.uid = uid;

        firePropertyChange(PROPERTY_UID, oldValue, uid);
    }

    /**
     * @return the requestorName
     */
    public String getRequestorName() {
        return requestorName;
    }

    /**
     * @param requestorName
     *            the requestorName to set
     */
    public void setRequestorName(String requestorName) {
        String oldValue = this.requestorName;
        this.requestorName = requestorName;

        firePropertyChange(PROPERTY_REQUESTOR_NAME, oldValue, requestorName);
    }

    /**
     * @return the productName
     */
    public String getProductName() {
        return productName;
    }

    /**
     * @param productName
     *            the productName to set
     */
    public void setProductName(String productName) {
        String oldValue = this.productName;
        this.productName = productName;

        firePropertyChange(PROPERTY_PRODUCT_NAME, oldValue, productName);
    }

    /**
     * @return the userName
     */
    public String getUserName() {
        return userName;
    }

    /**
     * @param userName
     *            the userName to set
     */
    public void setUserName(String userName) {
        String oldValue = this.userName;
        this.userName = userName;

        firePropertyChange(PROPERTY_USER_NAME, oldValue, userName);
    }

    /**
     * @return the protocolVersion
     */
    public ProtocolVersion getProtocolVersion() {
        return protocolVersion;
    }

    /**
     * @param protocolVersion
     *            the protocolVersion to set
     */
    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        ProtocolVersion oldValue = this.protocolVersion;
        this.protocolVersion = protocolVersion;

        firePropertyChange(PROPERTY_PROTOCOL_VERSION, oldValue, protocolVersion);
    }

    /**
     * @return the paired
     */
    public boolean isPaired() {
        return paired;
    }

    /**
     * @param paired
     *            the paired to set
     */
    public void setPaired(boolean paired) {
        boolean oldValue = this.paired;
        this.paired = paired;

        firePropertyChange(PROPERTY_PAIRED, oldValue, paired);
    }

    /**
     * @return the lastSeen
     */
    public LocalDateTime getLastSeen() {
        return lastSeen;
    }

    /**
     * @param lastSeen
     *            the lastSeen to set
     */
    public void setLastSeen(LocalDateTime lastSeen) {
        LocalDateTime oldValue = this.lastSeen;
        this.lastSeen = lastSeen;

        firePropertyChange(PROPERTY_LAST_SEEN, oldValue, lastSeen);
    }

    @Override
    public int hashCode() {
        return Objects.hash(lastSeen, paired, productName, protocolVersion, requestorName, uid, userName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        PairingStoreEntryModel other = (PairingStoreEntryModel) obj;
        return Objects.equals(lastSeen, other.lastSeen) && paired == other.paired
            && Objects.equals(productName, other.productName) && Objects.equals(protocolVersion, other.protocolVersion)
            && Objects.equals(requestorName, other.requestorName) && Objects.equals(uid, other.uid)
            && Objects.equals(userName, other.userName);
    }

}
