/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.menu;

import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuListener;
import javax.xml.parsers.ParserConfigurationException;
import org.bidib.api.json.types.ConnectionPhase;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.NodeListener;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.ConnectionConfiguration;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.LocalHostSettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.menu.DockingFramesRegistry;
import org.bidib.wizard.mvc.main.view.menu.MainMenuBar;
import org.bidib.wizard.mvc.main.view.menu.NodeListMenu;
import org.bidib.wizard.mvc.main.view.menu.WindowListMenu;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class MainMenuBar
extends JMenuBar
implements NodeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainMenuBar.class);
    private static final long serialVersionUID = 1L;
    private final NodeListMenu nodeListMenu;
    private final WindowListMenu windowListMenu;
    private NodeInterface selectedNode;
    private DockingFramesRegistry dockingFramesRegistry;
    private JMenuItem connectItem;
    private JMenuItem disconnectItem;
    private JMenuItem listenNetBidibItem;
    private JMenuItem dccAdvItem;
    private JMenuItem debugInterfaceItem;
    private JMenuItem netDebugItem;
    private JMenuItem debugConsoleItem;
    private JMenuItem tracerClientItem;
    private JMenuItem nodesClientButton;
    private JMenuItem localHostClientItem;
    private JMenuItem scriptClientButton;
    private JMenuItem discoverySingleListServicesButton;
    private final DockingDesktop desktop;
    private final DockingContext dockingContext;
    private final GlobalSettingsInterface globalSettings;
    private final MiscSettingsInterface miscSettings;
    private final LocalHostSettingsInterface localHostSettings;
    private final ConnectionPhaseModel connectionPhaseModel;
    private final MainMenuListener mainMenuListener;

    public MainMenuBar(MainModel mainModel, DockingDesktop desktop, DockingContext dockingContext, SettingsService settingsService, ConnectionPhaseModel connectionPhaseModel, MainMenuListener mainMenuListener, WizardLabelWrapper wizardLabelWrapper) {
        this.desktop = desktop;
        this.dockingContext = dockingContext;
        this.connectionPhaseModel = connectionPhaseModel;
        this.mainMenuListener = mainMenuListener;
        this.globalSettings = settingsService.getGlobalSettings();
        this.miscSettings = settingsService.getMiscSettings();
        this.localHostSettings = settingsService.getLocalHostSettings();
        this.addDockableStateChangeListener(desktop);
        this.windowListMenu = new WindowListMenu(this.dockingFramesRegistry);
        this.nodeListMenu = new NodeListMenu(mainModel, settingsService, wizardLabelWrapper);
        JMenu fileMenu = new JMenu(Resources.getString(this.getClass(), (String)"file"));
        this.connectItem = new JMenuItem(Resources.getString(this.getClass(), (String)"connect"));
        this.connectItem.setAccelerator(KeyStroke.getKeyStroke(67, 8));
        this.connectItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        fileMenu.add(this.connectItem);
        this.disconnectItem = new JMenuItem(Resources.getString(this.getClass(), (String)"disconnect"));
        this.disconnectItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.disconnectItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.disconnectItem.setEnabled(false);
        fileMenu.add(this.disconnectItem);
        this.listenNetBidibItem = new JMenuItem(Resources.getString(this.getClass(), (String)"listenNetBidib"));
        this.listenNetBidibItem.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this.listenNetBidibItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.listenNetBidibItem.setEnabled(false);
        fileMenu.add(this.listenNetBidibItem);
        fileMenu.addSeparator();
        this.enableListenNetBidibItem();
        JMenuItem exitItem = new JMenuItem(Resources.getString(this.getClass(), (String)"quit"));
        exitItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        exitItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        fileMenu.add(exitItem);
        this.add(fileMenu);
        JMenu editMenu = new JMenu(Resources.getString(this.getClass(), (String)"edit"));
        JMenuItem preferencesItem = new JMenuItem(Resources.getString(this.getClass(), (String)"preferences") + " ...");
        preferencesItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        editMenu.add(preferencesItem);
        this.add(editMenu);
        JMenu nodeMenu = this.nodeListMenu.getJMenu();
        nodeMenu.addMenuListener((MenuListener)new /* Unavailable Anonymous Inner Class!! */);
        nodeMenu.setEnabled(false);
        nodeMenu.setText(Resources.getString(this.getClass(), (String)"node"));
        this.add(nodeMenu);
        mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
        JMenu framesMenu = this.windowListMenu.getJMenu();
        JMenuItem saveWorkspaceItem = new JMenuItem(Resources.getString(this.getClass(), (String)"saveWorkspace"));
        saveWorkspaceItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        saveWorkspaceItem.setEnabled(true);
        this.windowListMenu.addTopItem(saveWorkspaceItem);
        JMenuItem loadWorkspaceItem = new JMenuItem(Resources.getString(this.getClass(), (String)"loadWorkspace"));
        loadWorkspaceItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        loadWorkspaceItem.setEnabled(true);
        this.windowListMenu.addTopItem(loadWorkspaceItem);
        JMenuItem loadDefaultWorkspaceItem = new JMenuItem(Resources.getString(this.getClass(), (String)"loadDefaultWorkspace"));
        loadDefaultWorkspaceItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.windowListMenu.addTopItem(loadDefaultWorkspaceItem);
        JMenuItem boosterTableItem = new JMenuItem(Resources.getString(this.getClass(), (String)"boosterTable"));
        boosterTableItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        String dockKeyKey = "BoosterTableView";
        this.windowListMenu.addStickyItem(dockKeyKey, boosterTableItem);
        JMenuItem feedbackPositionTableItem = new JMenuItem(Resources.getString(this.getClass(), (String)"feedbackPositionTable"));
        feedbackPositionTableItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        dockKeyKey = "FeedbackPositionTableView";
        this.windowListMenu.addStickyItem(dockKeyKey, feedbackPositionTableItem);
        JMenuItem consoleItem = new JMenuItem(Resources.getString(this.getClass(), (String)"console"));
        consoleItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        dockKeyKey = "ConsoleView";
        this.windowListMenu.addStickyItem(dockKeyKey, consoleItem);
        framesMenu.addMenuListener((MenuListener)new /* Unavailable Anonymous Inner Class!! */);
        framesMenu.setText(Resources.getString(this.getClass(), (String)"window"));
        this.add(framesMenu);
        JMenu toolsMenu = new JMenu(Resources.getString(this.getClass(), (String)"tools"));
        JMenuItem nodeScriptItem = new JMenuItem(Resources.getString(this.getClass(), (String)"nodeScript"));
        nodeScriptItem.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        nodeScriptItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        toolsMenu.add(nodeScriptItem);
        JMenuItem firmwareRepoItem = new JMenuItem(Resources.getString(this.getClass(), (String)"firmwareRepo"));
        firmwareRepoItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        toolsMenu.add(firmwareRepoItem);
        this.nodesClientButton = new JMenuItem(Resources.getString(this.getClass(), (String)"nodesClient"));
        this.nodesClientButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.nodesClientButton.setEnabled(false);
        toolsMenu.add(this.nodesClientButton);
        JMenu developerToolsMenu = new JMenu(Resources.getString(this.getClass(), (String)"developerTools"));
        toolsMenu.add(developerToolsMenu);
        JMenuItem rxtxLogPanelItem = new JMenuItem(Resources.getString(this.getClass(), (String)"rxtxLogPanel"));
        rxtxLogPanelItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        rxtxLogPanelItem.setEnabled(true);
        developerToolsMenu.add(rxtxLogPanelItem);
        JMenuItem firmwareArchiveValidationItem = new JMenuItem(Resources.getString(this.getClass(), (String)"firmwareArchiveValidation"));
        firmwareArchiveValidationItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        firmwareArchiveValidationItem.setEnabled(true);
        developerToolsMenu.add(firmwareArchiveValidationItem);
        this.dccAdvItem = new JMenuItem(Resources.getString(this.getClass(), (String)"dccAdv"));
        this.dccAdvItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.dccAdvItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.dccAdvItem.setEnabled(false);
        toolsMenu.add(this.dccAdvItem);
        this.debugInterfaceItem = new JMenuItem(Resources.getString(this.getClass(), (String)"debugInterface"));
        this.debugInterfaceItem.setAccelerator(KeyStroke.getKeyStroke(73, 8));
        this.debugInterfaceItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.debugInterfaceItem.setEnabled(true);
        developerToolsMenu.add(this.debugInterfaceItem);
        this.netDebugItem = new JMenuItem(Resources.getString(this.getClass(), (String)"netDebug"));
        this.netDebugItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        this.netDebugItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.netDebugItem.setEnabled(true);
        developerToolsMenu.add(this.netDebugItem);
        this.debugConsoleItem = new JMenuItem(Resources.getString(this.getClass(), (String)"debugConsole"));
        this.debugConsoleItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.debugConsoleItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.debugConsoleItem.setEnabled(true);
        developerToolsMenu.add(this.debugConsoleItem);
        this.tracerClientItem = new JMenuItem(Resources.getString(this.getClass(), (String)"tracerClient"));
        this.tracerClientItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tracerClientItem.setEnabled(true);
        developerToolsMenu.add(this.tracerClientItem);
        JMenuItem pingTableItem = new JMenuItem(Resources.getString(this.getClass(), (String)"pingTable"));
        pingTableItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        developerToolsMenu.add(pingTableItem);
        this.localHostClientItem = new JMenuItem(Resources.getString(this.getClass(), (String)"localHostClient"));
        this.localHostClientItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.localHostClientItem.setEnabled(this.localHostSettings.isLocalHostClientEnabled() && this.localHostSettings.isLocalHostServiceEnabled());
        this.localHostSettings.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "localHostClientEnabled": 
                case "localHostServiceEnabled": {
                    this.localHostClientItem.setEnabled(this.localHostSettings.isLocalHostClientEnabled() && this.localHostSettings.isLocalHostServiceEnabled());
                    break;
                }
            }
        });
        developerToolsMenu.add(this.localHostClientItem);
        this.scriptClientButton = new JMenuItem(Resources.getString(this.getClass(), (String)"scriptClient"));
        this.scriptClientButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        developerToolsMenu.add(this.scriptClientButton);
        this.discoverySingleListServicesButton = new JMenuItem(Resources.getString(this.getClass(), (String)"discoverySingleListServices"));
        this.discoverySingleListServicesButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        developerToolsMenu.add(this.discoverySingleListServicesButton);
        this.add(toolsMenu);
        this.add(Box.createHorizontalGlue());
        JMenu helpMenu = new JMenu(Resources.getString(this.getClass(), (String)"help"));
        JMenuItem aboutItem = new JMenuItem(Resources.getString(this.getClass(), (String)"about") + " ...");
        aboutItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        helpMenu.add(aboutItem);
        JMenuItem checkForUpdatesItem = new JMenuItem(Resources.getString(this.getClass(), (String)"checkForUpdates") + " ...");
        checkForUpdatesItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        helpMenu.add(checkForUpdatesItem);
        JMenuItem logFilesItem = new JMenuItem(Resources.getString(this.getClass(), (String)"logFiles") + " ...");
        logFilesItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        helpMenu.add(logFilesItem);
        this.add(helpMenu);
    }

    public void enableListenNetBidibItem() {
        String connectionId = "main";
        ConnectionConfiguration connectionConfig = this.globalSettings.getConnectionConfigurations().stream().filter(cfg -> cfg.getId().equals(connectionId)).findFirst().orElse(null);
        if (connectionConfig != null && "NetBidibClient".equals(connectionConfig.getConnectionProvider())) {
            ConnectionPhase connectionPhase = this.connectionPhaseModel.getConnectionPhase();
            if (connectionPhase != null && ConnectionPhase.DISCONNECTED != connectionPhase) {
                this.listenNetBidibItem.setEnabled(false);
            }
        } else {
            this.listenNetBidibItem.setEnabled(false);
        }
    }

    protected void fireLoadDefaultWorkspace() {
        try (InputStream in = MainMenuBar.class.getResourceAsStream("/workspace/default-workspace.xml");){
            this.dockingContext.readXML(in);
        }
        catch (IOException | ParserConfigurationException | SAXException ioe) {
            LOGGER.warn("Load default workspace failed.", (Throwable)ioe);
        }
    }

    protected void fireLoadWorkspace() {
        String workspacePath = this.miscSettings.getWorkspacePath();
        File loadFile = null;
        try {
            loadFile = new File(workspacePath, "workspace.xml");
            LOGGER.info("Load workspace from file: {}", (Object)loadFile);
            if (!loadFile.getParentFile().exists()) {
                throw new IllegalArgumentException("The requested file is not available: " + String.valueOf(loadFile));
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Load workspace from file failed.", (Throwable)ex);
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)this), Resources.getString(MainMenuBar.class, (String)"invalid-load-workspace-path.message"), Resources.getString(MainMenuBar.class, (String)"invalid-workspace-path.title"), 0);
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(loadFile));){
            this.dockingContext.readXML((InputStream)in);
        }
        catch (IOException | ParserConfigurationException | SAXException ioe) {
            LOGGER.warn("Load workspace failed.", (Throwable)ioe);
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)this), Resources.getString(MainMenuBar.class, (String)"invalid-load-workspace-content.message"), Resources.getString(MainMenuBar.class, (String)"invalid-workspace-content.title"), 0);
        }
    }

    protected void fireSaveWorkspace() {
        String workspacePath = this.miscSettings.getWorkspacePath();
        File saveFile = null;
        try {
            saveFile = new File(workspacePath, "workspace.xml");
            LOGGER.info("Save workspace to file: {}", (Object)saveFile);
            if (!saveFile.getParentFile().exists() && !saveFile.getParentFile().mkdirs()) {
                LOGGER.warn("Create the directory to store the workspace failed: {}", (Object)saveFile.getParentFile());
                throw new IllegalArgumentException("The requested directory is not available: " + String.valueOf(saveFile.getParentFile()));
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Save workspace to file failed.", (Throwable)ex);
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)this), Resources.getString(MainMenuBar.class, (String)"invalid-save-workspace-path.message"), Resources.getString(MainMenuBar.class, (String)"invalid-workspace-path.title"), 0);
            return;
        }
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(saveFile));){
            this.desktop.writeXML((OutputStream)out);
        }
        catch (IOException ioe) {
            LOGGER.warn("Save workspace failed.", (Throwable)ioe);
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent((Component)this), Resources.getString(MainMenuBar.class, (String)"invalid-save-workspace-content.message", (Object[])new Object[]{saveFile.getPath()}), Resources.getString(MainMenuBar.class, (String)"invalid-workspace-content.title"), 0);
        }
    }

    private void internalNodeChanged(MainModel model, JMenu nodeMenu) {
        NodeInterface newNode;
        if (this.selectedNode != null) {
            this.selectedNode.removeNodeListener((NodeListener)this);
        }
        nodeMenu.setEnabled((newNode = model.getSelectedNode()) != null);
        if (newNode != null) {
            newNode.addNodeListener((NodeListener)this);
        }
        LOGGER.debug("Set the selected node: {}", (Object)newNode);
        this.setSelectedNode(newNode);
    }

    private void addDockableStateChangeListener(DockingDesktop desktop) {
        this.dockingFramesRegistry = new DockingFramesRegistry();
        32 listener = new /* Unavailable Anonymous Inner Class!! */;
        desktop.addDockableStateChangeListener((DockableStateChangeListener)listener);
    }

    public void addressMessagesEnabledChanged(NodeInterface node, Boolean isAddressMessagesEnabled) {
        this.nodeListMenu.setAddressMessagesEnabled(isAddressMessagesEnabled);
    }

    public void dccStartEnabledChanged(NodeInterface node, Boolean isDccStartEnabled) {
        this.nodeListMenu.setDccStartEnabled(isDccStartEnabled);
    }

    public void externalStartEnabledChanged(NodeInterface node, Boolean isExternalStartEnabled) {
        this.nodeListMenu.setExternalStartEnabled(isExternalStartEnabled);
    }

    public void dccAdvAvailableChanged(NodeInterface node, Boolean dccAdvAvailable) {
        this.nodeListMenu.setDccAdvEnabled(dccAdvAvailable);
        this.dccAdvItem.setEnabled(dccAdvAvailable != null && dccAdvAvailable != false);
    }

    public void feedbackMessagesEnabledChanged(NodeInterface node, Boolean isFeedbackMessagesEnabled) {
        this.nodeListMenu.setFeedbackMessagesEnabled(isFeedbackMessagesEnabled);
    }

    public void feedbackMirrorDisabledChanged(NodeInterface node, Boolean isFeedbackMirrorDisabled) {
        this.nodeListMenu.setFeedbackMirrorDisabled(isFeedbackMirrorDisabled);
    }

    private void fireBoosterTable() {
        this.mainMenuListener.boosterTable();
    }

    private void fireFeedbackPositionTable(MainModel mainModel) {
        this.mainMenuListener.feedbackPositionTable();
    }

    private void firePingTable() {
        this.mainMenuListener.pingTable();
    }

    private void fireRxTxLogPanel() {
        this.mainMenuListener.showRxTxLoggerView();
    }

    private void fireFirmwareArchiveValidation() {
        this.mainMenuListener.showFirmwareArchiveValidationView();
    }

    private void fireConsole() {
        this.mainMenuListener.console();
    }

    private void fireCheckForUpdates() {
        this.mainMenuListener.checkForUpdates();
    }

    private void fireCollectLogFiles() {
        this.mainMenuListener.collectLogFiles();
    }

    private void fireAbout() {
        this.mainMenuListener.about();
    }

    private void fireExit() {
        this.mainMenuListener.exit();
    }

    private void fireConnect() {
        this.mainMenuListener.connect();
    }

    private void fireDisconnect() {
        this.mainMenuListener.disconnect();
    }

    private void fireListenNetBidib() {
        this.mainMenuListener.listenNetBidib();
    }

    private void firePreferences() {
        this.mainMenuListener.preferences();
    }

    private void fireNodeScript(MainModel mainModel) {
        this.mainMenuListener.nodeScriptView();
    }

    private void fireAddAdv(MainModel mainModel) {
        this.mainMenuListener.dccAdv();
    }

    private void fireDebugInterface() {
        this.mainMenuListener.debugInterface();
    }

    private void fireNetDebug() {
        this.mainMenuListener.netDebug();
    }

    private void fireDebugConsole(MainModel mainModel) {
        this.mainMenuListener.debugConsole();
    }

    private void fireShowFirmwareRepo() {
        this.mainMenuListener.showFirmwareRepo();
    }

    private void fireShowNodesClient() {
        this.mainMenuListener.showNodesClient();
    }

    private void fireShowScriptClient() {
        this.mainMenuListener.showScriptClient();
    }

    private void fireShowTracerClient() {
        this.mainMenuListener.showRxTxLoggerView();
    }

    private void fireShowLocalHostClient() {
        this.mainMenuListener.showLocalHostClient();
    }

    private void fireDiscoverySingleListServicesButton() {
        this.mainMenuListener.discoverySingleListServices();
    }

    public void identifyStateChanged(NodeInterface node, IdentifyState identifyState) {
        SwingUtils.executeInEDT(() -> this.nodeListMenu.setIdentifyStateSelected(identifyState));
    }

    public void detachedStateChanged(NodeInterface node, DetachedState detachedState) {
        SwingUtils.executeInEDT(() -> this.nodeListMenu.setDetachedStateSelected(detachedState));
    }

    public void keyMessagesEnabledChanged(NodeInterface node, Boolean isKeyMessagesEnabled) {
        SwingUtils.executeInEDT(() -> this.nodeListMenu.setKeyMessagesEnabled(isKeyMessagesEnabled));
    }

    public void labelsChanged(NodeInterface node) {
    }

    private void setSelectedNode(NodeInterface node) {
        this.selectedNode = node;
        if (this.selectedNode != null && this.selectedNode.getCommandStationNode() != null) {
            CommandStationNodeInterface csNode = this.selectedNode.getCommandStationNode();
            this.dccAdvAvailableChanged(this.selectedNode, Boolean.valueOf(csNode.isDccAdvAvailable() != null ? csNode.isDccAdvAvailable() : false));
        } else {
            this.dccAdvAvailableChanged(this.selectedNode, Boolean.valueOf(false));
        }
    }

    public void opening() {
        LOGGER.info("Port is opening.");
        this.connectItem.setEnabled(false);
        this.listenNetBidibItem.setEnabled(false);
    }

    public void opened(String port) {
        LOGGER.info("The port was opened: {}.", (Object)port);
        this.connectItem.setEnabled(false);
        this.disconnectItem.setEnabled(true);
        this.listenNetBidibItem.setEnabled(false);
        this.nodesClientButton.setEnabled(true);
    }

    public void closed(String port) {
        LOGGER.info("The port was closed: {}.", (Object)port);
        this.connectItem.setEnabled(true);
        this.disconnectItem.setEnabled(false);
        this.nodesClientButton.setEnabled(false);
        this.enableListenNetBidibItem();
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }
}

