/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.client.common.component.ColorPane;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.mvc.stepcontrol.model.CvConsoleModel;
import org.bidib.wizard.mvc.stepcontrol.view.CvConsoleView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvConsoleView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvConsoleView.class);
    private final DockKey DOCKKEY = new DockKey("CvConsoleView");
    private final JPanel contentPanel;
    private final ColorPane coloredTextPane = new ColorPane();
    private final CvConsoleModel consoleModel;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private Color colorRed;
    private Color colorBlue;
    private Color colorGreen;
    private Color colorBlack;
    private Color colorGray;

    public CvConsoleView() {
        this.DOCKKEY.setName(Resources.getString(this.getClass(), (String)"title"));
        this.DOCKKEY.setFloatEnabled(true);
        this.DOCKKEY.setAutoHideEnabled(false);
        LOGGER.info("Create new ConsoleView");
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.coloredTextPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane((Component)this.coloredTextPane);
        this.contentPanel.add(scrollPane);
        this.colorRed = UIManager.getColor("Console.red");
        this.colorBlue = UIManager.getColor("Console.blue");
        this.colorGreen = UIManager.getColor("Console.green");
        this.colorBlack = UIManager.getColor("Console.black");
        this.colorGray = UIManager.getColor("Console.gray");
        this.consoleModel = CvConsoleModel.getConsoleModel();
        this.consoleModel.addPropertyChangeListener("consoleContent", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.consoleModel.addPropertyChangeListener("consoleContentSize", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        BasicPopupMenu popupMenu = new BasicPopupMenu();
        JMenuItem clearConsole = new JMenuItem(Resources.getString(this.getClass(), (String)"clear_console"));
        clearConsole.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        popupMenu.add(clearConsole);
        this.coloredTextPane.setComponentPopupMenu((JPopupMenu)popupMenu);
    }

    private Color getColor(ConsoleColor consoleColor) {
        Color color = this.colorBlack;
        switch (4.$SwitchMap$org$bidib$wizard$api$service$console$ConsoleColor[consoleColor.ordinal()]) {
            case 1: {
                color = this.colorRed;
                break;
            }
            case 2: {
                color = this.colorBlue;
                break;
            }
            case 3: {
                color = this.colorGreen;
                break;
            }
            case 4: {
                color = this.colorGray;
                break;
            }
        }
        return color;
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    public void close() {
    }

    private void fireClearConsole() {
        LOGGER.info("clear the console.");
        this.consoleModel.clear();
    }
}

