package org.bidib.wizard.mvc.main.view.table;

import javax.swing.table.TableColumn;

import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.BidibStatusTableRenderer;
import org.bidib.wizard.client.common.view.renderer.LocalPortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.renderer.PortIdentifierTableCellRenderer;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.model.SwitchPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.renderer.IoBehaviourSwitchComboBoxRenderer;
import org.bidib.wizard.mvc.main.view.panel.renderer.LoadTypeComboBoxRenderer;

import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class SwitchPortTable extends AbstractPortHierarchicalTable<SwitchPort> {
    private static final long serialVersionUID = 1L;

    private final SwitchPortTableModel switchPortTableModel;

    public SwitchPortTable(final SwitchPortTableModel switchPortTableModel, String emptyTableText) {
        super(switchPortTableModel, emptyTableText);

        this.switchPortTableModel = switchPortTableModel;
    }

    @Override
    protected SwitchPortEditorPanel createPortEditorPanel(
        final SwitchPort port, int row, final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, final NodeSelectionProvider nodeSelectionProvider) {
        SwitchPortEditorPanel editorPanel =
            new SwitchPortEditorPanel(port, switchPort -> this.switchPortTableModel.updatePortConfig(switchPort),
                switchPort -> this.switchPortTableModel.fireTestButtonPressed(switchPort),
                    switchPort -> this.switchPortTableModel.refreshRow(switchPort, changedRow -> repaint(getCellRect(changedRow, SwitchPortTableModel.COLUMN_LABEL, true))),
                    portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();

        return editorPanel;
    }

    @Override
    public void clearTable() {

    }

    @Override
    public void prepareTableColumns() {

        TableColumn tc = getColumnModel().getColumn(SwitchPortTableModel.COLUMN_LABEL);
        tc.setCellRenderer(new LocalPortConfigErrorAwareRenderer(SwitchPortTableModel.COLUMN_LABEL));
        tc.setIdentifier(Integer.valueOf(SwitchPortTableModel.COLUMN_LABEL));

        IoBehaviourSwitchComboBoxRenderer tableCellRenderer =
            new IoBehaviourSwitchComboBoxRenderer(IoBehaviourSwitchEnum.getValues(),
                BidibLibrary.BIDIB_PCFG_SWITCH_CTRL);

        tc = getColumnModel().getColumn(SwitchPortTableModel.COLUMN_IO_BEHAVIOUR);
        tc.setCellRenderer(tableCellRenderer);
        tc.setIdentifier(Integer.valueOf(SwitchPortTableModel.COLUMN_IO_BEHAVIOUR));

        tc = getColumnModel().getColumn(SwitchPortTableModel.COLUMN_SWITCH_OFF_TIME);
        tc.setCellRenderer(new PortTicksRenderer(SwitchPortTableModel.COLUMN_PORT_INSTANCE));
        tc.setIdentifier(Integer.valueOf(SwitchPortTableModel.COLUMN_SWITCH_OFF_TIME));

        final LoadTypeComboBoxRenderer<SwitchPort> tableCellRendererLoadType =
            new LoadTypeComboBoxRenderer<>(SwitchPortTableModel.COLUMN_PORT_INSTANCE, LoadTypeEnum.getValues(),
                BidibLibrary.BIDIB_PCFG_LOAD_TYPE);

        tc = getColumnModel().getColumn(SwitchPortTableModel.COLUMN_LOAD_TYPE);
        tc.setCellRenderer(tableCellRendererLoadType);
        tc.setIdentifier(Integer.valueOf(SwitchPortTableModel.COLUMN_LOAD_TYPE));

        tc = getColumnModel().getColumn(SwitchPortTableModel.COLUMN_PORT_IDENTIFIER);
        tc.setCellRenderer(new PortIdentifierTableCellRenderer());
        tc.setMaxWidth(80);
        tc.setIdentifier(Integer.valueOf(SwitchPortTableModel.COLUMN_PORT_IDENTIFIER));

        // Set the status renderer
        tc = getColumnModel().getColumn(SwitchPortTableModel.COLUMN_STATUS);
        tc.setIdentifier(Integer.valueOf(SwitchPortTableModel.COLUMN_STATUS));
        tc
            .setCellRenderer(new BidibStatusTableRenderer(SwitchPortStatus.class, "status.",
                SwitchPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SWITCHPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        tc.setMinWidth(60);
        tc.setMaxWidth(80);

        TableColumn buttonColumn = getColumnModel().getColumn(SwitchPortTableModel.COLUMN_TEST);
        buttonColumn.setIdentifier(Integer.valueOf(SwitchPortTableModel.COLUMN_TEST));
        buttonColumn.setMinWidth(180);
        buttonColumn.setMaxWidth(200);

        buttonColumn
            .setCellRenderer(new PortComboBoxWithButtonRenderer<BidibStatus>(getActions(SwitchPortStatus.ON), ">",
                SwitchPortStatus.class, SwitchPortTableModel.COLUMN_PORT_INSTANCE) {
                private static final long serialVersionUID = 1L;

                @Override
                protected void setSelectedValue(Port<?> port) {
                    SwitchPortStatus oppositeStatus = null;
                    if (port != null) {
                        oppositeStatus = (SwitchPortStatus) port.getStatus();
                    }
                    comboBox.setSelectedItem(oppositeStatus);
                }

                @Override
                protected boolean isPortEnabled(ConfigurablePort<?> port) {
                    if (port instanceof Port) {
                        if (Port.getConfiguredPortType((Port<?>) port) != LcOutputType.SWITCHPORT) {
                            return false;
                        }
                    }
                    return true;
                }
            });
        final PortComboBoxWithButtonEditor<BidibStatus> editor =
            new PortComboBoxWithButtonEditor<BidibStatus>(getActions(SwitchPortStatus.ON), ">",
                SwitchPortStatus.class) {
                private static final long serialVersionUID = 1L;

                @Override
                protected void setSelectedValue(Port<?> port) {
                    SwitchPortStatus oppositeStatus = null;
                    if (port != null) {
                        oppositeStatus = (SwitchPortStatus) port.getStatus();
                    }
                    comboBox.setSelectedItem(oppositeStatus);
                }
            };
        buttonColumn.setCellEditor(editor);

        TableColumnChooser.hideColumn(this, SwitchPortTableModel.COLUMN_PORT_INSTANCE);
    }
}
