package org.bidib.wizard.mvc.pt.controller.listener;

import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.wizard.api.model.NodeInterface;

public interface PtProgrammerControllerListener {
    void close();

    /**
     * Send the PT request.
     * 
     * @param node
     *            the node
     * @param opCode
     *            the op code
     * @param cvNumber
     *            the CV number
     * @param cvValue
     *            the CV value
     */
    void sendRequest(final NodeInterface node, CommandStationPt opCode, int cvNumber, int cvValue);

    /**
     * Send the command station state request.
     * 
     * @param node
     *            the node
     * @param commandStationState
     *            the command station state
     */
    void sendCommandStationStateRequest(final NodeInterface node, CommandStationState commandStationState);

    /**
     * Get the current state of the command station.
     * 
     * @param node
     *            the node
     * @return the current command station state
     */
    CommandStationState getCurrentCommandStationState(final NodeInterface node);
}
