package org.bidib.wizard.mvc.pt.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;

public class PtConfirmDialog extends EscapeDialog {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(PtConfirmDialog.class);

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, min(300dlu;pref)";

    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 10dlu, top:35dlu, 5dlu, pref, 5dlu, pref";

    private int result = JOptionPane.CANCEL_OPTION;

    private ValueModel checkDoNotAskInFutureValueModel;

    private final SettingsService settingsService;

    public PtConfirmDialog(final NodeInterface node, final SettingsService settingsService, Point itemPosition) {
        super(null, Resources.getString(PtConfirmDialog.class, "title"), true);

        this.settingsService = settingsService;

        getContentPane().setLayout(new BorderLayout());

        FormBuilder builder =
            FormBuilder
                .create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS).panel(new JPanel());
        builder.border(Paddings.DIALOG);

        JLabel iconLabel = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));

        int row = 1;
        builder.add(iconLabel).xywh(1, row, 1, 2);

        JLabel messageLabel = new JLabel(Resources.getString(getClass(), "message-warn"));
        Font font = messageLabel.getFont();
        font = font.deriveFont(16.0f);
        messageLabel.setFont(font);
        messageLabel.setForeground(Color.RED);

        builder.add(messageLabel).xy(3, row);
        row += 2;

        JLabel messageInfoLabel = new JLabel(Resources.getString(getClass(), "message"));
        builder.add(messageInfoLabel).xy(3, row);
        row += 2;

        checkDoNotAskInFutureValueModel =
            new ValueHolder(settingsService.getWizardSettings().isPtModeDoNotConfirmSwitch());
        if (!((Boolean) checkDoNotAskInFutureValueModel.getValue()).booleanValue()) {
            JCheckBox checkDoNotAskInFuture =
                WizardComponentFactory
                    .createCheckBox(checkDoNotAskInFutureValueModel, Resources.getString(getClass(), "do-not-ask"));
            builder.add(checkDoNotAskInFuture).xy(3, row);
            row += 2;
        }
        else {
            // we do not use it
            checkDoNotAskInFutureValueModel = null;
        }

        // buttons
        JButton continueButton = new JButton(Resources.getString(getClass(), "continue"));

        continueButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                fireContinue(node);
            }
        });

        JButton cancel = new JButton(Resources.getString(getClass(), "cancel"));

        cancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                fireCancel();
            }
        });

        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(continueButton, cancel).build();

        builder.add(buttons).xy(3, row);

        getContentPane().add(builder.build());

        pack();
        setLocation(itemPosition);
        setMinimumSize(getSize());
        setVisible(true);
    }

    private void fireContinue(NodeInterface node) {
        LOGGER.info("Continue operation");

        result = JOptionPane.YES_OPTION;

        if (checkDoNotAskInFutureValueModel != null
            && ((Boolean) checkDoNotAskInFutureValueModel.getValue()).booleanValue()) {
            LOGGER.info("Do not show confirm dialog in the future.");
            settingsService.getWizardSettings().setPtModeDoNotConfirmSwitch(true);
            settingsService.storeSettings();
        }
    }

    private void fireCancel() {

    }

    public int getResult() {
        return result;
    }

}
