/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.wizard;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.common.view.wizard.CancelAction;
import org.bidib.wizard.mvc.common.view.wizard.FinishAction;
import org.bidib.wizard.mvc.common.view.wizard.JWizardComponents;
import org.bidib.wizard.mvc.common.view.wizard.JWizardPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJWizardComponents
implements JWizardComponents {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJWizardComponents.class);
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    private FinishAction finishAction;
    private CancelAction cancelAction;
    private List<JWizardPanel> panelList;
    private int currentIndex;
    private JPanel wizardPanelsContainer;
    private PropertyChangeSupport propertyChangeListeners;

    public DefaultJWizardComponents() {
        try {
            this.init();
        }
        catch (Exception e) {
            LOGGER.warn("Init wizard components failed.", (Throwable)e);
        }
    }

    public void addWizardPanel(JWizardPanel panel) {
        panel.initPanel();
        this.getWizardPanelList().add(panel);
        this.wizardPanelsContainer.add((Component)panel.getPanel(), Integer.toString(this.getWizardPanelList().size() - 1));
    }

    public void addWizardPanel(int index, JWizardPanel panel) {
        this.getWizardPanelList().add(index, panel);
        this.wizardPanelsContainer.add(panel.getPanel(), "" + index, index);
        if (index < this.getWizardPanelList().size() - 1) {
            for (int i = index + 1; i < this.getWizardPanelList().size(); ++i) {
                this.wizardPanelsContainer.add((Component)((JWizardPanel)this.getWizardPanelList().get(i)).getPanel(), Integer.toString(i));
            }
        }
    }

    public void addWizardPanelAfter(JWizardPanel panelToBePlacedAfter, JWizardPanel panel) {
        this.addWizardPanel(this.getWizardPanelList().indexOf(panelToBePlacedAfter) + 1, panel);
    }

    public void addWizardPanelBefore(JWizardPanel panelToBePlacedBefore, JWizardPanel panel) {
        this.addWizardPanel(this.getWizardPanelList().indexOf(panelToBePlacedBefore) - 1, panel);
    }

    public void addWizardPanelAfterCurrent(JWizardPanel panel) {
        this.addWizardPanel(this.getCurrentIndex() + 1, panel);
    }

    public JWizardPanel removeWizardPanel(JWizardPanel panel) {
        int index = this.getWizardPanelList().indexOf(panel);
        this.getWizardPanelList().remove(panel);
        this.wizardPanelsContainer.remove(panel.getPanel());
        for (int i = index; i < this.getWizardPanelList().size(); ++i) {
            this.wizardPanelsContainer.add((Component)((JWizardPanel)this.getWizardPanelList().get(i)).getPanel(), Integer.toString(i));
        }
        return panel;
    }

    public JWizardPanel removeWizardPanel(int index) {
        this.wizardPanelsContainer.remove(index);
        JWizardPanel panel = (JWizardPanel)this.getWizardPanelList().remove(index);
        for (int i = index; i < this.getWizardPanelList().size(); ++i) {
            this.wizardPanelsContainer.add((Component)((JWizardPanel)this.getWizardPanelList().get(i)).getPanel(), Integer.toString(i));
        }
        return panel;
    }

    public JWizardPanel removeWizardPanelAfter(JWizardPanel panel) {
        return this.removeWizardPanel(this.getWizardPanelList().indexOf(panel) + 1);
    }

    public JWizardPanel removeWizardPanelBefore(JWizardPanel panel) {
        return this.removeWizardPanel(this.getWizardPanelList().indexOf(panel) - 1);
    }

    public JWizardPanel getWizardPanel(int index) {
        return (JWizardPanel)this.getWizardPanelList().get(index);
    }

    public int getIndexOfPanel(JWizardPanel panel) {
        return this.getWizardPanelList().indexOf(panel);
    }

    public boolean onLastPanel() {
        return this.getCurrentIndex() == this.getWizardPanelList().size() - 1;
    }

    private void init() throws Exception {
        this.propertyChangeListeners = new PropertyChangeSupport(this);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.finishButton = new JButton();
        this.cancelButton = new JButton();
        this.panelList = new ArrayList();
        this.currentIndex = 0;
        this.wizardPanelsContainer = new JPanel();
        this.backButton.setText(Resources.getString(this.getClass(), (String)"L_BackButton"));
        this.backButton.setMnemonic(Resources.getString(this.getClass(), (String)"L_BackButtonMnem").charAt(0));
        this.backButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.nextButton.setText(Resources.getString(this.getClass(), (String)"L_NextButton"));
        this.nextButton.setMnemonic(Resources.getString(this.getClass(), (String)"L_NextButtonMnem").charAt(0));
        this.nextButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cancelButton.setText(Resources.getString(this.getClass(), (String)"L_CancelButton"));
        this.cancelButton.setMnemonic(Resources.getString(this.getClass(), (String)"L_CancelButtonMnem").charAt(0));
        this.cancelButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.finishButton.setText(Resources.getString(this.getClass(), (String)"L_FinishButton"));
        this.finishButton.setMnemonic(Resources.getString(this.getClass(), (String)"L_FinishButtonMnem").charAt(0));
        this.finishButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.wizardPanelsContainer.setLayout(new CardLayout());
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.getCancelAction().performAction();
    }

    void finishButton_actionPerformed(ActionEvent e) {
        this.getFinishAction().performAction();
    }

    void nextButton_actionPerformed(ActionEvent e) {
        try {
            this.getCurrentPanel().next();
        }
        catch (Exception ex) {
            LOGGER.warn("Switch to next panel failed.", (Throwable)ex);
        }
    }

    void backButton_actionPerformed(ActionEvent e) {
        try {
            this.getCurrentPanel().back();
        }
        catch (Exception ex) {
            LOGGER.warn("Switch to previous panel failed.", (Throwable)ex);
        }
    }

    public JWizardPanel getCurrentPanel() throws Exception {
        if (this.getWizardPanelList().get(this.currentIndex) != null) {
            return (JWizardPanel)this.getWizardPanelList().get(this.currentIndex);
        }
        throw new Exception("No panels in panelList");
    }

    public void updateComponents() {
        try {
            CardLayout cl = (CardLayout)this.wizardPanelsContainer.getLayout();
            cl.show(this.wizardPanelsContainer, "" + this.currentIndex);
            if (this.currentIndex == 0) {
                this.backButton.setEnabled(false);
            } else {
                this.backButton.setEnabled(true);
            }
            if (this.onLastPanel()) {
                this.nextButton.setEnabled(false);
                this.finishButton.setEnabled(true);
            } else {
                this.finishButton.setEnabled(false);
                this.nextButton.setEnabled(true);
            }
            this.getCurrentPanel().update();
            PropertyChangeEvent event = new PropertyChangeEvent(this, "currentPanel", null, this.getCurrentPanel());
            this.propertyChangeListeners.firePropertyChange(event);
        }
        catch (Exception ex) {
            LOGGER.warn("Update components on panel failed.", (Throwable)ex);
        }
    }

    public List<JWizardPanel> getWizardPanelList() {
        return this.panelList;
    }

    public void setWizardPanelList(List<JWizardPanel> panelList) {
        this.panelList.clear();
        this.panelList.addAll(panelList);
    }

    public FinishAction getFinishAction() {
        return this.finishAction;
    }

    public void setFinishAction(FinishAction aFinishAction) {
        this.finishAction = aFinishAction;
    }

    public CancelAction getCancelAction() {
        return this.cancelAction;
    }

    public void setCancelAction(CancelAction aCancelAction) {
        this.cancelAction = aCancelAction;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int aCurrentIndex) {
        this.currentIndex = aCurrentIndex;
    }

    public JPanel getWizardPanelsContainer() {
        return this.wizardPanelsContainer;
    }

    public void setWizardPanelsContainer(JPanel aWizardPanelsContainer) {
        this.wizardPanelsContainer = aWizardPanelsContainer;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public void setBackButton(JButton aBackButton) {
        this.backButton = aBackButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public void setNextButton(JButton aNextButton) {
        this.nextButton = aNextButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton aCancelButton) {
        this.cancelButton = aCancelButton;
    }

    public JButton getFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(JButton button) {
        this.finishButton = button;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.removePropertyChangeListener(listener);
    }
}

