/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.jidesoft.grid.DefaultExpandableRow;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.time.StopWatch;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionListener;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.cvdef.CvNodeUtils;
import org.bidib.wizard.client.common.view.cvdef.LongCvNode;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.LightPortCommand;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.common.script.switching.WaitCommand;
import org.bidib.wizard.common.view.statusbar.StatusBar;
import org.bidib.wizard.core.labels.BidibLabelUtils;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.main.controller.CvDefinitionPanelController;
import org.bidib.wizard.mvc.main.controller.InsertPortsAware;
import org.bidib.wizard.mvc.main.controller.LightPortPanelController;
import org.bidib.wizard.mvc.main.controller.MacroPanelController;
import org.bidib.wizard.mvc.main.controller.wrapper.NodePortWrapper;
import org.bidib.wizard.mvc.main.model.LightPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.LightPortModelListener;
import org.bidib.wizard.mvc.main.view.component.BusyFrame;
import org.bidib.wizard.mvc.main.view.component.InsertPortsConfirmDialog;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.LightPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

/*
 * Exception performing whole class analysis ignored.
 */
public class LightPortPanelController
implements CvDefinitionListener,
PortScripting,
InsertPortsAware<LightPortTableModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPortPanelController.class);
    public static final String KEYWORD_CHANNEL_B_START_NUMBER = "channel_B_start_number";
    public static final String KEYWORD_CHANNEL_A_LAST_ELEMENT = "channel_A_last_element";
    private final MainModel mainModel;
    private LightPortListPanel lightPortListPanel;
    private final Map<NodeInterface, NodePortWrapper> testToggleRegistry = new LinkedHashMap();
    private Map<String, CvNode> mapKeywordToNode;
    private List<CvDefinitionRequestListener> cvDefinitionRequestListeners = new LinkedList();
    private List<ConfigurationVariable> requiredConfigVariables = new LinkedList();
    private Integer channelBStartNumber;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private MacroPanelController macroPanelController;
    @Autowired
    private ConsoleService consoleService;
    private LightPortModelListener lightPortModelListener;
    private final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject = PublishSubject.create();
    private CompositeDisposable compDisp;

    public LightPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.compDisp = new CompositeDisposable();
    }

    public LightPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        this.mainModel.addCvDefinitionListener((CvDefinitionListener)this);
        LightPortTableModel tableModel = new LightPortTableModel();
        this.lightPortModelListener = new /* Unavailable Anonymous Inner Class!! */;
        tableModel.setPortListener((PortModelListener)this.lightPortModelListener);
        LightPortListPanel lightPortListPanel = new LightPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        lightPortListPanel.setPortListener((PortListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mainModel.addNodeListListener((NodeListListener)new /* Unavailable Anonymous Inner Class!! */);
        this.lightPortListPanel = lightPortListPanel;
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null) {
            this.addLightPortModelListener(selectedNode);
        }
        return lightPortListPanel;
    }

    public void addTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Add test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = (NodePortWrapper)this.testToggleRegistry.remove(node);
        ScriptEngine scriptEngine = null;
        if (nodePortWrapper != null) {
            scriptEngine = nodePortWrapper.removePort(port);
        }
        if (scriptEngine != null) {
            LOGGER.info("Found a node scripting engine in the registry: {}", (Object)scriptEngine);
            try {
                scriptEngine.stopScript(Long.valueOf(2000L));
            }
            catch (Exception ex) {
                LOGGER.warn("Stop script failed.", (Throwable)ex);
            }
        }
        DefaultScriptContext context = new DefaultScriptContext();
        context.register("selectedNode", (Object)node);
        context.register("mainModel", (Object)this.mainModel);
        scriptEngine = new ScriptEngine((Scripting)this, (ApplicationContext)context);
        LinkedList<Object> scriptCommands = new LinkedList<Object>();
        LightPortCommand spc = new LightPortCommand(this.consoleService);
        spc.parse("light " + port.getId() + " ON");
        scriptCommands.add(spc);
        WaitCommand wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        spc = new LightPortCommand(this.consoleService);
        spc.parse("light " + port.getId() + " OFF");
        scriptCommands.add(spc);
        wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        scriptEngine.setScriptCommands(scriptCommands);
        scriptEngine.setScriptRepeating(true);
        if (nodePortWrapper == null) {
            LOGGER.info("Create new NodePortWrapper for node: {}", (Object)node);
            nodePortWrapper = new NodePortWrapper(node);
        }
        LOGGER.info("Put script engine in registry for node: {}", (Object)node);
        nodePortWrapper.addPort(port, scriptEngine);
        this.testToggleRegistry.put(node, nodePortWrapper);
        scriptEngine.startScript();
    }

    public void stopTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Stop test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = (NodePortWrapper)this.testToggleRegistry.get(node);
        if (nodePortWrapper != null) {
            HashSet toRemove = new HashSet();
            if (port != null) {
                toRemove.add(port);
            } else {
                toRemove.addAll(nodePortWrapper.getKeySet());
            }
            for (Port port2 : toRemove) {
                ScriptEngine engine = nodePortWrapper.removePort(port2);
                if (engine != null) {
                    LOGGER.info("Found a node scripting engine in the registry: {}", (Object)engine);
                    try {
                        engine.stopScript(Long.valueOf(2000L));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Stop script failed.", (Throwable)ex);
                    }
                    continue;
                }
                LOGGER.warn("No scripting engine found for node: {}", (Object)node);
            }
            if (nodePortWrapper.isEmpty()) {
                LOGGER.info("No more ports registered for node: {}", (Object)node);
                this.testToggleRegistry.remove(node);
            }
        }
    }

    public void sendPortStatusAction(SwitchingNodeInterface node, int port, BidibStatus portStatus) {
        LOGGER.info("Switch the light port: {}, portStatus: {}", (Object)port, (Object)portStatus);
        try {
            SwitchingNodeInterface selectedNode = node != null ? node : this.mainModel.getSelectedNode().getSwitchingNode();
            LightPortStatus lightPortStatus = (LightPortStatus)portStatus;
            LightPort lightPort = new LightPort();
            lightPort.setId(port);
            lightPort.setStatus((BidibStatus)lightPortStatus);
            this.switchingNodeService.setPortStatus("main", selectedNode, (Port)lightPort);
        }
        catch (Exception ex) {
            LOGGER.warn("Switch light port failed.", (Throwable)ex);
        }
    }

    public void sendPortValueAction(SwitchingNodeInterface node, int port, int portValue) {
    }

    private void clearKeywordToNodeMap() {
        LOGGER.info("Clear the keywordToNode map.");
        this.mapKeywordToNode = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPorts(int selectedRow, LightPortTableModel lightPortTableModel) {
        BusyFrame busyFrame = null;
        StopWatch sw = new StopWatch();
        InsertPortsConfirmDialog insertPortsConfirmDialog = new InsertPortsConfirmDialog(JOptionPane.getFrameForComponent(null), true);
        int result = insertPortsConfirmDialog.getResult();
        if (result == 2) {
            LOGGER.info("User canceled the insert ports operation.");
            return;
        }
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node.hasUnloadedMacros()) {
            LOGGER.info("Unloaded macros detected. Load the macros from the node.");
            LinkedList<Macro> macroList = new LinkedList<Macro>();
            for (Macro macro : node.getMacros()) {
                if (MacroSaveState.NOT_LOADED_FROM_NODE.equals((Object)macro.getMacroSaveState())) {
                    Macro macroWithContent = this.switchingNodeService.getMacroContent("main", node.getSwitchingNode(), macro);
                    LOGGER.info("Load macro content: {}", (Object)macroWithContent);
                    macroWithContent.setMacroSaveState(MacroSaveState.PERMANENTLY_STORED_ON_NODE);
                    macroWithContent.setFlatPortModel(node.getNode().isPortFlatModelAvailable());
                    macroList.add(macroWithContent);
                    continue;
                }
                macroList.add(macro);
            }
            LOGGER.info("Set the loaded macros for the node: {}", macroList);
            node.setMacros(macroList);
        }
        int portsCount = insertPortsConfirmDialog.getPortsCount();
        LOGGER.info("Insert number of ports: {}", (Object)portsCount);
        try {
            Frame frame = JOptionPane.getFrameForComponent((Component)this.lightPortListPanel);
            if (frame instanceof BusyFrame) {
                busyFrame = (BusyFrame)frame;
                busyFrame.setBusy(true);
            }
            sw.start();
            List allLightPorts = node.getLightPorts();
            LightPort firstPort = (LightPort)lightPortTableModel.getValueAt(selectedRow, 11);
            LOGGER.info("Found lightPort to start insert the new ports: {}, port number: {}", (Object)firstPort, (Object)firstPort.getId());
            int startPortRangeValue = firstPort.getId() + portsCount - 1;
            Integer portRangeUpperBound = null;
            if (this.channelBStartNumber != null) {
                portRangeUpperBound = this.testValidRange(firstPort, portsCount, this.channelBStartNumber);
                LOGGER.info("Validated range, portRangeUpperBound: {}", (Object)portRangeUpperBound);
            }
            NodeLabels nodeLabels = this.getNodeLabels();
            Set ports = LightPortPanelController.findAllPortsInRange((List)allLightPorts, (int)startPortRangeValue, (Integer)portRangeUpperBound);
            for (LightPort currentPort : ports) {
                LOGGER.info("Change the label of the port: {}, id: {}", (Object)currentPort, (Object)currentPort.getId());
                int portNum = currentPort.getId();
                Port predecessorPort = PortListUtils.findPortByPortNumber((List)allLightPorts, (int)(portNum - portsCount));
                if (predecessorPort != null) {
                    LOGGER.info("Current predecessorPort: {}, port number: {}", (Object)predecessorPort, (Object)predecessorPort.getId());
                    String label = predecessorPort.getLabel();
                    currentPort.setLabel(label);
                    predecessorPort.setLabel(null);
                    BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.lightPort, (int)currentPort.getId(), (String)currentPort.getLabel());
                    Map configX = predecessorPort.getPortConfigX();
                    currentPort.setPortConfigX(configX);
                    ArrayList<PortConfigKeys> portConfigKeys = new ArrayList<PortConfigKeys>();
                    Iterator iterator = currentPort.getKnownPortConfigKeys().iterator();
                    while (iterator.hasNext()) {
                        byte key = (Byte)iterator.next();
                        portConfigKeys.add(PortConfigKeys.valueOf((byte)key));
                    }
                    this.lightPortModelListener.configChanged((Port)currentPort, portConfigKeys.toArray(new PortConfigKeys[0]));
                    continue;
                }
                LOGGER.info("No predecessorPort available with port number: {}", (Object)(portNum - portsCount));
            }
            for (int portNum = 0; portNum < portsCount; ++portNum) {
                Port replacedPort = PortListUtils.findPortByPortNumber((List)allLightPorts, (int)(firstPort.getId() + portNum));
                if (replacedPort == null) continue;
                LOGGER.info("Remove label of port: {}, port number: {}", (Object)replacedPort, (Object)replacedPort.getId());
                replacedPort.setLabel(null);
                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.lightPort, (int)replacedPort.getId(), (String)replacedPort.getLabel());
            }
            this.saveLabels();
            this.macroPanelController.movePortsInAllMacros(this.mainModel, node, (Port)firstPort, allLightPorts, portsCount);
            lightPortTableModel.fireTableDataChanged();
        }
        catch (InvalidConfigurationException ex) {
            LOGGER.warn("Save port labels failed.", (Throwable)ex);
            String labelPath = ex.getReason();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
        }
        catch (Exception ex) {
            LOGGER.warn("Save port labels failed.", (Throwable)ex);
            String message = ex.getMessage();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{message}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
        }
        finally {
            if (busyFrame != null) {
                LOGGER.info("Unset busy frame.");
                busyFrame.setBusy(false);
            }
            sw.stop();
        }
        LOGGER.info("Load CV values has finished! Total loading duration: {}", (Object)sw);
        StatusBar statusBar = (StatusBar)DefaultApplicationContext.getInstance().get("statusBar", StatusBar.class);
        statusBar.setStatusText(String.format(Resources.getString(LightPortPanelController.class, (String)"insert-ports-finished"), portsCount, sw), -1);
    }

    private void readCurrentCvNodeValuesFromCVDefinition(NodeInterface node) {
        LOGGER.info("Read the values from CV for node: {}", (Object)node);
        if (node == null || !ProductUtils.isNeoControl((long)node.getUniqueId()) && !ProductUtils.isNeoEWS((long)node.getUniqueId())) {
            LOGGER.warn("No node available or not a NeoControl: {}", (Object)node);
            if (this.mapKeywordToNode != null) {
                this.mapKeywordToNode.clear();
            }
            return;
        }
        LOGGER.info("Get the cvDefinitionTreeTableModel from the node: {}", (Object)node);
        CvDefinitionPanelController cvDefinitionPanelController = (CvDefinitionPanelController)DefaultApplicationContext.getInstance().get("cvDefinitionPanelController", CvDefinitionPanelController.class);
        CvDefinitionTreeTableModel cvDefinitionTreeTableModel = cvDefinitionPanelController.getCvDefinitionTreeTableModel(node);
        if (cvDefinitionTreeTableModel != null) {
            this.mapKeywordToNode = new LinkedHashMap();
            DefaultExpandableRow rootNode = (DefaultExpandableRow)cvDefinitionTreeTableModel.getRoot();
            if (rootNode != null) {
                CvNodeUtils.harvestKeywordNodes((DefaultExpandableRow)rootNode, (Map)this.mapKeywordToNode);
            }
            LOGGER.info("Found keywords in nodes: {}", this.mapKeywordToNode.keySet());
        }
        if (MapUtils.isNotEmpty((Map)this.mapKeywordToNode)) {
            LinkedList configVariables = new LinkedList();
            for (CvNode cvNode : this.mapKeywordToNode.values()) {
                this.prepareConfigVariables(cvNode, configVariables, this.getCvNumberToNodeMap(node));
            }
            this.requiredConfigVariables.clear();
            if (CollectionUtils.isNotEmpty(configVariables)) {
                this.requiredConfigVariables.addAll(configVariables);
            }
            this.fireLoadConfigVariables(configVariables);
        } else {
            LOGGER.info("No values available in mapKeywordToNode!");
        }
    }

    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        this.cvDefinitionRequestListeners.add(l);
    }

    private void fireLoadConfigVariables(List<ConfigurationVariable> configVariables) {
        LOGGER.info("Load the config variables.");
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.loadCvValues(configVariables);
        }
    }

    private void prepareConfigVariables(CvNode cvNode, List<ConfigurationVariable> configVariables, Map<String, CvNode> cvNumberToNodeMap) {
        try {
            switch (6.$SwitchMap$org$bidib$jbidibc$exchange$vendorcv$DataType[cvNode.getCV().getType().ordinal()]) {
                case 1: {
                    LongCvNode masterNode = ((LongCvNode)cvNode).getMasterNode();
                    configVariables.add(masterNode.getConfigVar());
                    for (CvNode slaveNode : masterNode.getSlaveNodes()) {
                        configVariables.add(slaveNode.getConfigVar());
                    }
                    break;
                }
                case 2: {
                    configVariables.add(cvNode.getConfigVar());
                    int highCvNum = Integer.parseInt(cvNode.getCV().getHigh());
                    int cvNumber = Integer.parseInt(cvNode.getCV().getNumber());
                    if (highCvNum == cvNumber) {
                        CvNode lowCvNode = cvNumberToNodeMap.get(cvNode.getCV().getLow());
                        configVariables.add(lowCvNode.getConfigVar());
                        break;
                    }
                    CvNode highCvNode = cvNumberToNodeMap.get(cvNode.getCV().getHigh());
                    if (highCvNode == null) {
                        LOGGER.warn("The highCvNode is not available: {}", (Object)cvNode.getCV());
                    }
                    configVariables.add(highCvNode.getConfigVar());
                    break;
                }
                default: {
                    configVariables.add(cvNode.getConfigVar());
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Prepare config variables to read from node failed.", (Throwable)ex);
        }
    }

    private CvNode getCvNodeByKeyword(String keyword) {
        CvNode cvNode = null;
        if (this.mapKeywordToNode != null) {
            cvNode = (CvNode)this.mapKeywordToNode.get(keyword);
        }
        return cvNode;
    }

    private Integer getConfigVarIntValue(String keyword, NodeInterface selectedNode) {
        CvNode cvNode = this.getCvNodeByKeyword(keyword);
        Integer value = CvValueUtils.getConfigVarIntValue((CvNode)cvNode, (Map)this.getCvNumberToNodeMap(selectedNode));
        return value;
    }

    private Map<String, CvNode> getCvNumberToNodeMap(NodeInterface node) {
        CvDefinitionPanelController cvDefinitionPanelController = (CvDefinitionPanelController)DefaultApplicationContext.getInstance().get("cvDefinitionPanelController", CvDefinitionPanelController.class);
        Map cvNumberToNodeMap = cvDefinitionPanelController.getCvNumberToNodeMap(node);
        return cvNumberToNodeMap;
    }

    public static <T extends Port<?>> Set<T> findAllPortsInRange(List<T> ports, int portNum, Integer portNumUpperBound) {
        LOGGER.info("Find all ports with port number greater than: {}, lower than: {}", (Object)portNum, (Object)portNumUpperBound);
        TreeSet<T> filteredSet = new TreeSet<T>(new /* Unavailable Anonymous Inner Class!! */);
        filteredSet.addAll(ports);
        CollectionUtils.filter(filteredSet, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        return filteredSet;
    }

    protected Integer testValidRange(LightPort firstPort, int portsCount, Integer channelBStartNumber) {
        LOGGER.info("Test the valid range: {}, portsCount: {}, channelBStartNumber: {}", new Object[]{firstPort, portsCount, channelBStartNumber});
        if (channelBStartNumber == null) {
            throw new IllegalArgumentException("The channelBStartNumber must be provided.");
        }
        Integer upperRangeValue = channelBStartNumber * 3;
        int startPortRangeValue = firstPort.getId() + portsCount - 1;
        if (firstPort.getId() < upperRangeValue) {
            if (startPortRangeValue < upperRangeValue) {
                LOGGER.info("We want to move ports in channel A and the number of ports to insert will match into channel A range.");
            } else {
                LOGGER.warn("The number of inserted port crosses the channel border. Ports configurations will be dropped out.");
            }
        } else {
            LOGGER.info("The inserted ports will start in channel B. No upper range limit required.");
            upperRangeValue = null;
        }
        return upperRangeValue;
    }

    public void cvDefinitionValuesChanged(boolean read, List<String> changedNames) {
        LOGGER.info("The CV definition values have changed, read: {}", (Object)read);
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode == null || MapUtils.isEmpty((Map)selectedNode.getConfigVariables()) || !ProductUtils.isNeoControl((long)selectedNode.getUniqueId()) && !ProductUtils.isNeoEWS((long)selectedNode.getUniqueId())) {
            return;
        }
        if (ProductUtils.isNeoControl((long)selectedNode.getUniqueId())) {
            this.channelBStartNumber = this.getConfigVarIntValue("channel_B_start_number", selectedNode);
        } else {
            Integer channelALastElement = this.getConfigVarIntValue("channel_A_last_element", selectedNode);
            if (channelALastElement != null) {
                LOGGER.info("Get the channel B start number from channel A last element value: {}", (Object)channelALastElement);
                this.channelBStartNumber = channelALastElement + 1;
            }
        }
        LOGGER.info("Fetched channel B start number: {}", (Object)this.channelBStartNumber);
    }

    public void cvDefinitionChanged() {
        LOGGER.info("The CV definition has changed.");
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node == null) {
            return;
        }
        this.triggerLoadCvValues(node);
    }

    private void triggerLoadCvValues(NodeInterface node) {
        if (this.mapKeywordToNode == null && (ProductUtils.isNeoControl((long)node.getUniqueId()) || ProductUtils.isNeoEWS((long)node.getUniqueId()))) {
            LOGGER.info("A NeoControl or NeoEWS is detected. Get the start number of port for channel B.");
            this.readCurrentCvNodeValuesFromCVDefinition(node);
        }
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.lightPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.lightPortListPanel.refreshView());
        }
    }

    private void addLightPortModelListener(NodeInterface selectedNode) {
        LOGGER.info("Add light port model listener for node: {}", (Object)selectedNode);
        Disposable disp = this.portConfigChangeEventSubject.subscribe(evt -> {
            LOGGER.info("Received event: {}", evt);
            PortTypeAware port = evt.getPort();
            try {
                LightPort lightPort = new LightPort();
                lightPort.setId(port.getPortNumber().intValue());
                LOGGER.info("Prepared light port: {}", (Object)lightPort);
                this.switchingNodeService.setPortConfig("main", selectedNode.getSwitchingNode(), (Port)lightPort, null, evt.getPortConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the lightport config failed.", (Throwable)ex);
                selectedNode.setNodeHasError(true);
                selectedNode.setReasonData("Set the lightport config failed.");
            }
        });
        this.compDisp.add(disp);
    }
}

