/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.exchange;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.view.statusbar.StatusBar;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.core.service.node.NodeService;
import org.bidib.wizard.mvc.main.view.component.DefaultBusyFrame;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.utils.FileUtils;
import org.bidib.wizard.utils.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeExchangeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeExchangeHelper.class);
    public static final String NODE_X_EXTENSION = "nodex";
    private static final String WORKING_DIR_NODE_EXCHANGE_KEY = "nodeExchange";

    public void importNode(DefaultBusyFrame parentComponent, NodeInterface node, SettingsService settingsService, NodeService nodeService, SwitchingNodeService switchingNodeService, CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, FileFilter nodeFilter, WizardLabelWrapper wizardLabelWrapper, StatusBar statusBar, NodeListActionListener nodeListActionListener) {
        HashMap importParams = new HashMap();
        WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_NODE_EXCHANGE_KEY);
        1 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public void exportNode(DefaultBusyFrame parentComponent, NodeInterface node, SettingsService settingsService, NodeService nodeService, SwitchingNodeService switchingNodeService, WizardLabelWrapper wizardLabelWrapper, CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, FileFilter nodeFilter, StatusBar statusBar, String lang) {
        LOGGER.info("export node: {}", (Object)node);
        WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
        String fileName = this.prepareFileName(wizardSettings, node);
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_NODE_EXCHANGE_KEY);
        2 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public BiDiB prepareBiDiB(NodeInterface node, CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry, String lang, boolean skipCvValues, WizardLabelWrapper wizardLabelWrapper) {
        CvContainer cvContainer = cvDefinitionTreeModelRegistry.getCvContainer(node.getUniqueId());
        Map cvNumberToNodeMap = cvContainer != null ? cvContainer.getCvNumberToNodeMap() : new HashMap();
        BiDiB bidib = NodeUtils.convertToBiDiB((NodeInterface)node, (Map)cvNumberToNodeMap, (String)lang, (boolean)skipCvValues, (WizardLabelWrapper)wizardLabelWrapper);
        LOGGER.debug("prepareBiDiB, converted node to bidib: {}", (Object)bidib);
        return bidib;
    }

    public String prepareFileName(WizardSettingsInterface wizardSettings, NodeInterface node) {
        Object nodeLabel = NodeUtils.prepareLabel((NodeInterface)node);
        boolean nodeExportAppendDateEnabled = wizardSettings.isNodeExportAppendDateEnabled();
        if (nodeExportAppendDateEnabled) {
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("_yyyyMMdd_HHmmss");
            String currentDateTime = now.format(formatter);
            nodeLabel = (String)nodeLabel + currentDateTime;
        }
        LOGGER.info("export node, prepared nodeLabel as filename: {}", nodeLabel);
        if (!FileUtils.isPathValid((String)nodeLabel) || !FileUtils.isFilenameValid((String)nodeLabel)) {
            LOGGER.warn("The default filename is not a valid filename: {}", nodeLabel);
            nodeLabel = FileUtils.escapeInvalidFilenameCharacters((String)nodeLabel, (String)"_");
            LOGGER.info("export node, prepared escaped filename: {}", nodeLabel);
        }
        return (String)nodeLabel + ".nodex";
    }
}

