package org.bidib.wizard.mvc.console.controller;

import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.mvc.console.model.DefaultConsoleModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsoleService implements ConsoleService {

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsoleService.class);

    private final DefaultConsoleModel consoleModel;

    public DefaultConsoleService() {
        this.consoleModel = new DefaultConsoleModel();
    }

    @Override
    public DefaultConsoleModel getConsoleModel() {
        return consoleModel;
    }

    @Override
    public void ensureConsoleIsVisible() {
        ConsoleController.ensureConsoleVisible();
    }

    @Override
    public void addConsoleLine(ConsoleColor consoleColor, String line) {
        try {
            // add line
            getConsoleModel().addConsoleLine(consoleColor, line);
        }
        catch (Exception ex) {
            LOGGER.warn("Add line to console model failed, color: {}, line: {}", consoleColor, line, ex);
        }
    }
}
