package org.bidib.wizard.mvc.loco.view.speedo;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;

public class SpeedScaleBeanModel extends ProgCommandAwareBeanModel {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTYNAME_CV37_SCALE = "cv37Scale";

    public static final String PROPERTYNAME_MEASURED_MIN_SPEED = "measuredMinSpeed";

    public static final String PROPERTYNAME_MEASURED_MAX_SPEED = "measuredMaxSpeed";

    public static final String PROPERTYNAME_TARGET_MIN_SPEED = "targetMinSpeed";

    public static final String PROPERTYNAME_TARGET_MAX_SPEED = "targetMaxSpeed";

    private Integer cv37Scale;

    private Integer measuredMinSpeed;

    private Integer measuredMaxSpeed;

    private Integer targetMinSpeed;

    private Integer targetMaxSpeed;

    /**
     * @return the cv37Scale
     */
    public Integer getCv37Scale() {
        return cv37Scale;
    }

    /**
     * @param cv37Scale
     *            the cv37Scale to set
     */
    public void setCv37Scale(Integer cv37Scale) {
        Integer oldValue = this.cv37Scale;
        this.cv37Scale = cv37Scale;

        firePropertyChange(PROPERTYNAME_CV37_SCALE, oldValue, cv37Scale);
    }

    /**
     * @return the measuredMinSpeed in mm/s
     */
    public Integer getMeasuredMinSpeed() {
        return measuredMinSpeed;
    }

    /**
     * @param measuredMinSpeed
     *            the measuredMinSpeed in mm/s to set
     */
    public void setMeasuredMinSpeed(Integer measuredMinSpeed) {
        Integer oldValue = this.measuredMinSpeed;
        this.measuredMinSpeed = measuredMinSpeed;

        firePropertyChange(PROPERTYNAME_MEASURED_MIN_SPEED, oldValue, measuredMinSpeed);
    }

    /**
     * @return the measuredMaxSpeed in mm/s
     */
    public Integer getMeasuredMaxSpeed() {
        return measuredMaxSpeed;
    }

    /**
     * @param measuredMaxSpeed
     *            the measuredMaxSpeed in mm/s to set
     */
    public void setMeasuredMaxSpeed(Integer measuredMaxSpeed) {
        Integer oldValue = this.measuredMaxSpeed;
        this.measuredMaxSpeed = measuredMaxSpeed;

        firePropertyChange(PROPERTYNAME_MEASURED_MAX_SPEED, oldValue, measuredMaxSpeed);
    }

    /**
     * @return the targetMinSpeed
     */
    public Integer getTargetMinSpeed() {
        return targetMinSpeed;
    }

    /**
     * @param targetMinSpeed
     *            the targetMinSpeed to set
     */
    public void setTargetMinSpeed(Integer targetMinSpeed) {
        Integer oldValue = this.targetMinSpeed;
        this.targetMinSpeed = targetMinSpeed;

        firePropertyChange(PROPERTYNAME_TARGET_MIN_SPEED, oldValue, targetMinSpeed);
    }

    /**
     * @return the targetMaxSpeed
     */
    public Integer getTargetMaxSpeed() {
        return targetMaxSpeed;
    }

    /**
     * @param targetMaxSpeed
     *            the targetMaxSpeed to set
     */
    public void setTargetMaxSpeed(Integer targetMaxSpeed) {
        Integer oldValue = this.targetMaxSpeed;
        this.targetMaxSpeed = targetMaxSpeed;

        firePropertyChange(PROPERTYNAME_TARGET_MAX_SPEED, oldValue, targetMaxSpeed);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
