package org.bidib.wizard.mvc.main.view.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class TreeTest {

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {

            new TreeTest();
        });
    }

    public TreeTest() {
        JTree tree = getTree();
        ImageIcon icon1 = getIcon("/icons/16x16/connect.png"), icon2 = getIcon("/icons/16x16/lock.png");
        CustomRenderer renderer = new CustomRenderer(icon1, icon2);
        tree.setCellRenderer(renderer);
        tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        tree.addTreeSelectionListener(new CustomTreeSelectionListener());
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.add(new JScrollPane(tree));
        f.setSize(400, 400);
        f.setLocation(200, 200);
        f.setVisible(true);
    }

    private JTree getTree() {
        int rows = 4;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new NodeObject("tree", false));
        DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[rows];
        for (int j = 0; j < rows; j++) {
            nodes[j] = new DefaultMutableTreeNode(new NodeObject(String.valueOf(j + 1), false));
            root.insert(nodes[j], j);
            nodes[j].insert(new DefaultMutableTreeNode(new NodeObject("a", false)), 0);
            nodes[j].insert(new DefaultMutableTreeNode(new NodeObject("b", false)), 1);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        return new JTree(model);
    }

    private ImageIcon getIcon(String fileName) {
        BufferedImage image = null;
        try {
            URL url = getClass().getResource(fileName);
            image = ImageIO.read(url);
        }
        catch (MalformedURLException mue) {
            System.err.println("url: " + mue.getMessage());
        }
        catch (IOException ioe) {
            System.err.println("read: " + ioe.getMessage());
        }
        return new ImageIcon(image);
    }
}

class NodeObject {
    String name;

    boolean hasCat;

    public NodeObject(String name, boolean hasCat) {
        this.name = name;
        this.hasCat = hasCat;
    }

    public String toString() {
        return name;
    }
}

class CustomRenderer implements TreeCellRenderer {
    private JPanel component;

    private ImageIcon middleIcon, additionalIcon;

    private JLabel mainIconLabel, additionalIconLabel, valueLabel;

    public CustomRenderer(ImageIcon mainIcon, ImageIcon additionalIcon) {
        this.middleIcon = mainIcon;
        this.additionalIcon = additionalIcon;

        component = new JPanel();
        component.setLayout(new BoxLayout(component, BoxLayout.LINE_AXIS));
        mainIconLabel = new JLabel(new ImageIcon());
        additionalIconLabel = new JLabel(new ImageIcon());
        valueLabel = new JLabel();
        component.add(mainIconLabel);
        component.add(additionalIconLabel);
        component.add(Box.createRigidArea(new Dimension(4, 0)));
        component.add(valueLabel);
    }

    public Component getTreeCellRendererComponent(
        JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (leaf)
            mainIconLabel.setIcon(middleIcon);
        else
            mainIconLabel.setIcon(null);
        if (hasAdditionalIcon(value))
            additionalIconLabel.setIcon(additionalIcon);
        else
            additionalIconLabel.setIcon(null);

        component.setOpaque(false);
        valueLabel.setText(value.toString());
        return component;
    }

    private boolean hasAdditionalIcon(Object value) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
        NodeObject nodeObject = (NodeObject) node.getUserObject();
        return nodeObject.hasCat;
    }
}

class CustomTreeSelectionListener implements TreeSelectionListener {
    public void valueChanged(TreeSelectionEvent e) {
        JTree tree = (JTree) e.getSource();
        TreePath path = e.getNewLeadSelectionPath();
        // System.out.println("path = " + path);
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode) path.getLastPathComponent();
            if (node.isLeaf()) {
                // toggle hasCat variable in this NodeObject and tell model
                boolean hasCat = ((NodeObject) node.getUserObject()).hasCat;
                ((NodeObject) node.getUserObject()).hasCat = !hasCat;
                ((DefaultTreeModel) tree.getModel()).nodeChanged(node);
            }
        }
    }
}