/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.debug.view;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.debug.LineEndingEnum;
import org.bidib.jbidibc.jserialcomm.PortIdentifierUtils;
import org.bidib.jbidibc.messages.exception.InvalidLibraryException;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.scm.ScmPortIdentifierUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.client.common.component.TextLineNumber;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.common.view.text.ChangeDocumentListener;
import org.bidib.wizard.mvc.common.view.text.CopyAllAction;
import org.bidib.wizard.mvc.common.view.text.HistoryModel;
import org.bidib.wizard.mvc.common.view.text.HistoryTextField;
import org.bidib.wizard.mvc.common.view.text.JTextFieldLimitDocument;
import org.bidib.wizard.mvc.debug.controller.listener.DebugInterfaceControllerListener;
import org.bidib.wizard.mvc.debug.model.DebugInterfaceModel;
import org.bidib.wizard.mvc.debug.view.DebugInterfaceView;
import org.bidib.wizard.mvc.debug.view.FileStringConverter;
import org.bidib.wizard.mvc.debug.view.FileTransferProgressDialog;
import org.bidib.wizard.mvc.debug.view.listener.DebugInterfaceViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugInterfaceView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugInterfaceView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, max(100dlu;pref), 3dlu, 20dlu, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow, 3dlu, pref, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "p, 3dlu, p, 3dlu, fill:50dlu:grow, 3dlu, p, 3dlu, p";
    private final Collection<DebugInterfaceViewListener> listeners = new LinkedList();
    private final DebugInterfaceModel debugInterfaceModel;
    private final DockableStateChangeListener dockableStateChangeListener;
    private final JComponent contentPanel;
    private ValueModel selectionHolderComPort;
    private ValueModel sendTextValueModel;
    private ValueModel selectionHolderBaudRate;
    private ValueModel sendFileValueModel;
    private JTextField sendText;
    private JTextField sendFile;
    private final JButton refreshButton = new JButton(Resources.getString(this.getClass(), (String)"refresh"));
    private final JButton connectButton = new JButton(Resources.getString(this.getClass(), (String)"connect"));
    private final JButton disconnectButton = new JButton(Resources.getString(this.getClass(), (String)"disconnect"));
    private final JButton transmitButton = new JButton(Resources.getString(this.getClass(), (String)"transmit"));
    private final JButton transmitFileButton = new JButton(Resources.getString(this.getClass(), (String)"transmit"));
    private final JButton selectFileButton = new JButton(Resources.getString(this.getClass(), (String)"selectFile"));
    private JCheckBoxMenuItem autoScrollsItem;
    private final JScrollPane logsPane;
    private final JTextArea logsArea;
    private TextLineNumber tln;
    private SelectionInList<CommPort> commPortSelection;
    private boolean timestampsEnabled;
    private JCheckBox addTimeStamps;
    private JCheckBox logToFile;
    private ValueModel selectedLogFileValueModel;
    private final JButton selectLogFileButton = new JButton(Resources.getString(this.getClass(), (String)"select-logfile"));
    private final SettingsService settingsService;
    private static FileFilter logfileFilter;
    private static final String LOGFILE_EXTENSION = "log";
    private static final String WORKING_DIR_DEBUG_INTERFACE_KEY = "debugInterface";
    private String savedLogFilesDescription;
    private int currentLineLen;
    private final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final String LOGGER_PANE_NAME = "DebugInterfacePane";
    private static final Logger LOGGER_PANE;
    private final StringBuilder sbLogger = new StringBuilder();
    private static final String SUFFIX_HEX = "hex";
    private static final String SUFFIX_EEP = "eep";
    private final FileFilter ff = new /* Unavailable Anonymous Inner Class!! */;
    private static final String SUFFIX_LOG = "log";
    private static final String SUFFIX_TXT = "txt";
    private final FileFilter ffLogFile = new /* Unavailable Anonymous Inner Class!! */;

    public DebugInterfaceView(DockingDesktop desktop, DebugInterfaceControllerListener listener, DebugInterfaceModel debugInterfaceModel, SettingsService settingsService) {
        Object panel;
        this.settingsService = settingsService;
        this.debugInterfaceModel = debugInterfaceModel;
        DockKeys.DOCKKEY_DEBUG_INTERFACE_VIEW.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_DEBUG_INTERFACE_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_DEBUG_INTERFACE_VIEW.setAutoHideEnabled(false);
        this.dockableStateChangeListener = new /* Unavailable Anonymous Inner Class!! */;
        desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
        LOGGER.info("Create new DebugInterfaceView");
        this.loadPortIdentifiers(this.debugInterfaceModel);
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        this.commPortSelection = new SelectionInList((ListModel)this.debugInterfaceModel.getCommPortsListModel());
        this.selectionHolderComPort = new PropertyAdapter((Object)this.debugInterfaceModel, "selectedPort", true);
        ComboBoxAdapter comboBoxAdapterCommPorts = new ComboBoxAdapter((ListModel)this.commPortSelection, this.selectionHolderComPort);
        JComboBox comboCommPorts = new JComboBox();
        comboCommPorts.setModel(comboBoxAdapterCommPorts);
        if (this.debugInterfaceModel.getSelectedPort() != null) {
            String activeCommPortName = this.debugInterfaceModel.getSelectedPort().toString();
            CommPort activeCommPort = null;
            for (CommPort commPort : this.debugInterfaceModel.getCommPorts()) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    if (activeCommPortName == null || !activeCommPortName.startsWith(commPort.getName())) continue;
                    activeCommPort = commPort;
                    break;
                }
                if (activeCommPortName == null || !activeCommPortName.equals(commPort.getName())) continue;
                activeCommPort = commPort;
                break;
            }
            comboCommPorts.setSelectedItem(activeCommPort);
            listener.setSelectedCommPort(activeCommPort);
        }
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"selectedPort"), new Object[0]).xy(1, 1);
        dialogBuilder.add(comboCommPorts).xy(3, 1);
        this.refreshButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        dialogBuilder.add((Component)this.refreshButton).xy(5, 1);
        ArrayList<Integer> baudRates = new ArrayList<Integer>();
        baudRates.add(19200);
        baudRates.add(115200);
        this.selectionHolderBaudRate = new PropertyAdapter((Object)this.debugInterfaceModel, "baudRate", true);
        ComboBoxAdapter comboBoxAdapter = new ComboBoxAdapter(baudRates, this.selectionHolderBaudRate);
        JComboBox comboBaudRate = new JComboBox();
        comboBaudRate.setModel(comboBoxAdapter);
        if (this.debugInterfaceModel.getBaudRate() != null) {
            comboBaudRate.setSelectedItem(this.debugInterfaceModel.getBaudRate());
        } else {
            comboBaudRate.setSelectedIndex(1);
        }
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"selectedBaudRate"), new Object[0]).xy(7, 1);
        dialogBuilder.add(comboBaudRate).xy(9, 1);
        this.refreshButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.connectButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.disconnectButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.disconnectButton.setEnabled(false);
        ArrayList<LineEndingEnum> lineEndings = new ArrayList<LineEndingEnum>();
        for (LineEndingEnum lineEnding : LineEndingEnum.values()) {
            lineEndings.add(lineEnding);
        }
        PropertyAdapter selectionHolderLineEnding = new PropertyAdapter((Object)this.debugInterfaceModel, "lineEnding", true);
        ComboBoxAdapter comboAdapterLineEnding = new ComboBoxAdapter(lineEndings, (ValueModel)selectionHolderLineEnding);
        JComboBox comboLineEnding = new JComboBox();
        comboLineEnding.setModel(comboAdapterLineEnding);
        comboLineEnding.setRenderer(new LineEndingCellRenderer(this));
        JPanel debugInterfaceActionButtons = new ButtonBarBuilder().addButton((JComponent)this.connectButton).addRelatedGap().addButton((JComponent)this.disconnectButton).build();
        dialogBuilder.add((Component)debugInterfaceActionButtons).xy(11, 1);
        this.addTimeStamps = new JCheckBox(Resources.getString(this.getClass(), (String)"addTimestamps"));
        dialogBuilder.add((Component)this.addTimeStamps).xy(13, 1);
        this.logToFile = new JCheckBox(Resources.getString(this.getClass(), (String)"logToFile"));
        dialogBuilder.add((Component)this.logToFile).xy(1, 3);
        this.selectedLogFileValueModel = new PropertyAdapter((Object)this.debugInterfaceModel, "logFileName", true);
        JTextField selectedLogFileText = WizardComponentFactory.createTextField((ValueModel)this.selectedLogFileValueModel, (boolean)true);
        selectedLogFileText.setEditable(false);
        dialogBuilder.add((Component)selectedLogFileText).xy(3, 3);
        this.selectLogFileButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        dialogBuilder.add((Component)this.selectLogFileButton).xy(5, 3);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"lineEnding"), new Object[0]).xy(7, 3);
        dialogBuilder.add(comboLineEnding).xy(9, 3);
        this.logsPane = new /* Unavailable Anonymous Inner Class!! */;
        this.logsArea = new /* Unavailable Anonymous Inner Class!! */;
        this.logsArea.setEditable(false);
        this.logsArea.setFont(new Font("Monospaced", 0, 13));
        this.logsPane.getViewport().add((Component)this.logsArea, null);
        this.tln = new TextLineNumber((JTextComponent)this.logsArea);
        this.logsPane.setRowHeaderView((Component)this.tln);
        this.logsPane.setAutoscrolls(true);
        dialogBuilder.add((Component)this.logsPane).xyw(1, 5, 17);
        this.sendTextValueModel = new PropertyAdapter((Object)this.debugInterfaceModel, "sendText", true);
        HistoryModel.setMax((int)20);
        this.sendText = new HistoryTextField("sendText", false, true);
        JTextFieldLimitDocument sendTextDoc = new JTextFieldLimitDocument(128);
        this.sendText.setDocument((Document)sendTextDoc);
        Bindings.bind((JTextField)this.sendText, (ValueModel)this.sendTextValueModel, (boolean)false);
        this.sendText.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultOverlayable sendTextOverlayable = new DefaultOverlayable((JComponent)this.sendText);
        sendTextOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + Resources.getString(this.getClass(), (String)"transmitText.prompt") + ":f:gray}")), 7);
        sendTextOverlayable.setOverlayLocationInsets(new Insets(0, -5, 0, 5));
        sendTextDoc.addDocumentListener((DocumentListener)new ChangeDocumentListener(doc -> sendTextOverlayable.setOverlayVisible(doc.getLength() < 1)));
        sendTextOverlayable.setOverlayVisible(sendTextDoc.getLength() < 1);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"transmitText"), new Object[0]).xy(1, 7);
        dialogBuilder.add((Component)sendTextOverlayable).xyw(3, 7, 13);
        dialogBuilder.add((Component)this.transmitButton).xy(17, 7);
        this.transmitButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.transmitButton.setEnabled(false);
        this.sendFileValueModel = new PropertyAdapter((Object)this.debugInterfaceModel, "sendFile", true);
        ConverterValueModel sendFileConverterModel = new ConverterValueModel(this.sendFileValueModel, (BindingConverter)new FileStringConverter());
        this.sendFile = WizardComponentFactory.createTextField((ValueModel)sendFileConverterModel, (boolean)true);
        this.sendFile.setEditable(false);
        DefaultOverlayable sendFileOverlayable = new DefaultOverlayable((JComponent)this.sendFile);
        sendFileOverlayable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + Resources.getString(this.getClass(), (String)"transmitFile.prompt") + ":f:gray}")), 7);
        sendFileOverlayable.setOverlayLocationInsets(new Insets(0, -5, 0, 5));
        Document sendFileDoc = this.sendFile.getDocument();
        sendFileDoc.addDocumentListener((DocumentListener)new ChangeDocumentListener(doc -> sendFileOverlayable.setOverlayVisible(doc.getLength() < 1)));
        sendFileOverlayable.setOverlayVisible(sendFileDoc.getLength() < 1);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"transmitFile"), new Object[0]).xy(1, 9);
        dialogBuilder.add((Component)sendFileOverlayable).xyw(3, 9, 11);
        dialogBuilder.add((Component)this.selectFileButton).xy(15, 9);
        this.selectFileButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        dialogBuilder.add((Component)this.transmitFileButton).xy(17, 9);
        this.transmitFileButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.transmitFileButton.setEnabled(false);
        PropertyConnector.connect((Object)this.debugInterfaceModel, (String)"transmitEnabled", (Object)this.transmitButton, (String)"enabled");
        PropertyConnector.connect((Object)this.debugInterfaceModel, (String)"transmitEnabled", (Object)this.transmitFileButton, (String)"enabled");
        PropertyConnector.connect((Object)this.debugInterfaceModel, (String)"disconnected", (Object)this.connectButton, (String)"enabled");
        PropertyConnector.connect((Object)this.debugInterfaceModel, (String)"connected", (Object)this.disconnectButton, (String)"enabled");
        JPanel contentPanelTemp = dialogBuilder.build();
        JideScrollPane scrollPane = new JideScrollPane((Component)contentPanelTemp);
        this.contentPanel = scrollPane;
        BasicPopupMenu popupMenu = new BasicPopupMenu();
        this.prepareMenuItems((JPopupMenu)popupMenu);
        this.logsArea.setComponentPopupMenu((JPopupMenu)popupMenu);
        this.addTimeStamps.addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
        this.logToFile.addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void prepareMenuItems(JPopupMenu menu) {
        this.autoScrollsItem = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"autoScrolls"));
        this.autoScrollsItem.setSelected(true);
        this.autoScrollsItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem((Object)menu, (JMenuItem)this.autoScrollsItem);
        JMenuItem clearConsole = new JMenuItem(Resources.getString(this.getClass(), (String)"clear_console"));
        clearConsole.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem((Object)menu, clearConsole);
        JMenuItem copyAllToClipboard = new JMenuItem(Resources.getString(this.getClass(), (String)"copyAllToClipboard"));
        copyAllToClipboard.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem((Object)menu, copyAllToClipboard);
        JMenuItem saveToFile = new JMenuItem(Resources.getString(this.getClass(), (String)"save_to_file"), ImageUtils.createImageIcon(this.getClass(), (String)"/icons/savetofile.png"));
        saveToFile.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem((Object)menu, saveToFile);
        JMenuItem saveSelectedToFile = new JMenuItem(Resources.getString(this.getClass(), (String)"save_selected_to_file"), ImageUtils.createImageIcon(this.getClass(), (String)"/icons/saveselectedtofile.png"));
        saveSelectedToFile.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem((Object)menu, saveSelectedToFile);
    }

    private void addMenuItem(Object menu, JMenuItem menuItem) {
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(menuItem);
        } else if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(menuItem);
        }
    }

    private void fireTimestampsEnabledChanged(boolean timestampsEnabled) {
        this.timestampsEnabled = timestampsEnabled;
    }

    private void fireClearConsole() {
        LOGGER.info("clear the console.");
        this.logsArea.setText(null);
        this.logsArea.setCaretPosition(this.logsArea.getDocument().getLength());
        boolean enabled = this.autoScrollsItem.isSelected();
        this.logsArea.setAutoscrolls(!enabled);
        this.logsArea.setAutoscrolls(enabled);
    }

    private void fireCopyAllToClipboard() {
        LOGGER.info("Copy all content to clipboard.");
        ActionEvent copyAll = new ActionEvent(this.logsArea, 0, "copy-all-to-clipboard");
        CopyAllAction action = new CopyAllAction();
        action.actionPerformed(copyAll);
    }

    private void fireSaveToFile(boolean selectedOnly) {
        LOGGER.info("Save the console content to file.");
        this.savedLogFilesDescription = Resources.getString(this.getClass(), (String)"savedLogFilesDescription");
        logfileFilter = new FileNameExtensionFilter(this.savedLogFilesDescription, "log");
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_DEBUG_INTERFACE_KEY);
        19 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    private void fireRefreshComPorts() {
        this.loadPortIdentifiers(this.debugInterfaceModel);
    }

    private void fireConnect() {
        for (DebugInterfaceViewListener listener : this.listeners) {
            listener.openConnection();
        }
    }

    private void fireDisconnect() {
        for (DebugInterfaceViewListener listener : this.listeners) {
            listener.closeConnection();
        }
    }

    private void fireTransmit() {
        for (DebugInterfaceViewListener listener : this.listeners) {
            listener.transmit();
        }
        this.sendText.setText(null);
    }

    private void fireTransmitFile() {
        boolean modal = true;
        FileTransferProgressDialog progressDialog = new FileTransferProgressDialog((Component)this.contentPanel, modal, this.listeners);
    }

    private void fireSelectFile() {
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_DEBUG_INTERFACE_KEY);
        20 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_DEBUG_INTERFACE_VIEW;
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public void addDebugInterfaceViewListener(DebugInterfaceViewListener l) {
        this.listeners.add(l);
    }

    public void addLog(String logMessage) {
        SwingUtils.executeInEDT(() -> this.addLogMessage(logMessage));
    }

    private void addLogMessage(String logMessage) {
        try {
            int lines = this.logsArea.getLineCount();
            if (lines > 2000) {
                int end = this.logsArea.getLineEndOffset(50);
                this.logsArea.getDocument().remove(0, end);
            }
        }
        catch (BadLocationException ex) {
            LOGGER.warn("Remove some lines from logsArea failed.", (Throwable)ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received message: {}", (Object)ByteUtils.bytesToHex((byte[])logMessage.getBytes(StandardCharsets.UTF_8)));
        }
        int beginIndex = 0;
        int index = logMessage.indexOf(10);
        int lenOfTimestamp = 0;
        if (index > -1) {
            String part;
            if (index - beginIndex == 2 && logMessage.charAt(0) == '\u0000') {
                LOGGER.warn("Skip empty line with 00 0D 0A.");
                this.logsArea.append("\n");
                beginIndex = index + 1;
                index = logMessage.indexOf(10, beginIndex);
            }
            while (index > -1) {
                part = logMessage.substring(beginIndex, index);
                if (this.timestampsEnabled && this.currentLineLen == 0) {
                    this.sbLogger.append(this.sdf.format(new Date()));
                    this.sbLogger.append(" - ");
                    lenOfTimestamp = 12;
                }
                this.sbLogger.append(part);
                LOGGER.debug("1. Added part: {}, currentLineLen: {}, sbLogger: {}", new Object[]{part, this.currentLineLen, this.sbLogger});
                this.logsArea.append(this.sbLogger.substring(this.currentLineLen));
                this.logsArea.append("\n");
                LOGGER_PANE.info(this.sbLogger.toString().replace("\r", ""));
                lenOfTimestamp = 0;
                this.sbLogger.setLength(0);
                this.currentLineLen = 0;
                beginIndex = index + 1;
                index = logMessage.indexOf(10, beginIndex);
            }
            lenOfTimestamp = 0;
            if (beginIndex < logMessage.length()) {
                part = logMessage.substring(beginIndex);
                if (this.timestampsEnabled) {
                    this.sbLogger.append(this.sdf.format(new Date()));
                    this.sbLogger.append(" - ");
                    lenOfTimestamp = 12;
                }
                this.sbLogger.append(part);
                LOGGER.debug("2. Added part: {}, currentLineLen: {}, sbLogger: {}", new Object[]{part, this.currentLineLen, this.sbLogger});
                this.logsArea.append(this.sbLogger.substring(this.currentLineLen));
                this.currentLineLen = part.length() + lenOfTimestamp;
                lenOfTimestamp = 0;
                LOGGER.debug("Added last part: {}, currentLineLen: {}", (Object)part, (Object)this.currentLineLen);
            }
        } else {
            if (this.timestampsEnabled && this.currentLineLen == 0) {
                LOGGER.debug("Add timestamp, currentLineLen: {}", (Object)this.currentLineLen);
                this.sbLogger.append(this.sdf.format(new Date()));
                this.sbLogger.append(" - ");
                lenOfTimestamp = 12;
            }
            String toLog = logMessage;
            if (logMessage.length() > 120 - this.currentLineLen) {
                int start = 0;
                int end = 0;
                String part = null;
                toLog = null;
                end = start + (120 - this.currentLineLen);
                while (end < logMessage.length()) {
                    part = StringUtils.substring((String)logMessage, (int)start, (int)end);
                    LOGGER.debug("Fetched part, currentLineLen {}, part: '{}'", (Object)this.currentLineLen, (Object)part);
                    this.sbLogger.append(part);
                    this.logsArea.append(this.sbLogger.substring(this.currentLineLen));
                    this.logsArea.append("\n");
                    this.currentLineLen = 120;
                    LOGGER.debug("Added logMessage: {}, currentLineLen: {}", (Object)logMessage, (Object)this.currentLineLen);
                    this.currentLineLen = 0;
                    this.sbLogger.setLength(0);
                    end = (start += 120) + (120 - this.currentLineLen);
                }
                if (start < logMessage.length()) {
                    LOGGER.debug("Keep the remaining part from logMessage, currentLineLen: {}", (Object)this.currentLineLen, (Object)start);
                    toLog = StringUtils.substring((String)logMessage, (int)start);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)toLog)) {
                if (toLog.charAt(0) == '\u0000' && toLog.length() == 1) {
                    LOGGER.warn("Skip empty line with 00.");
                } else {
                    this.sbLogger.append(toLog);
                    LOGGER.debug("3. Added logMessage: {}, currentLineLen: {}, sbLogger: {}", new Object[]{toLog, this.currentLineLen, this.sbLogger});
                    this.logsArea.append(this.sbLogger.substring(this.currentLineLen));
                    this.currentLineLen += toLog.length() + lenOfTimestamp;
                    LOGGER.debug("Added logMessage: {}, currentLineLen: {}", (Object)logMessage, (Object)this.currentLineLen);
                }
            }
        }
        if (this.currentLineLen > 120) {
            LOGGER.debug("Append new line to logsArea, currentLineLen: {}", (Object)this.currentLineLen);
            this.logsArea.append("\n");
            LOGGER_PANE.info(this.sbLogger.toString().replace("\r", ""));
            lenOfTimestamp = 0;
            this.sbLogger.setLength(0);
            this.currentLineLen = 0;
        }
    }

    private void loadPortIdentifiers(DebugInterfaceModel model) {
        LOGGER.info("Load the comm ports, model: {}", (Object)model);
        HashSet<CommPort> commPorts = new HashSet<CommPort>();
        try {
            List portIdentifiers = null;
            switch (this.settingsService.getMiscSettings().getSelectedSerialPortProvider()) {
                case "FTDI": {
                    portIdentifiers = org.bidib.jbidibc.ftdi.serial.PortIdentifierUtils.getPortIdentifiers();
                    break;
                }
                case "SCM": {
                    portIdentifiers = ScmPortIdentifierUtils.getPortIdentifiers();
                    break;
                }
                case "SPSW": {
                    portIdentifiers = org.bidib.jbidibc.purejavacomm.PortIdentifierUtils.getPortIdentifiers();
                    break;
                }
                case "JSerialComm": {
                    portIdentifiers = PortIdentifierUtils.getPortIdentifiers();
                    break;
                }
                case "PureJavaComm": {
                    portIdentifiers = org.bidib.jbidibc.purejavacomm.PortIdentifierUtils.getPortIdentifiers();
                    break;
                }
                default: {
                    portIdentifiers = org.bidib.jbidibc.rxtx.PortIdentifierUtils.getPortIdentifiers();
                }
            }
            if (portIdentifiers != null) {
                for (String id : portIdentifiers) {
                    LOGGER.info("Add new CommPort with id: {}", (Object)id);
                    commPorts.add(new CommPort(id));
                }
            }
        }
        catch (InvalidLibraryException ex) {
            LOGGER.warn("Fetch port identifiers failed. This can be caused because the ext/lib directory of the Java installation contains an old RXTXComm.jar!", (Throwable)ex);
            JOptionPane.showMessageDialog(this.contentPanel, Resources.getString(DebugInterfaceView.class, (String)"fetch-port-identifiers-failed", (Object[])new Object[]{new File(SystemUtils.getJavaHome(), "lib/ext").getPath()}), Resources.getString(DebugInterfaceView.class, (String)"title-error"), 0);
        }
        catch (Exception ex) {
            LOGGER.warn("Fetch port identifiers failed.", (Throwable)ex);
        }
        model.setCommPorts(Arrays.asList(commPorts.toArray(new CommPort[0])));
    }

    private void selectLogFile() {
        WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
        String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_DEBUG_INTERFACE_KEY);
        23 dialog = new /* Unavailable Anonymous Inner Class!! */;
        dialog.showDialog();
    }

    static {
        LOGGER_PANE = LoggerFactory.getLogger((String)LOGGER_PANE_NAME);
    }
}

