/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import javax.swing.event.ListSelectionListener;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.main.view.panel.NodeListPanel;
import org.bidib.wizard.mvc.main.view.panel.TabPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.mvc.worklist.controller.WorkListItemProvider;
import org.bidib.wizard.nodescript.script.node.NodeScriptingSupportProvider;
import org.bidib.wizard.nodescript.script.node.ScriptingSupportProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;

public class MainPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainPanel.class);
    private NodeListPanel nodeListPanel;
    private TabPanel tabPanel;
    private final MainModel mainModel;
    private final ConnectionPhaseModel connectionPhaseModel;
    private final SettingsService settingsService;
    private final WizardLabelWrapper wizardLabelWrapper;
    private final NodeScriptingSupportProvider nodeScriptingSupportProvider;
    private final LookupService lookupService;
    private final StatusBar statusBar;

    public MainPanel(MainModel mainModel, ConnectionPhaseModel connectionPhaseModel, SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper, NodeScriptingSupportProvider nodeScriptingSupportProvider, LookupService lookupService, StatusBar statusBar) {
        this.mainModel = mainModel;
        this.connectionPhaseModel = connectionPhaseModel;
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.nodeScriptingSupportProvider = nodeScriptingSupportProvider;
        this.lookupService = lookupService;
        this.statusBar = statusBar;
    }

    public void create(DockingDesktop desktop, MainMenuListener mainMenuListener, ApplicationContext applicationContext, WorkListItemProvider workListItemProvider) {
        LOGGER.info("Create the tabPanel and nodeListPanel.");
        this.nodeListPanel = new NodeListPanel(this.mainModel, this.settingsService, this.wizardLabelWrapper, (ApplicationEventPublisher)applicationContext, workListItemProvider, this.statusBar);
        this.tabPanel = new TabPanel(this.mainModel, this.connectionPhaseModel, this.settingsService, (ScriptingSupportProvider)this.nodeScriptingSupportProvider, mainMenuListener, applicationContext, this.lookupService);
        LOGGER.info("Register tabPanel and nodeListPanel in applicationContext.");
        DefaultApplicationContext.getInstance().register("tabPanel", (Object)this.tabPanel);
        DefaultApplicationContext.getInstance().register("nodeListPanel", (Object)this.nodeListPanel);
        desktop.addDockable((Dockable)this.nodeListPanel);
        desktop.split((Dockable)this.nodeListPanel, (Dockable)this.tabPanel, DockingConstants.SPLIT_RIGHT);
        desktop.setDockableWidth((Dockable)this.nodeListPanel, 0.2);
        LOGGER.info("Added node list and tab panel to desktop.");
    }

    public void addNodeListListener(NodeListActionListener l) {
        this.nodeListPanel.addNodeListListener(l);
    }

    public void addNodeListSelectionListener(ListSelectionListener l) {
        this.nodeListPanel.addListSelectionListener(l);
    }

    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        this.tabPanel.addCvDefinitionRequestListener(l);
    }

    public void performShutdown() {
        if (this.nodeListPanel != null) {
            this.nodeListPanel.performShutdown();
        }
        if (this.tabPanel != null) {
            this.tabPanel.performShutdown();
        }
    }

    public void savePendingChanges() {
        if (this.tabPanel != null) {
            this.tabPanel.savePendingChanges();
        }
    }
}

