/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view.panel;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.ValidationResultModel;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.PtOperation;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.pt.model.PtProgrammerModel;
import org.bidib.wizard.mvc.pt.model.listener.ProgCommandListener;
import org.bidib.wizard.mvc.pt.view.CommandStationProgStateConverter;
import org.bidib.wizard.mvc.pt.view.command.PtOperationCommand;
import org.bidib.wizard.mvc.pt.view.panel.AbstractPtPanel;
import org.bidib.wizard.mvc.pt.view.panel.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pt.view.panel.PtResultProxyModel;
import org.bidib.wizard.mvc.pt.view.panel.listener.PtRequestListener;
import org.bidib.wizard.mvc.pt.view.panel.listener.PtResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractPtPanel<M extends ProgCommandAwareBeanModel>
implements PtResultListener {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu";
    private final List<PtRequestListener> listeners = new LinkedList();
    protected final PtProgrammerModel cvProgrammerModel;
    protected final PtResultProxyModel ptResultProxyModel;
    protected final JButton readButton = new JButton(Resources.getString(AbstractPtPanel.class, (String)"read"));
    protected final JButton writeButton = new JButton(Resources.getString(AbstractPtPanel.class, (String)"write"));
    protected ValueModel readButtonEnabled;
    protected ValueModel writeButtonEnabled;
    protected ValueModel currentOperationModel;
    protected JLabel currentOperationLabel;
    private ImageIcon progOperationErrorIcon;
    private ImageIcon progOperationSuccessfulIcon;
    private ImageIcon progOperationWaitIcon;
    protected ImageIcon progOperationUnknownIcon;
    protected ImageIcon progOperationEmptyIcon;
    private JTextArea loggerArea;
    private static final String NEWLINE = "\n";
    protected boolean activeTab;
    private M progCommandAwareBeanModel;

    public AbstractPtPanel(PtProgrammerModel cvProgrammerModel) {
        this.cvProgrammerModel = cvProgrammerModel;
        this.ptResultProxyModel = new /* Unavailable Anonymous Inner Class!! */;
        this.initializeIcons();
    }

    private void initializeIcons() {
        this.progOperationErrorIcon = ImageUtils.createImageIcon(AbstractPtPanel.class, (String)"/icons/accessory-error.png");
        this.progOperationSuccessfulIcon = ImageUtils.createImageIcon(AbstractPtPanel.class, (String)"/icons/accessory-successful.png");
        this.progOperationWaitIcon = ImageUtils.createImageIcon(AbstractPtPanel.class, (String)"/icons/accessory-wait.png");
        this.progOperationUnknownIcon = ImageUtils.createImageIcon(AbstractPtPanel.class, (String)"/icons/information.png");
        this.progOperationEmptyIcon = ImageUtils.createImageIcon(AbstractPtPanel.class, (String)"/icons/empty.png");
    }

    public ProgCommandAwareBeanModel getProgCommandAwareBeanModel() {
        return this.progCommandAwareBeanModel;
    }

    public void setProgCommandAwareBeanModel(M progCommandAwareBeanModel) {
        this.progCommandAwareBeanModel = progCommandAwareBeanModel;
    }

    public void addPtRequestListener(PtRequestListener l) {
        this.listeners.add(l);
    }

    protected List<PtRequestListener> getPtRequestListeners() {
        return this.listeners;
    }

    public void setActive(boolean active) {
        this.LOGGER.info("Set the active flag: {}", (Object)active);
        this.activeTab = active;
    }

    public boolean isActive() {
        return this.activeTab;
    }

    protected abstract void createWorkerPanel(FormBuilder var1, int[] var2);

    public JPanel createPanel() {
        this.cvProgrammerModel.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        FormBuilder builder = null;
        boolean debug = false;
        builder = debug ? FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)new FormDebugPanel()) : FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel(new JPanel());
        builder.border((Border)Paddings.TABBED_DIALOG);
        int[] rowHolder = new int[]{1};
        this.createWorkerPanel(builder, rowHolder);
        int currentRow = rowHolder[0];
        currentRow += 2;
        this.currentOperationModel = new PropertyAdapter((Object)this.ptResultProxyModel, "commandStationProgState", true);
        ConverterValueModel valueConverterModel = new ConverterValueModel(this.currentOperationModel, (BindingConverter)new CommandStationProgStateConverter());
        this.currentOperationLabel = WizardComponentFactory.createLabel((ValueModel)valueConverterModel);
        this.currentOperationLabel.setIcon(this.progOperationEmptyIcon);
        builder.appendRows("pref, 5dlu", new Object[0]);
        builder.add(Resources.getString(AbstractPtPanel.class, (String)"prog-result"), new Object[0]).xy(1, currentRow);
        builder.add((Component)this.currentOperationLabel).xyw(3, currentRow, 5);
        this.loggerArea = new JTextArea(20, 45);
        this.loggerArea.setFont(UIManager.getDefaults().getFont("Label.font"));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.loggerArea);
        this.loggerArea.setEditable(false);
        builder.appendRows("fill:200px:grow", new Object[0]);
        builder.add((Component)scrollPane).xyw(1, currentRow += 2, 7);
        this.doBindButtons();
        this.cvProgrammerModel.addProgCommandListener((ProgCommandListener)new /* Unavailable Anonymous Inner Class!! */);
        this.cvProgrammerModel.addPropertyChangeListener("cvValue", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel panel = null;
        if (this.getValidationResultModel() != null) {
            this.LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel(this.getValidationResultModel(), (JComponent)builder.build());
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            panel = feedbackBuilder.build();
            panel = feedbackBuilder.build();
            this.triggerValidation();
        } else {
            panel = builder.build();
        }
        return panel;
    }

    protected void doBindButtons() {
        PropertyConnector.connect((Object)this.readButtonEnabled, (String)"value", (Object)this.readButton, (String)"enabled");
        PropertyConnector.connect((Object)this.writeButtonEnabled, (String)"value", (Object)this.writeButton, (String)"enabled");
    }

    protected void triggerValidation() {
    }

    protected ValidationResultModel getValidationResultModel() {
        return null;
    }

    public void addLogText(String logLine, Object ... args) {
        this.LOGGER.info("Add text to loggerArea, logLine: {}, args: {}", (Object)logLine, (Object)args);
        if (args != null) {
            logLine = MessageFormatter.arrayFormat((String)logLine, (Object[])args).getMessage();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS - ");
        StringBuilder message = new StringBuilder(sdf.format(new Date()));
        message.append(logLine).append(NEWLINE);
        if (SwingUtilities.isEventDispatchThread()) {
            this.loggerArea.append(message.toString());
            this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
        } else {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected abstract Object getCurrentOperation();

    public void signalCommandStationProgStateChanged(CommandStationProgState commandStationProgState) {
        if (!this.isActive()) {
            this.LOGGER.info("Do not process result because this is not the active tab.");
            return;
        }
        if (commandStationProgState != null) {
            switch (6.$SwitchMap$org$bidib$jbidibc$messages$enums$CommandStationProgState[commandStationProgState.ordinal()]) {
                case 1: {
                    this.currentOperationLabel.setIcon(this.progOperationSuccessfulIcon);
                    this.addLogText("Prog operation passed: " + String.valueOf(this.getCurrentOperation()), new Object[0]);
                    this.enableInputElements();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.currentOperationLabel.setIcon(this.progOperationErrorIcon);
                    this.addLogText("Prog operation failed: " + commandStationProgState.name(), new Object[0]);
                    this.enableInputElements();
                    break;
                }
                case 8: {
                    this.currentOperationLabel.setIcon(this.progOperationUnknownIcon);
                    this.addLogText("Prog operation started: " + String.valueOf(this.getCurrentOperation()), new Object[0]);
                    break;
                }
                case 9: {
                    this.currentOperationLabel.setIcon(this.progOperationWaitIcon);
                    this.addLogText("Prog operation is running ...", new Object[0]);
                }
            }
        } else {
            this.currentOperationLabel.setIcon(this.progOperationEmptyIcon);
        }
    }

    protected void sendRequest(PtOperation operation, int cvNumber, int cvValue) {
        this.cvProgrammerModel.setCvValue(null);
        this.cvProgrammerModel.setCommandStationProgState(null);
        for (PtRequestListener listener : this.getPtRequestListeners()) {
            listener.sendRequest((PtResultListener)this, operation, cvNumber, cvValue);
        }
    }

    protected void disableInputElements() {
        if (this.readButtonEnabled != null) {
            this.readButtonEnabled.setValue((Object)false);
        }
        if (this.writeButtonEnabled != null) {
            this.writeButtonEnabled.setValue((Object)false);
        }
    }

    protected void enableInputElements() {
    }

    protected void fireNextCommand() {
        this.disableInputElements();
        List progCommands = this.progCommandAwareBeanModel.getProgCommands();
        this.LOGGER.info("Prepared commands for addressing the decoder: {}", (Object)progCommands);
        PtOperationCommand progCommand = (PtOperationCommand)progCommands.remove(0);
        this.progCommandAwareBeanModel.setCurrentOperation(progCommand.getPtOperation());
        switch (6.$SwitchMap$org$bidib$jbidibc$messages$enums$PtOperation[progCommand.getPtOperation().ordinal()]) {
            case 2: 
            case 4: {
                this.progCommandAwareBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.WRITE);
                break;
            }
            default: {
                this.progCommandAwareBeanModel.setExecution(ProgCommandAwareBeanModel.ExecutionType.READ);
            }
        }
        this.progCommandAwareBeanModel.setExecutingProgCommand(progCommand);
        this.addLogText("Prog write request: {}", new Object[]{progCommand});
        this.sendRequest(progCommand.getPtOperation(), progCommand.getCvNumber(), progCommand.getCvValue());
    }
}

