package org.bidib.wizard.mvc.main.view.table;

import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.DmxChannelRenderer;
import org.bidib.wizard.client.common.view.renderer.LocalPortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.slider.ConfigXAwareSliderRenderer;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.Subject;

public class BacklightPortTable extends AbstractPortHierarchicalTable<BacklightPort> {
    private static final long serialVersionUID = 1L;

    private final BacklightPortTableModel backlightPortTableModel;

    public BacklightPortTable(final BacklightPortTableModel backlightPortTableModel, String emptyTableText) {
        super(backlightPortTableModel, emptyTableText);

        this.backlightPortTableModel = backlightPortTableModel;
    }

    @Override
    protected BacklightPortEditorPanel createPortEditorPanel(
        final BacklightPort port, int row, final Subject<PortConfigChangeEvent> portConfigChangeEventSubject,
        final NodeSelectionProvider nodeSelectionProvider) {
        BacklightPortEditorPanel editorPanel =
            new BacklightPortEditorPanel(port,
                backlightPort -> this.backlightPortTableModel.updatePortConfig(backlightPort),
                backlightPort -> this.backlightPortTableModel.fireTestButtonPressed(backlightPort),
                backlightPort -> this.backlightPortTableModel
                    .refreshRow(backlightPort,
                        changedRow -> repaint(getCellRect(changedRow, BacklightPortTableModel.COLUMN_LABEL, true))),
                portConfigChangeEventSubject, nodeSelectionProvider);
        editorPanel.createComponent();

        return editorPanel;
    }

    @Override
    public void clearTable() {

    }

    @Override
    protected RowStripeTableStyleProvider createTableStyleProvider(final TableModel portTableModel) {
        final RowStripeTableStyleProvider tableStyleProvider =
            new RowStripeTableStyleProvider(UIManager.getColor("tableRowStripe.background"),
                UIManager.getColor("tableRowStripe.alternativeBackground")) {

                @Override
                public CellStyle getCellStyleAt(JTable table, int rowIndex, int columnIndex) {

                    if (columnIndex != BacklightPortTableModel.COLUMN_LABEL) {
                        return super.getCellStyleAt(table, rowIndex, columnIndex);
                    }
                    else {

                        Port<?> port = (Port<?>) portTableModel.getValueAt(rowIndex, columnIndex);
                        CellStyle style = super.getCellStyleAt(table, rowIndex, columnIndex);
                        if (!port.isEnabled()) {
                            style = new CellStyle(style);
                            style.setForeground(disabledForeground);
                            return style;
                        }
                        return style;

                    }
                }
            };
        return tableStyleProvider;
    }

    @Override
    public void prepareTableColumns() {

        TableColumn tc = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_LABEL);
        tc.setCellRenderer(new LocalPortConfigErrorAwareRenderer(BacklightPortTableModel.COLUMN_LABEL));
        tc.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_LABEL));

        // dimm columns
        tc = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_DIM_SLOPE_DOWN);
        tc.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_DIM_SLOPE_DOWN));

        ConfigXAwareSliderRenderer sliderRendererDimmMin =
            new ConfigXAwareSliderRenderer(1, 255, 10, BidibLibrary.BIDIB_PCFG_DIMM_DOWN,
                BidibLibrary.BIDIB_PCFG_DIMM_DOWN_8_8);
        tc.setCellRenderer(sliderRendererDimmMin);

        tc = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_DIM_SLOPE_UP);
        tc.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_DIM_SLOPE_UP));
        ConfigXAwareSliderRenderer sliderRendererDimmMax =
            new ConfigXAwareSliderRenderer(1, 255, 10, BidibLibrary.BIDIB_PCFG_DIMM_UP,
                BidibLibrary.BIDIB_PCFG_DIMM_UP_8_8);
        tc.setCellRenderer(sliderRendererDimmMax);

        TableColumn tcDmxMapping = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_DMX_MAPPING);
        tcDmxMapping.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_DMX_MAPPING));
        tcDmxMapping.setMaxWidth(80);
        tcDmxMapping.setCellRenderer(new DmxChannelRenderer());

        tc = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_VALUE);
        tc.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_VALUE));
        tc.setCellRenderer(new SliderRenderer(0, 100, 10) {
            @Override
            protected void updateSliderTextValue(JTable table, int value, boolean isSelected, int row, int column) {
                String newValue = Integer.toString(value) + "%";
                sliderValue.setText(newValue);
            }
        });

        // remove the column with the port instance
        TableColumnChooser.hideColumn(this, BacklightPortTableModel.COLUMN_PORT_INSTANCE);

    }
}
