package org.bidib.wizard.mvc.position.controller;

import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.mvc.position.model.listener.FeedbackPositionListener;

public interface FeedbackPositionStatusChangeProvider {

    /**
     * Add a feedback position listener.
     * 
     * @param feedbackPositionListener
     *            the feedback position listener to add
     */
    void addFeedbackPortListener(final FeedbackPositionListener feedbackPositionListener);

    /**
     * Remove a feedback position listener.
     * 
     * @param feedbackPositionListener
     *            the feedback position listener to remove
     */
    void removeFeedbackPortListener(final FeedbackPositionListener feedbackPositionListener);

    /**
     * Add a port list listener.
     * 
     * @param portListListener
     *            the port list listener to add
     */
    void addPortListListener(PortListListener portListListener);

    /**
     * Remove a port list listener.
     * 
     * @param portListListener
     *            the port list listener to remove
     */
    void removePortListListener(PortListListener portListListener);

}
