/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.features.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.mvc.features.model.listener.FeatureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesModel.class);
    private final Collection<FeatureListener> listeners = new LinkedHashSet();
    private Map<Integer, Feature> features = new LinkedHashMap();
    private final NodeInterface node;

    public FeaturesModel(NodeInterface node) {
        this.node = node;
    }

    public NodeInterface getNode() {
        return this.node;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.listeners.add(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.listeners.remove(listener);
    }

    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(new LinkedList(this.features.values()));
    }

    public void setFeatures(Collection<Feature> features) {
        LOGGER.debug("Set the new features: {}", features);
        for (Feature newFeature : features) {
            Feature feature = (Feature)this.features.get(newFeature.getType());
            boolean fireUpdate = false;
            if (feature != null) {
                if (feature.getValue() != newFeature.getValue()) {
                    fireUpdate = true;
                    feature.setValue(newFeature.getValue());
                }
            } else {
                fireUpdate = true;
                feature = newFeature;
                this.features.put(feature.getType(), feature);
            }
            if (!fireUpdate) continue;
            this.fireFeatureChanged(feature);
        }
    }

    public Collection<Feature> prepareUpdateFeatures(Collection<Feature> features) {
        LOGGER.debug("Write the new feature values: {}", features);
        LinkedList<Feature> featuresToUpdate = new LinkedList<Feature>();
        for (Feature newFeature : features) {
            Feature feature = (Feature)this.features.get(newFeature.getType());
            boolean fireValueUpdate = false;
            if (feature != null) {
                if (feature.getValue() != newFeature.getValue()) {
                    fireValueUpdate = true;
                }
            } else {
                fireValueUpdate = true;
            }
            if (!fireValueUpdate) continue;
            LOGGER.info("Adding feature to update list: {}", (Object)newFeature);
            featuresToUpdate.add(newFeature);
        }
        return featuresToUpdate;
    }

    private void fireFeatureChanged(Feature feature) {
        LOGGER.debug("The feature has changed: {}", (Object)feature);
        for (FeatureListener listener : this.listeners) {
            listener.featureChanged(feature);
        }
    }
}

