/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.mvc.main.model.InputPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.InputPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class InputPortPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortPanelController.class);
    private final MainModel mainModel;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private InputPortListPanel inputPortListPanel;
    private final Subject<PortConfigChangeEvent> portConfigChangeEventSubject;

    public InputPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.portConfigChangeEventSubject = PublishSubject.create().toSerialized();
    }

    public InputPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        InputPortTableModel tableModel = new InputPortTableModel();
        tableModel.setPortListener((PortModelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.inputPortListPanel = new InputPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        this.inputPortListPanel.setPortListener((PortListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.inputPortListPanel;
    }

    private void handlePortConfigChanged(NodeInterface node, InputPortTableModel tableModel, InputPort port) {
        this.inputPortListPanel.portTableLayoutChanged(node);
        tableModel.notifyPortConfigChanged(port);
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            Long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(uniqueId);
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.inputPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.inputPortListPanel.refreshView());
        }
    }
}

