/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.bidib.api.json.types.NodeInfo;
import org.bidib.jbidibc.core.schema.bidibbase.DefaultLabelsActionType;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.event.DefaultLabelsWorkListItemEvent;
import org.bidib.wizard.api.event.WorkListItemEvent;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.AccessorySaveState;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroSaveState;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.listener.NodeErrorListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.NodeSelectionListener;
import org.bidib.wizard.api.notification.NodeUpdate;
import org.bidib.wizard.api.service.console.ConsoleColor;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.DefaultWizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.node.Node;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.main.model.StatusModel;
import org.bidib.wizard.mvc.main.model.listener.AccessorySelectionListener;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.Assert;

public class MainModel
implements NodeSelectionProvider,
NodeListProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainModel.class);
    private final List<MacroSelectionListener> macroSelectionListeners = new LinkedList();
    private List<AccessorySelectionListener> accessorySelectionListeners = new LinkedList();
    private final List<NodeListListener> nodeListListeners = new LinkedList();
    private final List<NodeSelectionListener> nodeSelectionListeners = new LinkedList();
    private NodeProvider nodeProvider;
    private Accessory selectedAccessory;
    private Macro selectedMacro;
    private NodeInterface selectedNode;
    private final String connectionId;
    private Object nodeLock = new Object();
    private final StatusModel statusModel;
    private NodeErrorListener nodeErrorListener;
    private AtomicBoolean initialLoadFinished = new AtomicBoolean(false);
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ConsoleService consoleService;
    private final ApplicationEventPublisher applicationEventPublisher;

    public MainModel(StatusModel statusModel, String connectionId, ApplicationEventPublisher applicationEventPublisher) {
        this.statusModel = statusModel;
        this.connectionId = connectionId;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setNodeProvider(NodeProvider nodeProvider) {
        LOGGER.info("Set the node provider: {}", (Object)nodeProvider);
        this.nodeProvider = nodeProvider;
        this.nodeProvider.subscribeNodeListChanges((Observer)new /* Unavailable Anonymous Inner Class!! */);
        this.nodeProvider.subscribeNodePropertyChanges(npu -> {
            LOGGER.debug("The property has changed: {}", npu);
            switch (npu.getProperty()) {
                case "addressMessagesEnabled": {
                    LOGGER.info("Address messsages enabled was changed.");
                    break;
                }
                case "errorState": 
                case "reasonData": {
                    LOGGER.info("The error state was changed.");
                    if (this.nodeErrorListener == null) break;
                    Node.ErrorStatePropertyChange propertyChange = (Node.ErrorStatePropertyChange)npu.getValue(Node.ErrorStatePropertyChange.class);
                    this.nodeErrorListener.nodeErrorChanged(npu.getNode(), propertyChange.getSysError(), propertyChange.getReasonData());
                    break;
                }
                case "node.stall": {
                    LOGGER.info("The stall state was changed.");
                    if (this.nodeErrorListener == null) break;
                    this.nodeErrorListener.nodeStallChanged(npu.getNode(), (Boolean)npu.getValue(Boolean.class));
                    break;
                }
                case "node.softwareVersion": {
                    LOGGER.info("The firmware version of the node has changed: {}, node: {}", (Object)npu.getNode().getNode().getSoftwareVersion(), (Object)ByteUtils.formatHexUniqueId((long)npu.getNode().getUniqueId()));
                    NodeUpdate nodeUpdate = new NodeUpdate(this.connectionId, NodeInfo.NodeAction.NOTIFY, npu.getNode());
                    this.applicationEventPublisher.publishEvent((Object)nodeUpdate);
                    NodeInterface updatedNode = npu.getNode();
                    SwingUtils.executeInEDT(() -> this.checkDefaultLabelsApplied(updatedNode));
                    break;
                }
            }
        }, error -> LOGGER.warn("Subscription on nodeProvider for node property changes signalled an error: {}", error));
    }

    private void handleNodeRemove(NodeUpdate nodeUpdate) {
        NodeInterface currentNode = nodeUpdate.getNode();
        this.fireNodeListRemoved(currentNode);
        if (currentNode != null && currentNode.equals((Object)this.getSelectedNode())) {
            LOGGER.info("The active node in model was removed: {}", (Object)this.getSelectedNode());
            this.setSelectedNode(null, true);
        }
        this.fireNodeListChanged();
    }

    private void handleNodeUpdate(NodeUpdate nodeUpdate) {
        LOGGER.info("Node was updated: {}", (Object)nodeUpdate);
        NodeInterface node = nodeUpdate.getNode();
        if (nodeUpdate.getNodeAction() == NodeInfo.NodeAction.ADD) {
            this.checkDefaultLabelsApplied(node);
        }
        if (nodeUpdate.getNodeAction() == NodeInfo.NodeAction.ADD) {
            this.fireNodeListChanged();
            this.fireNodeListAdded(node);
        }
    }

    private void checkDefaultLabelsApplied(NodeInterface node) {
        Long uniqueId = node.getUniqueId();
        SoftwareVersion softwareVersion = node.getNode().getSoftwareVersion();
        DefaultWizardLabelFactory.DefaultLabelsApplied defaultLabelsApplied = this.wizardLabelWrapper.getDefaultLabelsApplied(uniqueId);
        LOGGER.info("The default labels have been applied for this node: {}, uniqueId: {}, softwareVersion: {}", new Object[]{defaultLabelsApplied, ByteUtils.formatHexUniqueId((Long)uniqueId), softwareVersion});
        try {
            this.reloadLabels(node);
        }
        catch (Exception ex) {
            LOGGER.warn("Load labels from BiDiB failed.", (Throwable)ex);
            SwingUtilities.invokeLater(() -> {
                ConsoleController.ensureConsoleVisible();
                this.consoleService.addConsoleLine(ConsoleColor.red, String.format("Load lables failed for node with uniqueId: %s", ByteUtils.getUniqueIdAsString((Long)uniqueId)));
            });
        }
        NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(uniqueId);
        SwingUtils.executeInEDT(() -> node.setLabel(BidibLabelUtils.getNodeLabel((NodeLabels)nodeLabels)));
        if (softwareVersion != null && defaultLabelsApplied != null && (!DefaultLabelsActionType.APPLIED.equals((Object)defaultLabelsApplied.getDefaultLabelsActionType()) && !DefaultLabelsActionType.IGNORED.equals((Object)defaultLabelsApplied.getDefaultLabelsActionType()) || defaultLabelsApplied.getDefaultLabelsVersion() == null || softwareVersion.isHigherThan(defaultLabelsApplied.getDefaultLabelsVersion()))) {
            LOGGER.info("The default labels have not been applied or the version of applied labels is not available. Current softwareVersion: {}, uniqueId: {}", (Object)softwareVersion, (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
            int relevantPidBits = node.getNode().getRelevantPidBits();
            String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
            Observable defaultLabelsAvailableObservable = Observable.create(emitter -> {
                try {
                    SoftwareVersion availableVersion;
                    SoftwareVersion appliedVersion = defaultLabelsApplied.getDefaultLabelsVersion();
                    DefaultWizardLabelFactory.VersionedDefaultNodeLabelsWrapper available = this.wizardLabelWrapper.isDefaultLabelsAvailable(lang, uniqueId, softwareVersion, relevantPidBits);
                    LOGGER.info("Default labels available: {}, appliedVersion: {}, uniqueId: {}", new Object[]{available, appliedVersion, ByteUtils.formatHexUniqueId((Long)uniqueId)});
                    SoftwareVersion softwareVersion2 = availableVersion = available != null ? available.getDefaultLabelsVersion() : null;
                    if (appliedVersion == null && availableVersion != null || appliedVersion != null && appliedVersion.isLowerThan(availableVersion)) {
                        emitter.onNext((Object)Boolean.TRUE);
                    } else {
                        emitter.onNext((Object)Boolean.FALSE);
                    }
                    emitter.onComplete();
                }
                catch (Exception ex) {
                    LOGGER.warn("Check if defaultLabels are available failed.", (Throwable)ex);
                    emitter.onError((Throwable)new RuntimeException("Check if defaultLabels are available failed."));
                }
            });
            defaultLabelsAvailableObservable.subscribe(available -> {
                LOGGER.info("The defaultLabels for this node are available: {}, uniqueId: {}", available, (Object)ByteUtils.formatHexUniqueId((Long)uniqueId));
                if (available.booleanValue()) {
                    this.addWorkListItem(uniqueId, relevantPidBits);
                }
            }, error -> LOGGER.warn("Check for default labels failed.", error));
        }
    }

    private void addWorkListItem(Long uniqueId, int relevantPidBits) {
        DefaultLabelsWorkListItemEvent workListItemEvent = new DefaultLabelsWorkListItemEvent(ByteUtils.getUniqueIdAsString((Long)uniqueId), WorkListItemEvent.Status.pending, this.connectionId, uniqueId, relevantPidBits);
        LOGGER.info("Publish new workListItemEvent: {}", (Object)workListItemEvent);
        this.applicationEventPublisher.publishEvent((Object)workListItemEvent);
    }

    public void setNodeErrorListener(NodeErrorListener nodeErrorListener) {
        this.nodeErrorListener = nodeErrorListener;
    }

    public void clearNodes() {
        LOGGER.info("Clear the nodes and reset the selected node.");
        this.setSelectedNode(null, true);
        this.fireNodeListChanged();
    }

    public Collection<NodeInterface> getNodes() {
        if (this.getNodeProvider() != null) {
            return this.getNodeProvider().getNodes();
        }
        return Collections.emptyList();
    }

    public NodeProvider getNodeProvider() {
        return this.nodeProvider;
    }

    public void addNodeListListener(NodeListListener listener) {
        LOGGER.info("Add the NodeListListener: {}", (Object)listener);
        this.nodeListListeners.add(listener);
    }

    public void removeNodeListListener(NodeListListener listener) {
        LOGGER.info("Remove the NodeListListener: {}", (Object)listener);
        boolean removed = this.nodeListListeners.remove(listener);
        Assert.isTrue((boolean)removed, (String)("Remove NodeListListener failed: " + String.valueOf(listener)));
    }

    public void addNodeSelectionListener(NodeSelectionListener l) {
        this.nodeSelectionListeners.add(l);
    }

    public void removeNodeSelectionListener(NodeSelectionListener l) {
        this.nodeSelectionListeners.remove(l);
    }

    public void addMacroSelectionListener(MacroSelectionListener l) {
        this.macroSelectionListeners.add(l);
    }

    public void removeMacroSelectionListener(MacroSelectionListener l) {
        this.macroSelectionListeners.remove(l);
    }

    public void addAccessorySelectionListener(AccessorySelectionListener l) {
        this.accessorySelectionListeners.add(l);
    }

    public void removeAccessorySelectionListener(AccessorySelectionListener l) {
        this.accessorySelectionListeners.remove(l);
    }

    private void fireMacroSelectionChanged() {
        SwingUtils.executeInEDT(() -> {
            for (MacroSelectionListener l : this.macroSelectionListeners) {
                l.macroChanged();
            }
        });
    }

    private void fireAccessorySelectionChanged() {
        SwingUtils.executeInEDT(() -> {
            for (AccessorySelectionListener l : this.accessorySelectionListeners) {
                l.accessoryChanged();
            }
        });
    }

    private void fireSelectedNodeWillChange(NodeInterface node) {
        LinkedList listeners = new LinkedList(Collections.unmodifiableCollection(this.nodeListListeners));
        for (NodeListListener l : listeners) {
            l.nodeWillChange(node);
        }
    }

    private void fireSelectedNodeChanged(NodeInterface node) {
        LinkedList listeners = new LinkedList(Collections.unmodifiableCollection(this.nodeListListeners));
        for (NodeListListener l : listeners) {
            l.nodeChanged(node);
        }
        Collection<NodeSelectionListener> nodeSelectionListeners = Collections.unmodifiableCollection(this.nodeSelectionListeners);
        for (NodeSelectionListener l : nodeSelectionListeners) {
            l.selectedNodeChanged(this.selectedNode);
        }
    }

    private void fireNodeListChanged() {
        LOGGER.debug("Notify the listeners that the node list has changed.");
        LinkedList listeners = new LinkedList(Collections.unmodifiableCollection(this.nodeListListeners));
        for (NodeListListener l : listeners) {
            l.listChanged();
        }
    }

    private void fireNodeListAdded(NodeInterface node) {
        LOGGER.debug("Notify the listeners that the node list has added a node.");
        LinkedList listeners = new LinkedList(Collections.unmodifiableCollection(this.nodeListListeners));
        for (NodeListListener l : listeners) {
            l.listNodeAdded(node);
        }
    }

    private void fireNodeListRemoved(NodeInterface node) {
        LOGGER.debug("Notify the listeners that the node list has removed a node.");
        LinkedList listeners = new LinkedList(Collections.unmodifiableCollection(this.nodeListListeners));
        for (NodeListListener l : listeners) {
            l.listNodeRemoved(node);
        }
    }

    private void fireNodeStateChanged(NodeInterface node) {
        LinkedList listeners = new LinkedList(Collections.unmodifiableCollection(this.nodeListListeners));
        for (NodeListListener l : listeners) {
            l.nodeStateChanged(node);
        }
    }

    public List<Flag> getFlags() {
        NodeInterface node = this.getSelectedNode();
        if (node != null) {
            return node.getFlags();
        }
        LOGGER.warn("No node selected to get the flags from.");
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeInterface getSelectedNode() {
        Object object = this.nodeLock;
        synchronized (object) {
            return this.selectedNode;
        }
    }

    public StatusModel getStatusModel() {
        return this.statusModel;
    }

    public Macro getSelectedMacro() {
        return this.selectedMacro;
    }

    public void setSelectedMacro(Macro macro) {
        if (this.selectedMacro != null && MacroSaveState.PENDING_CHANGES.equals((Object)this.selectedMacro.getMacroSaveState())) {
            LOGGER.warn("The current macro has pending changes.");
        }
        this.selectedMacro = macro;
        this.fireMacroSelectionChanged();
    }

    public List<Macro> getMacros() {
        NodeInterface node = this.getSelectedNode();
        if (node != null) {
            List macros = node.getMacros();
            return macros;
        }
        LOGGER.warn("No node selected to get the macros from.");
        return Collections.emptyList();
    }

    public void replaceMacro(Macro macro) {
        LOGGER.info("Replace the macro: {}", (Object)macro);
        NodeInterface node = this.getSelectedNode();
        if (node != null) {
            Macro replacedMacro = node.replaceMacro(macro, false);
            this.setSelectedMacro(replacedMacro);
            return;
        }
        throw new RuntimeException("Replace macro failed because no node is selected.");
    }

    public Accessory getSelectedAccessory() {
        return this.selectedAccessory;
    }

    public void setSelectedAccessory(Accessory accessory) {
        if (this.selectedAccessory != null && AccessorySaveState.PERMANENTLY_STORED_ON_NODE != this.selectedAccessory.getAccessorySaveState()) {
            LOGGER.warn("The current accessory has pending changes.");
        }
        this.selectedAccessory = accessory;
        this.fireAccessorySelectionChanged();
    }

    public List<Accessory> getAccessories() {
        NodeInterface node = this.getSelectedNode();
        if (node != null) {
            List accessories = node.getAccessories();
            return accessories;
        }
        LOGGER.warn("No node selected to get the accessories from.");
        return Collections.emptyList();
    }

    public void replaceAccessory(Accessory accessory) {
        NodeInterface node = this.getSelectedNode();
        if (node != null) {
            Accessory replacedAccessory = node.replaceAccessory(accessory, false);
            this.setSelectedAccessory(replacedAccessory);
            return;
        }
        throw new RuntimeException("Replace accessory failed because no node is selected.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedNode(NodeInterface node, boolean forceChange) {
        LOGGER.info("Set the selected node in the main model: {}", (Object)node);
        Object object = this.nodeLock;
        synchronized (object) {
            if (node != null && node.equals((Object)this.selectedNode) || node == null && this.selectedNode == null) {
                LOGGER.info("The selected node has not changed.");
                return;
            }
            if (!forceChange) {
                this.fireSelectedNodeWillChange(node);
            }
            this.selectedNode = node;
            this.clearCachedNodeValues();
        }
        SwingUtils.executeInEDT(() -> this.fireSelectedNodeChanged(node));
    }

    private void clearCachedNodeValues() {
        LOGGER.info("Clear the cached node values.");
        this.setSelectedMacro(null);
        this.setSelectedAccessory(null);
    }

    private void reloadLabels(NodeInterface node) {
        LOGGER.info("Load labels for node: {}", (Object)node);
        if (node == null) {
            LOGGER.info("No node selected to load the labels.");
            return;
        }
        this.wizardLabelWrapper.loadLabels(Long.valueOf(node.getUniqueId()));
        LOGGER.info("Finished load labels for node: {}", (Object)node);
    }

    public void setNodeHasError(NodeInterface node, boolean nodeHasError) {
        this.setNodeHasError(node, nodeHasError, null);
    }

    public void setNodeHasError(NodeInterface node, boolean nodeHasError, String reason) {
        LOGGER.info("setErrorState, node: {}, nodeHasError: {}", (Object)node, (Object)nodeHasError);
        node.setNodeHasError(nodeHasError);
        if (reason != null) {
            node.setReasonData(reason);
        }
        this.fireNodeStateChanged(node);
    }

    public void signalInitialLoadFinished() {
        LOGGER.info("The initial load has finished.");
        this.initialLoadFinished.set(true);
    }

    public void signalResetInitialLoadFinished() {
        LOGGER.info("The initial load is reset.");
        this.initialLoadFinished.set(false);
    }

    public boolean isInitialLoadFinished() {
        return this.initialLoadFinished.get();
    }
}

