/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.menu;

import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.view.menu.listener.NodeListMenuListener;
import org.bidib.wizard.common.labels.DefaultWizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.menu.NodeListMenu;
import org.bidib.wizard.mvc.pt.controller.PtProgrammerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeListMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeListMenu.class);
    private static final Collection<NodeListMenuListener> menuListeners = new LinkedList();
    private final MainModel model;
    private final JMenuItem displayNodeDetails = new JMenuItem(Resources.getString(this.getClass(), (String)"nodeDetails"));
    private final JMenuItem clearError = new JMenuItem(Resources.getString(this.getClass(), (String)"clearError") + " ...");
    private final JCheckBoxMenuItem identify = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"identify"));
    private final JMenuItem firmwareUpdate = new JMenuItem(Resources.getString(this.getClass(), (String)"firmwareUpdate") + " ...");
    private final JMenuItem features = new JMenuItem(Resources.getString(this.getClass(), (String)"features") + " ...");
    private final JMenuItem reset = new JMenuItem(Resources.getString(this.getClass(), (String)"reset") + " ...");
    private final JMenuItem reloadNode = new JMenuItem(Resources.getString(this.getClass(), (String)"reloadNode") + " ...");
    private final JMenuItem loco = new JMenuItem(Resources.getString(this.getClass(), (String)"loco") + " ...");
    private JSeparator locoListSeparator;
    private JSeparator dmxModelerSeparator;
    private final JMenuItem locoList = new JMenuItem(Resources.getString(this.getClass(), (String)"locoList") + " ...");
    private final JMenuItem dccAccessory = new JMenuItem(Resources.getString(this.getClass(), (String)"dccAccessory") + " ...");
    private final JMenuItem locoCv = new JMenuItem(Resources.getString(this.getClass(), (String)"locoCv") + " ...");
    private final JMenuItem locoCvPt = new JMenuItem(Resources.getString(this.getClass(), (String)"locoCvPt") + " ...");
    private final JMenuItem ping = new JMenuItem(Resources.getString(this.getClass(), (String)"ping"));
    private final JMenuItem enable = new JMenuItem(Resources.getString(this.getClass(), (String)"enable"));
    private final JMenuItem disable = new JMenuItem(Resources.getString(this.getClass(), (String)"disable"));
    private final JMenuItem uniqueId = new JMenuItem(Resources.getString(this.getClass(), (String)"uniqueId"));
    private final JCheckBoxMenuItem detachAttachNode = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"detachAttachNode"));
    private final JMenuItem dmxModeler = new JMenuItem(Resources.getString(this.getClass(), (String)"dmxModeler") + " ...");
    private final JCheckBoxMenuItem addressMessagesEnabled = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"addressMessages"));
    private final JCheckBoxMenuItem feedbackMessagesEnabled = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"feedbackMessages"));
    private final JCheckBoxMenuItem keyMessagesEnabled = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"keyMessages"));
    private final JCheckBoxMenuItem externalStartEnabled = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"externalStart"));
    private final JCheckBoxMenuItem dccStartEnabled = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"dccStart"));
    private final JMenuItem dccAdvAvailable = new JMenuItem(Resources.getString(this.getClass(), (String)"dccAdvAvailable") + " ...");
    private final JCheckBoxMenuItem feedbackMirrorDisabled = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"feedbackMirrorDisabled"));
    private final JMenuItem importNode = new JMenuItem(Resources.getString(this.getClass(), (String)"import") + " ...");
    private final JMenuItem exportNode = new JMenuItem(Resources.getString(this.getClass(), (String)"export") + " ...");
    private final JMenuItem generateNodeDocumentation = new JMenuItem(Resources.getString(this.getClass(), (String)"documentation") + " ...");
    private final JMenuItem generateNodeDefaultLabels = new JMenuItem(Resources.getString(this.getClass(), (String)"defaultLabels") + " ...");
    private final JMenuItem applyNodeDefaultLabels = new JMenuItem(Resources.getString(this.getClass(), (String)"applyDefaultLabels") + " ...");
    private final JMenuItem deleteNodeLabels = new JMenuItem(Resources.getString(this.getClass(), (String)"deleteNodeLabels") + " ...");
    private final JMenuItem bulkSwitchNode = new JMenuItem(Resources.getString(this.getClass(), (String)"bulkSwitch"));
    private final JMenuItem saveItem = new JMenuItem(Resources.getString(this.getClass(), (String)"save"));
    private JSeparator bulkSwitchSeparator;
    private JSeparator keyMessagesExtMacroStartSeparator;
    private final SettingsService settingsService;
    private final WizardLabelWrapper wizardLabelWrapper;

    public NodeListMenu(MainModel model, SettingsService settingsService, WizardLabelWrapper wizardLabelWrapper) {
        this.model = model;
        this.settingsService = settingsService;
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.exportNode.setToolTipText(Resources.getString(this.getClass(), (String)"export.tooltip"));
        this.clearError.setToolTipText(Resources.getString(this.getClass(), (String)"clearError.tooltip"));
        this.enable.setToolTipText(Resources.getString(this.getClass(), (String)"enable.tooltip"));
        this.disable.setToolTipText(Resources.getString(this.getClass(), (String)"disable.tooltip"));
        this.saveItem.setToolTipText(Resources.getString(this.getClass(), (String)"save.tooltip"));
    }

    private void addMenuItem(Object menu, JMenuItem menuItem) {
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(menuItem);
        } else if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(menuItem);
        }
    }

    private void addNodeListMenu(Object menu) {
        this.displayNodeDetails.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.displayNodeDetails);
        JMenuItem editLabel = new JMenuItem(Resources.getString(this.getClass(), (String)"editLabel") + " ...");
        editLabel.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, editLabel);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        this.saveItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.saveItem);
        this.clearError.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.clearError);
        this.identify.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, (JMenuItem)this.identify);
        JMenuItem details = new JMenuItem(Resources.getString(this.getClass(), (String)"details") + " ...");
        details.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, details);
        this.firmwareUpdate.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.firmwareUpdate);
        this.features.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.features);
        this.reset.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.reset);
        this.reloadNode.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.reloadNode);
        this.loco.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.loco);
        this.dccAccessory.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.dccAccessory);
        this.locoCv.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.locoCv);
        this.locoCvPt.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.locoCvPt);
        this.ping.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.ping);
        this.enable.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.enable);
        this.disable.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.disable);
        this.uniqueId.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.uniqueId);
        boolean isPowerUser = this.settingsService.getWizardSettings().isPowerUser();
        this.uniqueId.setVisible(isPowerUser);
        this.detachAttachNode.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, (JMenuItem)this.detachAttachNode);
        this.detachAttachNode.setVisible(isPowerUser);
        boolean isLocoListEnabled = false;
        this.locoListSeparator = this.addSeparator(menu);
        this.locoListSeparator.setVisible(isLocoListEnabled);
        this.locoList.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.locoList);
        this.locoList.setVisible(isLocoListEnabled);
        this.dmxModelerSeparator = this.addSeparator(menu);
        this.dmxModelerSeparator.setVisible(false);
        this.dmxModeler.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.dmxModeler);
        this.dmxModeler.setEnabled(false);
        this.dmxModeler.setVisible(false);
        this.addSeparator(menu);
        this.addressMessagesEnabled.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, (JMenuItem)this.addressMessagesEnabled);
        this.feedbackMessagesEnabled.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, (JMenuItem)this.feedbackMessagesEnabled);
        this.feedbackMirrorDisabled.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, (JMenuItem)this.feedbackMirrorDisabled);
        this.feedbackMirrorDisabled.setVisible(isPowerUser);
        this.keyMessagesEnabled.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, (JMenuItem)this.keyMessagesEnabled);
        this.dccStartEnabled.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, (JMenuItem)this.dccStartEnabled);
        this.externalStartEnabled.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, (JMenuItem)this.externalStartEnabled);
        this.dccAdvAvailable.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.dccAdvAvailable);
        this.dccAdvAvailable.setEnabled(false);
        this.dccAdvAvailable.setVisible(false);
        this.keyMessagesExtMacroStartSeparator = this.addSeparator(menu);
        this.importNode.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.importNode);
        this.exportNode.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.exportNode);
        this.generateNodeDocumentation.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.generateNodeDocumentation);
        this.applyNodeDefaultLabels.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.applyNodeDefaultLabels);
        this.generateNodeDefaultLabels.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.generateNodeDefaultLabels);
        this.deleteNodeLabels.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteNodeLabels.setToolTipText(Resources.getString(this.getClass(), (String)"deleteNodeLabels.tooltip"));
        this.addMenuItem(menu, this.deleteNodeLabels);
        this.bulkSwitchSeparator = this.addSeparator(menu);
        this.bulkSwitchNode.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMenuItem(menu, this.bulkSwitchNode);
    }

    public void addMenuListener(NodeListMenuListener l) {
        menuListeners.add(l);
    }

    private JSeparator addSeparator(Object menu) {
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(separator);
        } else if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(separator);
        }
        return separator;
    }

    private void fireAddressMessagesEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.addressMessagesEnabled(isSelected);
        }
    }

    private void fireDccStartEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.dccStartEnabled(isSelected);
        }
    }

    private void fireDetails() {
        for (NodeListMenuListener l : menuListeners) {
            l.showDetails();
        }
    }

    private void fireEditLabel() {
        for (NodeListMenuListener l : menuListeners) {
            l.editLabel(null);
        }
    }

    private void fireSave() {
        for (NodeListMenuListener l : menuListeners) {
            l.savePendingChanges();
        }
    }

    private void fireClearError() {
        for (NodeListMenuListener l : menuListeners) {
            l.clearErrors();
        }
    }

    private void fireExport() {
        for (NodeListMenuListener l : menuListeners) {
            l.exportNode();
        }
    }

    private void fireExternalStartEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.externalStartEnabled(isSelected);
        }
    }

    private void fireFeedbackMessagesEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.feedbackMessagesEnabled(isSelected);
        }
    }

    private void fireFeedbackMirrorDisabled(boolean disable) {
        for (NodeListMenuListener l : menuListeners) {
            l.feedbackMirrorDisabled(disable);
        }
    }

    private void fireFirmwareUpdate() {
        for (NodeListMenuListener l : menuListeners) {
            l.firmwareUpdate();
        }
    }

    private void fireIdentify(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.identify(isSelected);
        }
    }

    private void fireDisplayNodeDetails() {
        for (NodeListMenuListener l : menuListeners) {
            l.displayNodeDetails();
        }
    }

    private void firedDccAdvView() {
        for (NodeListMenuListener l : menuListeners) {
            l.dccAdvView();
        }
    }

    private void fireImport() {
        for (NodeListMenuListener l : menuListeners) {
            l.importNode();
        }
    }

    private void fireKeyMessagesEnabled(boolean isSelected) {
        for (NodeListMenuListener l : menuListeners) {
            l.keyMessagesEnabled(isSelected);
        }
    }

    private void fireFeatures() {
        for (NodeListMenuListener l : menuListeners) {
            l.features();
        }
    }

    private void fireReset() {
        for (NodeListMenuListener l : menuListeners) {
            l.reset();
        }
    }

    private void fireReloadNode() {
        for (NodeListMenuListener l : menuListeners) {
            l.reloadNode();
        }
    }

    private void firePing() {
        for (NodeListMenuListener l : menuListeners) {
            l.ping();
        }
    }

    private void fireEnable() {
        for (NodeListMenuListener l : menuListeners) {
            l.enable();
        }
    }

    private void fireDisable() {
        for (NodeListMenuListener l : menuListeners) {
            l.disable();
        }
    }

    private void fireReadUniqueId() {
        for (NodeListMenuListener l : menuListeners) {
            l.readUniqueId();
        }
    }

    private void fireDetachAttachNode() {
        for (NodeListMenuListener l : menuListeners) {
            l.detachAttachNode();
        }
    }

    private void fireDmxModeler() {
        for (NodeListMenuListener l : menuListeners) {
            l.dmxModeler();
        }
    }

    private void fireLoco() {
        for (NodeListMenuListener l : menuListeners) {
            l.loco();
        }
    }

    private void fireLocoList() {
        for (NodeListMenuListener l : menuListeners) {
            l.locoList();
        }
    }

    private void fireDccAccessory() {
        for (NodeListMenuListener l : menuListeners) {
            l.dccAccessory();
        }
    }

    private void fireLocoCv() {
        for (NodeListMenuListener l : menuListeners) {
            l.locoCv();
        }
    }

    private void fireLocoCvPt() {
        for (NodeListMenuListener l : menuListeners) {
            l.locoCvPt();
        }
    }

    private void fireBulkSwitch() {
        for (NodeListMenuListener l : menuListeners) {
            l.bulkSwitchNode();
        }
    }

    private void fireGenerateDocumentation() {
        for (NodeListMenuListener l : menuListeners) {
            l.generateDocumentation();
        }
    }

    private void fireGenerateDefaultLabels() {
        for (NodeListMenuListener l : menuListeners) {
            l.generateDefaultLabels();
        }
    }

    private void fireApplyDefaultLabels() {
        for (NodeListMenuListener l : menuListeners) {
            l.applyDefaultLabels();
        }
    }

    private void fireDeleteNodeLabels() {
        for (NodeListMenuListener l : menuListeners) {
            l.deleteNodeLabels();
        }
    }

    public JMenu getJMenu() {
        JMenu menu = new JMenu();
        this.addNodeListMenu((Object)menu);
        return menu;
    }

    public JPopupMenu getPopupMenu() {
        36 popupMenu = new /* Unavailable Anonymous Inner Class!! */;
        this.addNodeListMenu((Object)popupMenu);
        return popupMenu;
    }

    public void updateMenuItems(NodeInterface node) {
        boolean isCommandStation;
        boolean nodeIsSelected = node.equals((Object)this.model.getSelectedNode());
        this.setAddressMessagesEnabled(node.isAddressMessagesEnabled());
        this.setDccStartEnabled(node.isDccStartEnabled());
        this.setExternalStartEnabled(node.isExternalStartEnabled());
        this.setFeedbackMessagesEnabled(node.isFeedbackMessagesEnabled());
        this.setFeedbackMirrorDisabled(node.isFeedbackMirrorDisabled());
        boolean isPowerUser = this.settingsService.getWizardSettings().isPowerUser();
        this.feedbackMirrorDisabled.setVisible(node.hasFeedbackPorts() && isPowerUser);
        this.uniqueId.setVisible(isPowerUser);
        if (this.keyMessagesEnabled.isVisible() || this.dccStartEnabled.isVisible() || this.externalStartEnabled.isVisible()) {
            this.keyMessagesExtMacroStartSeparator.setVisible(true);
        } else {
            this.keyMessagesExtMacroStartSeparator.setVisible(false);
        }
        this.setClearErrorEnabled(Boolean.valueOf(node.isNodeHasError()));
        this.setFeaturesEnabled(!node.isBootloaderNode());
        this.setFirmwareUpdateEnabled(node.isUpdatable());
        BoosterControl boosterControl = node.getBoosterNode() != null ? node.getBoosterNode().getBoosterControl() : null;
        boolean bl = isCommandStation = node.getCommandStationNode() != null;
        if (isCommandStation && boosterControl != null && ProductUtils.isReadyBoostProg((long)node.getUniqueId())) {
            switch (37.$SwitchMap$org$bidib$jbidibc$messages$enums$BoosterControl[boosterControl.ordinal()]) {
                case 1: {
                    break;
                }
                default: {
                    LOGGER.info("No local boosterControl available. The command station function is not available.");
                    isCommandStation = false;
                    break;
                }
            }
        } else if (ProductUtils.isRFBasisNode((long)node.getUniqueId()) && node.getBaseNumber() > 1) {
            LOGGER.info("The current RF base is not a master base.");
            isCommandStation = false;
        }
        this.setLocoEnabled(Boolean.valueOf(isCommandStation), Boolean.valueOf(true), node);
        this.setDccAccessoryEnabled(Boolean.valueOf(isCommandStation), Boolean.valueOf(true));
        this.setDccAdvEnabled(Boolean.valueOf(isCommandStation && node.getCommandStationNode().isDccAdvAvailable() != false));
        this.setLocoCvEnabled(Boolean.valueOf(isCommandStation), Boolean.valueOf(isCommandStation && NodeUtils.hasCommandStationProgrammingFunctions((long)node.getUniqueId())), Boolean.valueOf(true));
        this.setIdentifyStateSelected(node.getIdentifyState());
        this.setBulkSwitchEnabled(Boolean.valueOf(NodeUtils.hasSwitchFunctions((long)node.getUniqueId())));
        boolean hasData = this.hasExchangeableData(node);
        this.setImportEnabled(Boolean.valueOf(hasData));
        this.setExportEnabled(Boolean.valueOf(hasData));
        this.generateNodeDefaultLabels.setEnabled(nodeIsSelected);
        if (nodeIsSelected) {
            String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
            DefaultWizardLabelFactory.VersionedDefaultNodeLabelsWrapper available = this.wizardLabelWrapper.isDefaultLabelsAvailable(lang, Long.valueOf(node.getUniqueId()), node.getNode().getSoftwareVersion(), node.getNode().getRelevantPidBits());
            this.applyNodeDefaultLabels.setEnabled(nodeIsSelected && available != null);
        } else {
            this.applyNodeDefaultLabels.setEnabled(false);
        }
        boolean isOneDMX = ProductUtils.isReadyDMXRoomlight((long)node.getUniqueId()) || ProductUtils.isOneDMXRoomlight((long)node.getUniqueId());
        this.setDmxModelerEnabled(Boolean.valueOf(NodeUtils.hasAccessoryFunctions((long)node.getUniqueId()) && isOneDMX), Boolean.valueOf(nodeIsSelected));
        this.setLocalLogoffEnabled(Boolean.valueOf(NodeUtils.isAddressEqual((byte[])node.getNode().getAddr(), (byte[])NodeUtils.ROOT_ADDRESS)), Boolean.valueOf(nodeIsSelected));
    }

    public void setClearErrorEnabled(Boolean isClearErrorEnabled) {
        this.clearError.setVisible(isClearErrorEnabled != null && isClearErrorEnabled != false);
        this.clearError.setEnabled(isClearErrorEnabled != null && isClearErrorEnabled != false);
    }

    private boolean hasExchangeableData(NodeInterface node) {
        if (node != null && node.equals((Object)this.model.getSelectedNode())) {
            boolean hasVendorCV = node.getVendorCV() != null;
            boolean hasFeatures = !node.isBootloaderNode();
            return hasVendorCV || hasFeatures || node.getAccessories().size() > 0 || node.getMacros().size() > 0 || node.getFeedbackPorts().size() > 0 || NodeUtils.hasSwitchFunctions((long)node.getUniqueId());
        }
        return false;
    }

    public void setAddressMessagesEnabled(Boolean isAddressMessagesEnabled) {
        this.addressMessagesEnabled.setVisible(isAddressMessagesEnabled != null);
        this.addressMessagesEnabled.setSelected(isAddressMessagesEnabled != null && isAddressMessagesEnabled != false);
    }

    public void setDccStartEnabled(Boolean isDccStartEnabled) {
        this.dccStartEnabled.setVisible(isDccStartEnabled != null);
        this.dccStartEnabled.setSelected(isDccStartEnabled != null && isDccStartEnabled != false);
    }

    public void setExportEnabled(Boolean exportEnabled) {
        this.exportNode.setEnabled(exportEnabled != null && exportEnabled != false);
        this.generateNodeDocumentation.setEnabled(exportEnabled != null && exportEnabled != false);
    }

    public void setExternalStartEnabled(Boolean isExternalStartEnabled) {
        this.externalStartEnabled.setVisible(isExternalStartEnabled != null);
        this.externalStartEnabled.setSelected(isExternalStartEnabled != null && isExternalStartEnabled != false);
    }

    public void setDccAdvEnabled(Boolean isDccAdvAvailable) {
        boolean isEnabled = isDccAdvAvailable != null && isDccAdvAvailable != false;
        this.dccAdvAvailable.setEnabled(isEnabled);
        this.dccAdvAvailable.setVisible(isEnabled);
    }

    public void setFeedbackMessagesEnabled(Boolean isFeedbackMessagesEnabled) {
        this.feedbackMessagesEnabled.setVisible(isFeedbackMessagesEnabled != null);
        this.feedbackMessagesEnabled.setSelected(isFeedbackMessagesEnabled != null && isFeedbackMessagesEnabled != false);
    }

    public void setFeedbackMirrorDisabled(Boolean isFeedbackMirrorDisabled) {
        this.feedbackMirrorDisabled.setVisible(isFeedbackMirrorDisabled != null);
        this.feedbackMirrorDisabled.setSelected(isFeedbackMirrorDisabled != null && isFeedbackMirrorDisabled != false);
    }

    public void setFirmwareUpdateEnabled(boolean isFirmwareUpdateEnabled) {
        this.firmwareUpdate.setEnabled(isFirmwareUpdateEnabled);
    }

    public void setFeaturesEnabled(boolean isFeaturesEnabled) {
        this.features.setEnabled(isFeaturesEnabled);
    }

    public void setIdentifyStateSelected(IdentifyState identifyState) {
        this.identify.setSelected(identifyState == IdentifyState.ON);
    }

    public void setDetachedStateSelected(DetachedState detachedState) {
        this.detachAttachNode.setSelected(detachedState == DetachedState.DETACHED);
    }

    public void setImportEnabled(Boolean importEnabled) {
        this.importNode.setEnabled(importEnabled != null && importEnabled != false);
    }

    public void setKeyMessagesEnabled(Boolean isKeyMessagesEnabled) {
        this.keyMessagesEnabled.setVisible(isKeyMessagesEnabled != null);
        this.keyMessagesEnabled.setSelected(isKeyMessagesEnabled != null && isKeyMessagesEnabled != false);
    }

    private void setLocoEnabled(Boolean isLocoEnabled, Boolean nodeIsSelected, NodeInterface node) {
        long uniqueId = node.getUniqueId();
        this.loco.setEnabled(isLocoEnabled != null && isLocoEnabled != false && nodeIsSelected != null && nodeIsSelected != false);
        this.loco.setVisible(isLocoEnabled != null && isLocoEnabled != false);
        if (this.loco.isVisible()) {
            if (ProductUtils.isRFBasisNode((long)uniqueId) || ProductUtils.isSpeedometer((long)uniqueId)) {
                this.loco.setText(Resources.getString(this.getClass(), (String)"car") + " ...");
            } else {
                this.loco.setText(Resources.getString(this.getClass(), (String)"loco") + " ...");
            }
        }
        boolean isLocoListEnabled = false;
        Boolean locoListFeatureAvailable = Feature.getBitFeatureValue((Collection)node.getNode().getFeatures(), (int)FeatureEnum.FEATURE_GEN_EXT_AVAILABLE.getNumber(), (int)7);
        if (locoListFeatureAvailable == Boolean.TRUE || ProductUtils.isIF2((long)uniqueId) || ProductUtils.isIFnet((long)uniqueId)) {
            isLocoListEnabled = true;
        }
        this.locoList.setEnabled(isLocoEnabled != null && isLocoEnabled != false && nodeIsSelected != null && nodeIsSelected != false && isLocoListEnabled);
        this.locoList.setVisible(isLocoEnabled != null && isLocoEnabled != false && isLocoListEnabled);
        this.locoListSeparator.setVisible(isLocoEnabled != null && isLocoEnabled != false && isLocoListEnabled);
    }

    private void setDccAccessoryEnabled(Boolean isDccAccessoryEnabled, Boolean nodeIsSelected) {
        this.dccAccessory.setEnabled(isDccAccessoryEnabled != null && isDccAccessoryEnabled != false && nodeIsSelected != null && nodeIsSelected != false);
        this.dccAccessory.setVisible(isDccAccessoryEnabled != null && isDccAccessoryEnabled != false);
    }

    private void setLocoCvEnabled(Boolean isDccGenerator, Boolean isLocoCvEnabled, Boolean nodeIsSelected) {
        boolean isLocoCvOpened = false;
        if (PtProgrammerController.isOpened()) {
            LOGGER.info("The dialog is already opened.");
            isLocoCvOpened = true;
        }
        this.locoCv.setEnabled(isDccGenerator != null && isDccGenerator != false && nodeIsSelected != null && nodeIsSelected != false);
        this.locoCvPt.setEnabled(isLocoCvEnabled != null && isLocoCvEnabled != false && !isLocoCvOpened && nodeIsSelected != null && nodeIsSelected != false);
        this.locoCv.setVisible(isDccGenerator != null && isDccGenerator != false);
        this.locoCvPt.setVisible(isLocoCvEnabled != null && isLocoCvEnabled != false);
    }

    private void setDmxModelerEnabled(Boolean isDmxModelerEnabled, Boolean nodeIsSelected) {
        this.dmxModelerSeparator.setVisible(isDmxModelerEnabled != null && isDmxModelerEnabled != false);
        this.dmxModeler.setEnabled(isDmxModelerEnabled != null && isDmxModelerEnabled != false && nodeIsSelected != null && nodeIsSelected != false);
        this.dmxModeler.setVisible(isDmxModelerEnabled != null && isDmxModelerEnabled != false);
    }

    private void setLocalLogoffEnabled(Boolean isRootNode, Boolean nodeIsSelected) {
        this.detachAttachNode.setEnabled(isRootNode != null && isRootNode != false && nodeIsSelected != null && nodeIsSelected != false);
        this.detachAttachNode.setVisible(isRootNode != null && isRootNode != false);
    }

    private void setBulkSwitchEnabled(Boolean isBulkSwitchEnabled) {
        boolean isPowerUser = this.settingsService.getWizardSettings().isPowerUser();
        this.bulkSwitchNode.setEnabled(isBulkSwitchEnabled);
        this.bulkSwitchNode.setVisible(isPowerUser);
        this.bulkSwitchSeparator.setVisible(isPowerUser);
    }
}

