/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import io.reactivex.rxjava3.subjects.Subject;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.IoBehaviourInputEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.table.AbstractPortEditorPanel;
import org.bidib.wizard.client.common.table.listener.PortEditorPanelCallback;
import org.bidib.wizard.client.common.text.HintTextField;
import org.bidib.wizard.client.common.text.WizardBindings;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.validation.DefaultRangeValidationCallback;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.mvc.main.model.InputPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.renderer.IoBehaviourInputCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPortEditorPanel
extends AbstractPortEditorPanel<InputPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortEditorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private ValueModel switchOffTimeConverterModel;
    private ValueModel selectionHolderIoBehaviour;
    private JTextField portName;
    private HintTextField switchOffTimeText;
    private JComboBox<IoBehaviourInputEnum> comboIoBehaviour;

    public InputPortEditorPanel(InputPort port, Consumer<InputPort> saveCallback, Consumer<InputPort> refreshCallback, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super((Port)port, saveCallback, null, refreshCallback, portConfigChangeEventSubject, nodeSelectionProvider);
    }

    protected InputPort clonePort(InputPort port) {
        InputPort clone = (InputPort)InputPort.builder().withInputBehaviour(port.getInputBehaviour()).withSwitchOffTime(port.getSwitchOffTime()).withStatus((BidibStatus)((InputPortStatus)port.getStatus())).withRemappingEnabled(port.isRemappingEnabled()).withKnownPortConfigKeys(port.getKnownPortConfigKeys()).withId(port.getId()).withLabel(port.getLabel()).withEnabled(port.isEnabled()).withIsInactive(port.isInactive()).withPortIdentifier(port.getPortIdentifier()).build();
        return clone;
    }

    protected JPanel doCreateComponent(InputPort port) {
        FormBuilder dialogBuilder;
        boolean debugDialog = false;
        if (debugDialog) {
            AbstractPortEditorPanel.PortEditorPanelDebugContainer panel = new AbstractPortEditorPanel.PortEditorPanelDebugContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            AbstractPortEditorPanel.PortEditorPanelContainer panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.createEditorContent(dialogBuilder, port);
        return this.getPanel();
    }

    private void createEditorContent(FormBuilder dialogBuilder, InputPort port) {
        int row = 1;
        ArrayList<JComponent> order = new ArrayList<JComponent>();
        BufferedValueModel bufferedPortNameModel = this.getPresentationModel().getBufferedModel("label");
        dialogBuilder.add(Resources.getString(InputPortTableModel.class, (String)"label") + ":", new Object[0]).xy(1, row);
        this.portName = WizardComponentFactory.createTextField((ValueModel)bufferedPortNameModel, (boolean)false);
        this.portName.setEnabled(port.isEnabled());
        dialogBuilder.add((Component)this.portName).xyw(3, row, 3);
        order.add(this.portName);
        row += 2;
        boolean isInputPort = ((InputPort)this.getOriginalPort()).getGenericPort() != null ? ((InputPort)this.getOriginalPort()).getGenericPort().getPortType() == LcOutputType.INPUTPORT : true;
        LOGGER.info("==> The current port is an inputPort: {}", (Object)isInputPort);
        if (isInputPort && this.isPortConfigKeySupported((byte)11)) {
            this.switchOffTimeConverterModel = new ConverterValueModel((ValueModel)this.getPresentationModel().getBufferedModel("switchOffTime"), (BindingConverter)new StringToIntegerConverter());
            this.switchOffTimeText = new HintTextField(() -> this.triggerValidation());
            IntegerInputValidationDocument switchOffTimeDocument = new IntegerInputValidationDocument(5, "0123456789");
            switchOffTimeDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, 255, showHint -> this.switchOffTimeText.showHint(showHint.booleanValue())));
            this.switchOffTimeText.setDocument((Document)switchOffTimeDocument);
            this.switchOffTimeText.setColumns(2);
            this.switchOffTimeText.setHorizontalAlignment(4);
            WizardBindings.bind((JTextField)this.switchOffTimeText, (ValueModel)this.switchOffTimeConverterModel, (boolean)true);
            this.switchOffTimeText.setEnabled(port.isEnabled());
            dialogBuilder.add(Resources.getString(InputPortTableModel.class, (String)"switchOffTime"), new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.switchOffTimeText).xy(3, row);
            order.add((JComponent)this.switchOffTimeText);
            ValidationComponentUtils.setMandatory((JComponent)this.switchOffTimeText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.switchOffTimeText, (Object[])new Object[]{"validation.switchOffTime_key"});
            row += 2;
        }
        if (isInputPort && this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_INPUT_CTRL)) {
            this.selectionHolderIoBehaviour = this.getPresentationModel().getBufferedModel("inputBehaviour");
            ArrayListModel ioBehaviourList = new ArrayListModel();
            NodeInterface selectedNode = this.getNodeSelectionProvider().getSelectedNode();
            if (ProductUtils.isReadyServo8((long)selectedNode.getUniqueId())) {
                ioBehaviourList.add((Object)IoBehaviourInputEnum.ACTIVE_HIGH_PULLDOWN);
                ioBehaviourList.add((Object)IoBehaviourInputEnum.ACTIVE_LOW_PULLUP);
            } else {
                for (IoBehaviourInputEnum value : IoBehaviourInputEnum.values()) {
                    ioBehaviourList.add((Object)value);
                }
            }
            SelectionInList ioBehaviourSelection = new SelectionInList((ListModel)ioBehaviourList);
            ComboBoxAdapter comboBoxAdapterIoBehaviour = new ComboBoxAdapter((ListModel)ioBehaviourSelection, this.selectionHolderIoBehaviour);
            this.comboIoBehaviour = new JComboBox();
            this.comboIoBehaviour.setModel(comboBoxAdapterIoBehaviour);
            this.comboIoBehaviour.setRenderer(new IoBehaviourInputCellRenderer());
            this.comboIoBehaviour.setEnabled(port.isEnabled());
            dialogBuilder.add(Resources.getString(InputPortTableModel.class, (String)"ioBehaviour") + ":", new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.comboIoBehaviour).xy(3, row);
            order.add(this.comboIoBehaviour);
            row += 2;
        }
        JPanel buttonPanel = this.getButtonPanel();
        dialogBuilder.add((Component)buttonPanel).xyw(1, row, 5);
        this.addButtons(buttonPanel, order);
        this.createContentPanel(dialogBuilder);
        bufferedPortNameModel.addValueChangeListener(evt -> this.triggerValidation());
        if (this.switchOffTimeConverterModel != null) {
            this.switchOffTimeConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.selectionHolderIoBehaviour != null) {
            this.selectionHolderIoBehaviour.addValueChangeListener(evt -> this.triggerValidation());
        }
        this.enableComponents();
        this.triggerValidation();
        this.getPanel().setFocusCycleRoot(true);
        this.getPanel().setFocusTraversalPolicy(this.createFocusTransversalPolicy(order));
    }

    protected void createContentPanel(FormBuilder dialogBuilder) {
        if (this.getPanel() == null) {
            if (this.getValidationResultModel() != null) {
                LOGGER.info("Create iconfeedback panel.");
                JPanel dialogPanel = dialogBuilder.build();
                IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)dialogPanel);
                AbstractPortEditorPanel.PortEditorPanelContainer panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
                FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)panel);
                feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
                this.setPanel(feedbackBuilder.build());
            } else {
                this.setPanel(dialogBuilder.build());
            }
        } else {
            JPanel contentPanel = this.getPanel();
            LOGGER.info("The content panel is available already: {}", (Object)contentPanel);
            if (contentPanel.getComponentCount() == 1 && contentPanel.getComponent(0) instanceof IconFeedbackPanel) {
                JPanel dialogPanel = dialogBuilder.build();
                IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)dialogPanel);
                contentPanel.removeAll();
                FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel(contentPanel);
                feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
                contentPanel.revalidate();
            } else {
                contentPanel.removeAll();
                dialogBuilder.build();
            }
        }
    }

    public void requestDefaultFocus() {
        this.portName.requestFocusInWindow();
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        LOGGER.info("The port property has been changed, propertyName: {}, new value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
        super.propertyChanged(evt);
        SwingUtils.executeInEDT(() -> this.processPropertyChanged(evt));
    }

    private void processPropertyChanged(PropertyChangeEvent evt) {
        try {
            switch (evt.getPropertyName()) {
                case "status": 
                case "portStatus": {
                    LOGGER.info("The port status has changed: {}", evt.getNewValue());
                    this.updatePortStatusFromOriginalPort();
                    break;
                }
                case "portConfigChanged": {
                    break;
                }
                case "portTypeChanged": {
                    LOGGER.info("The port type has changed: {}", evt.getNewValue());
                    if (((InputPort)this.getOriginalPort()).getPortType() == LcOutputType.INPUTPORT) {
                        LOGGER.info("Current port type is INPUTPORT. Update the port configuration from original port.");
                        this.updatePortConfigurationFromOriginalPort();
                        this.updatePortStatusFromOriginalPort();
                    }
                    this.updateEditorContent();
                    this.enableComponents();
                    break;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Update the status failed.", (Throwable)ex);
        }
    }

    private void updatePortStatusFromOriginalPort() {
        AbstractValueModel selectionHolderPortStatus = this.getPresentationModel().getModel("status");
        InputPortStatus status = (InputPortStatus)((InputPort)this.getOriginalPort()).getStatus();
        LOGGER.info("Current status of original port: {}", (Object)status);
        selectionHolderPortStatus.setValue((Object)status);
    }

    private void updateEditorContent() {
        JPanel contentPanel = this.getPanel();
        if (contentPanel != null) {
            FormBuilder dialogBuilder;
            AbstractPortEditorPanel.PortEditorPanelDebugContainer panel;
            LOGGER.info("Recreate the editor content.");
            boolean debugDialog = false;
            if (debugDialog) {
                panel = new AbstractPortEditorPanel.PortEditorPanelDebugContainer((PortEditorPanelCallback)this);
                dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
            } else {
                panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
                dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
            }
            dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
            InputPort port = (InputPort)this.getPresentationModel().getBean();
            this.createEditorContent(dialogBuilder, port);
        }
    }

    private void updatePortConfigurationFromOriginalPort() {
        Integer switchOffTime = ((InputPort)this.getOriginalPort()).getSwitchOffTime();
        this.getPresentationModel().setValue("switchOffTime", (Object)switchOffTime);
        IoBehaviourInputEnum inputBehaviour = ((InputPort)this.getOriginalPort()).getInputBehaviour();
        this.getPresentationModel().setValue("inputBehaviour", (Object)inputBehaviour);
    }

    protected ValidationResult validate(InputPort port) {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getPresentationModel(), "validation");
        if (this.switchOffTimeConverterModel != null && this.switchOffTimeConverterModel.getValue() == null) {
            support.addError("switchOffTime_key", "not_empty_for_write");
        } else if (this.switchOffTimeText != null && this.switchOffTimeText.isShowHint()) {
            support.add(Severity.INFO, "switchOffTime_key", "validRange;0..255");
        }
        if (this.selectionHolderIoBehaviour != null && this.selectionHolderIoBehaviour.getValue() == null) {
            support.addError("ioBehaviour_key", "not_empty_for_write");
        }
        ValidationResult validationResult = support.getResult();
        return validationResult;
    }

    protected void doEnableComponents(InputPort port) {
        boolean enabled = port.isEnabled();
        this.portName.setEnabled(enabled);
        if (this.comboIoBehaviour != null) {
            this.comboIoBehaviour.setEnabled(enabled && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_INPUT_CTRL));
        }
        if (this.switchOffTimeText != null) {
            this.switchOffTimeText.setEnabled(enabled && port.isPortConfigKeySupported(PortConfigKeys.BIDIB_PCFG_TICKS));
        }
        super.doEnableComponents((Port)port);
    }
}

