/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.controller;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.PtOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.core.model.connection.MessageAdapter;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.pt.controller.listener.PtProgrammerControllerListener;
import org.bidib.wizard.mvc.pt.model.PtProgrammerModel;
import org.bidib.wizard.mvc.pt.view.PtProgrammerView;
import org.bidib.wizard.mvc.pt.view.listener.PtProgrammerViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PtProgrammerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PtProgrammerController.class);
    private final Collection<PtProgrammerControllerListener> listeners = new LinkedList();
    private final JFrame parent;
    private final NodeInterface node;
    private final int x;
    private final int y;
    private final PtProgrammerModel model = new PtProgrammerModel();
    private PtProgrammerView ptProgrammerView;
    @Autowired
    private ConnectionService connectionService;
    private MessageAdapter messageAdapter;
    private static AtomicBoolean singleton = new AtomicBoolean();

    public PtProgrammerController(NodeInterface node, JFrame parent, int x, int y) {
        this.parent = parent;
        this.node = node;
        this.x = x;
        this.y = y;
    }

    public static boolean isOpened() {
        return singleton.get();
    }

    private void setOpened(boolean opened) {
        singleton.set(opened);
    }

    public void addPtProgrammerControllerListener(PtProgrammerControllerListener l) {
        this.listeners.add(l);
    }

    private void fireClose() {
        for (PtProgrammerControllerListener l : this.listeners) {
            l.close();
        }
        this.setOpened(false);
    }

    private void fireSendRequest(PtOperation operation, int cvNumber, int cvValue) {
        LOGGER.info("Send CV request, operation: {}, cvNumber: {}, value: {}", new Object[]{operation, cvNumber, cvValue});
        CommandStationPt opCode = CommandStationPt.valueOf((byte)ByteUtils.getLowByte((int)operation.getType()));
        this.model.clearCvValue();
        LOGGER.info("Prepared opCode: {}", (Object)opCode);
        for (PtProgrammerControllerListener l : this.listeners) {
            l.sendRequest(this.node, opCode, cvNumber, cvValue);
        }
    }

    private void fireSendCommandStationStateRequest(boolean activateProgMode) {
        CommandStationState requestedCommandStationState;
        CommandStationStatus commandStationState = null;
        commandStationState = activateProgMode ? CommandStationStatus.PROG : ((requestedCommandStationState = this.node.getNode().getRequestedCommandStationState()) == null ? CommandStationStatus.GO_IGN_WD : CommandStationStatus.valueOf((CommandStationState)requestedCommandStationState));
        LOGGER.info("Set the new command station state: {}, activateProgMode: {}", (Object)commandStationState, (Object)activateProgMode);
        for (PtProgrammerControllerListener l : this.listeners) {
            l.sendCommandStationStateRequest(this.node, commandStationState);
        }
    }

    private CommandStationStatus fireGetCommandStationStateRequest() {
        LOGGER.info("Get the commandStationState");
        Iterator iterator = this.listeners.iterator();
        if (iterator.hasNext()) {
            PtProgrammerControllerListener l = (PtProgrammerControllerListener)iterator.next();
            CommandStationStatus commandStationState = l.getCurrentCommandStationState(this.node);
            return commandStationState;
        }
        return null;
    }

    public void start(DockingDesktop desktop) {
        this.messageAdapter = new /* Unavailable Anonymous Inner Class!! */;
        this.messageAdapter.setNode(this.node);
        this.messageAdapter.start();
        this.ptProgrammerView = new PtProgrammerView(this.model);
        this.ptProgrammerView.addPtProgrammerViewListener((PtProgrammerViewListener)new /* Unavailable Anonymous Inner Class!! */);
        LOGGER.info("Initialize the view.");
        this.setOpened(true);
        this.ptProgrammerView.showDialog(this.parent, this.x, this.y);
    }

    private void writeCommandStationProgState(CommandStationProgState commandStationProgState, int remainingTime, int cvNumber, int cvValue) {
        this.model.updateCommandStationProgResult(commandStationProgState, remainingTime, cvNumber, cvValue);
    }
}

