/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.stepcontrol.TurnTableType;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlAspect;
import org.bidib.wizard.mvc.stepcontrol.model.StepControlModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepControlModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepControlModel.class);
    public static final String PROPERTYNAME_SELECTED_ASPECT = "selectedAspect";
    public static final String PROPERTYNAME_STEPCONTROL_ASPECTS = "stepControlAspects";
    public static final String PROPERTYNAME_CURRENT_POSITION = "currentPosition";
    public static final String PROPERTYNAME_TOTAL_STEPS = "totalSteps";
    public static final String PROPERTYNAME_MAX_CONFIGURED_ASPECTS = "maxConfiguredAspects";
    public static final String PROPERTYNAME_TURNTABLE_TYPE = "turnTableType";
    public static final String PROPERTYNAME_SPEED = "speed";
    public static final String PROPERTYNAME_ACCEL = "accel";
    public static final String PROPERTYNAME_DECEL = "decel";
    public static final String PROPERTYNAME_PUSH_INTERVAL = "pushInterval";
    public static final String PROPERTYNAME_OPERATIONAL_MODE = "operationalMode";
    public static final String PROPERTYNAME_CURRENT_DEGREES = "currentDegrees";
    public static final String PROPERTYNAME_TARGET_DEGREES = "targetDegrees";
    public static final String PROPERTYNAME_MOTOR_PORT = "motorPort";
    public static final String PROPERTYNAME_SOUND_PORTS = "soundPorts";
    public static final String PROPERTYNAME_SOUND_ACTIVE = "soundActive";
    private ArrayListModel<StepControlAspect> stepControlAspects = new ArrayListModel();
    private StepControlAspect selectedAspect;
    private int maxConfiguredAspects;
    private TurnTableType turnTableType = TurnTableType.unknown;
    private Long currentPosition;
    private Long totalSteps;
    private int speed = 1;
    private int accel = 1;
    private int decel = 1;
    private Integer pushInterval;
    private OperationModeEnum operationalMode = OperationModeEnum.unknown;
    private double currentDegrees;
    private double targetDegrees;
    private MotorPort motorPort;
    private List<SoundPort> soundPorts;
    private boolean soundActive;
    private static final long F_STEP_ACCEL_LIMIT = 19150L;

    public StepControlAspect getSelectedAspect() {
        return this.selectedAspect;
    }

    public void setSelectedAspect(StepControlAspect selectedAspect) {
        StepControlAspect oldValue = this.selectedAspect;
        this.selectedAspect = selectedAspect;
        this.firePropertyChange(PROPERTYNAME_SELECTED_ASPECT, (Object)oldValue, (Object)selectedAspect);
    }

    public ArrayListModel<StepControlAspect> getStepControlAspectsListModel() {
        return this.stepControlAspects;
    }

    public List<StepControlAspect> getStepControlAspects() {
        return this.stepControlAspects;
    }

    public void addStepControlAspect(StepControlAspect stepControlAspect) {
        ArrayList oldValue = new ArrayList();
        oldValue.addAll(this.stepControlAspects);
        this.stepControlAspects.add((Object)stepControlAspect);
        this.firePropertyChange(PROPERTYNAME_STEPCONTROL_ASPECTS, oldValue, (Object)this.stepControlAspects);
    }

    public void removeStepControlAspect(StepControlAspect stepControlAspect) {
        ArrayList oldValue = new ArrayList();
        oldValue.addAll(this.stepControlAspects);
        int index = this.stepControlAspects.indexOf((Object)stepControlAspect);
        this.stepControlAspects.remove((Object)stepControlAspect);
        this.firePropertyChange(PROPERTYNAME_STEPCONTROL_ASPECTS, oldValue, (Object)this.stepControlAspects);
        if (index > -1) {
            this.stepControlAspects.fireContentsChanged(index);
        }
    }

    public void updateStepControlAspect(StepControlAspect originalAspect, StepControlAspect changedAspect) {
        LOGGER.info("Update originalAspect: {}", (Object)originalAspect);
        int index = this.stepControlAspects.indexOf((Object)originalAspect);
        if (index > -1) {
            originalAspect.setPosition(changedAspect.getPosition());
            if (TurnTableType.round == this.turnTableType) {
                originalAspect.setOppositePosition(changedAspect.getOppositePosition());
                originalAspect.setOppositePolarity(changedAspect.getOppositePolarity());
            }
            originalAspect.setPolarity(changedAspect.getPolarity());
            originalAspect.setStatus(StepControlAspect.AspectPersistanceStatus.statusTransient);
            this.stepControlAspects.fireContentsChanged(index);
        } else {
            LOGGER.warn("Original aspect is not in list of stepControlAspects: {}", (Object)originalAspect);
        }
    }

    public void setStepControlAspects(List<StepControlAspect> stepControlAspects) {
        ArrayList oldValue = new ArrayList();
        oldValue.addAll(this.stepControlAspects);
        this.stepControlAspects.clear();
        if (CollectionUtils.isNotEmpty(stepControlAspects)) {
            this.stepControlAspects.addAll(stepControlAspects);
        }
        this.firePropertyChange(PROPERTYNAME_STEPCONTROL_ASPECTS, oldValue, (Object)this.stepControlAspects);
        this.stepControlAspects.fireContentsChanged(0, this.stepControlAspects.getSize() - 1);
    }

    public int getMaxConfiguredAspects() {
        return this.maxConfiguredAspects;
    }

    public void setMaxConfiguredAspects(int maxConfiguredAspects) {
        int oldValue = this.maxConfiguredAspects;
        this.maxConfiguredAspects = maxConfiguredAspects;
        this.firePropertyChange(PROPERTYNAME_MAX_CONFIGURED_ASPECTS, oldValue, this.maxConfiguredAspects);
    }

    public TurnTableType getTurnTableType() {
        return this.turnTableType;
    }

    public void setTurnTableType(TurnTableType turnTableType) {
        LOGGER.info("Set the turnTableType: {}", (Object)turnTableType);
        TurnTableType oldValue = this.turnTableType;
        this.turnTableType = turnTableType;
        this.firePropertyChange(PROPERTYNAME_TURNTABLE_TYPE, (Object)oldValue, (Object)turnTableType);
    }

    public Long getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(Long currentPosition) {
        LOGGER.info("Set the current position: {}", (Object)currentPosition);
        Long oldValue = this.currentPosition;
        this.currentPosition = currentPosition;
        this.firePropertyChange(PROPERTYNAME_CURRENT_POSITION, (Object)oldValue, (Object)currentPosition);
    }

    public Long getTotalSteps() {
        return this.totalSteps;
    }

    public void setTotalSteps(Long totalSteps) {
        LOGGER.info("Set the total steps: {}", (Object)totalSteps);
        Long oldValue = this.totalSteps;
        this.totalSteps = totalSteps;
        this.firePropertyChange(PROPERTYNAME_TOTAL_STEPS, (Object)oldValue, (Object)totalSteps);
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        LOGGER.info("Set speed: {}", (Object)speed);
        int oldValue = this.speed;
        this.speed = speed;
        this.firePropertyChange(PROPERTYNAME_SPEED, oldValue, speed);
    }

    public int getAccel() {
        return this.accel;
    }

    public void setAccel(int accel) throws PropertyVetoException {
        this.validateConfigurationValue(PROPERTYNAME_ACCEL, () -> accel);
        int oldValue = this.accel;
        this.accel = accel;
        this.firePropertyChange(PROPERTYNAME_ACCEL, oldValue, accel);
    }

    public int getDecel() {
        return this.decel;
    }

    public void setDecel(int decel) throws PropertyVetoException {
        this.validateConfigurationValue(PROPERTYNAME_DECEL, () -> decel);
        int oldValue = this.decel;
        this.decel = decel;
        this.firePropertyChange(PROPERTYNAME_DECEL, oldValue, decel);
    }

    public void checkValidConfigurationValues() {
        this.validateConfigurationValue(PROPERTYNAME_DECEL, () -> this.decel);
        this.validateConfigurationValue(PROPERTYNAME_ACCEL, () -> this.accel);
    }

    private void validateConfigurationValue(String valueIdentifier, LongSupplier newValueSupplier) {
        Long totalSteps = this.getTotalSteps();
        if (totalSteps == null) {
            LOGGER.warn("The totalSteps are not available.");
            throw new IllegalArgumentException("The totalSteps are not available.");
        }
        long minDecel = totalSteps;
        if ((minDecel *= newValueSupplier.getAsLong()) < 19150L) {
            LOGGER.warn("The configured '{}' value is too small: {}", (Object)valueIdentifier, (Object)newValueSupplier.getAsLong());
            throw new IllegalArgumentException("The configured '" + valueIdentifier + "' value is too small: " + newValueSupplier.getAsLong());
        }
    }

    public OperationModeEnum getOperationalMode() {
        return this.operationalMode;
    }

    public void setOperationalMode(OperationModeEnum operationalMode) {
        OperationModeEnum oldValue = this.operationalMode;
        this.operationalMode = operationalMode;
        LOGGER.info("setOperationalMode, old: {}, current: {}", (Object)oldValue, (Object)operationalMode);
        this.firePropertyChange(PROPERTYNAME_OPERATIONAL_MODE, (Object)oldValue, (Object)operationalMode);
    }

    public void clearModel() {
        this.setStepControlAspects(null);
        this.setCurrentPosition(Long.valueOf(0L));
        this.setSelectedAspect(null);
        this.setTurnTableType(TurnTableType.unknown);
        this.setSpeed(1);
        try {
            this.setAccel(1);
        }
        catch (PropertyVetoException | IllegalArgumentException ex) {
            LOGGER.warn("Set accel failed", (Throwable)ex);
        }
        try {
            this.setDecel(1);
        }
        catch (PropertyVetoException | IllegalArgumentException ex) {
            LOGGER.warn("Set decel failed", (Throwable)ex);
        }
    }

    public void setTurntableCurrentDegrees(double degrees) {
        double oldValue = this.currentDegrees;
        this.currentDegrees = degrees;
        this.firePropertyChange(PROPERTYNAME_CURRENT_DEGREES, oldValue, this.currentDegrees);
    }

    public double getTurntableCurrentDegrees() {
        return this.currentDegrees;
    }

    public void setTurntableTargetDegrees(double degrees) {
        double oldValue = this.targetDegrees;
        this.targetDegrees = degrees;
        this.firePropertyChange(PROPERTYNAME_TARGET_DEGREES, oldValue, this.targetDegrees);
    }

    public double getTurntableTargetDegrees() {
        return this.targetDegrees;
    }

    public MotorPort getMotorPort() {
        return this.motorPort;
    }

    public void setMotorPort(MotorPort motorPort) {
        MotorPort oldValue = this.motorPort;
        this.motorPort = motorPort;
        this.firePropertyChange(PROPERTYNAME_MOTOR_PORT, (Object)oldValue, (Object)motorPort);
    }

    public List<SoundPort> getSoundPorts() {
        return this.soundPorts;
    }

    public void setSoundPorts(List<SoundPort> soundPorts) {
        List oldValue = this.soundPorts;
        this.soundPorts = soundPorts;
        this.firePropertyChange(PROPERTYNAME_SOUND_PORTS, (Object)oldValue, soundPorts);
    }

    public void setPushInterval(Integer pushInterval) {
        Integer oldValue = this.pushInterval;
        this.pushInterval = pushInterval;
        this.firePropertyChange(PROPERTYNAME_PUSH_INTERVAL, (Object)oldValue, (Object)pushInterval);
    }

    public Integer getPushInterval() {
        return this.pushInterval;
    }

    public boolean isSoundActive() {
        return this.soundActive;
    }

    public void setSoundActive(boolean soundActive) {
        boolean oldValue = this.soundActive;
        this.soundActive = soundActive;
        this.firePropertyChange(PROPERTYNAME_SOUND_ACTIVE, oldValue, soundActive);
    }
}

