package org.bidib.wizard.dialog;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.WindowConstants;

import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeLabelView extends EscapeDialog {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(NodeLabelView.class);

    private final NodeLabelModel nodeLabelModel;

    private final JButton applyButton = new JButton(Resources.getString(NodeLabelPanel.class, "apply"));

    private final JButton cancelButton = new JButton(Resources.getString(NodeLabelPanel.class, "cancel"));

    public NodeLabelView(Frame parent, final NodeInterface node, final NodeLabels nodeLabels) {
        super(parent, Resources.getString(NodeLabelView.class, "title"), true);

        LOGGER.info("Open the NodeLabelView.");

        nodeLabelModel = new NodeLabelModel();

        addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                tryCloseDialog();
            }
        });
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

        String label = BidibNodeNameUtils.prepareLabel(node, nodeLabels, false, false).getNodeLabel();
        nodeLabelModel.setNodeName(label);
        nodeLabelModel.setProductName(node.getNode().getStoredString(StringData.INDEX_PRODUCTNAME));
        nodeLabelModel.setUid(ByteUtils.getUniqueIdAsString(node.getUniqueId()));

        NodeLabelPanel mainPanel = new NodeLabelPanel();
        mainPanel.setNodeLabelModel(nodeLabelModel);
        mainPanel.setApplyButton(applyButton);
        mainPanel.setCancelButton(cancelButton);

        getContentPane().setLayout(new BorderLayout());
        getContentPane().add(mainPanel.createPanel());
        pack();

        setMinimumSize(mainPanel.getPreferredSize());

        applyButton.addActionListener(evt -> {
            LOGGER.info("The user pressed apply.");

            labelChanged(nodeLabelModel.getNodeName().trim());

            tryCloseDialog();
        });

        cancelButton.addActionListener(evt -> {
            LOGGER.info("The user pressed cancel.");
            tryCloseDialog();
        });

        // set the apply button as default button
        getRootPane().setDefaultButton(applyButton);
    }

    public abstract void labelChanged(String value);

    private void tryCloseDialog() {
        setVisible(false);
    }
}
