package org.bidib.wizard.mvc.booster.view;

import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;

public class BoosterControlCellRenderer extends DefaultTableCellRenderer {

    private static final long serialVersionUID = 1L;

    private Map<BoosterControl, ImageIcon> boosterControlIcons;

    private Map<BoosterControl, String> boosterControlToolTips;

    public BoosterControlCellRenderer() {

        boosterControlIcons = new LinkedHashMap<>();
        boosterControlIcons
            .put(BoosterControl.CONNECT,
                ImageUtils
                    .createImageIcon(BoosterControlCellRenderer.class,
                        UIManager.getString("BoosterControl.connect.icon.name"), 16, 16));
        boosterControlIcons
            .put(BoosterControl.LOCAL,
                ImageUtils
                    .createImageIcon(BoosterControlCellRenderer.class,
                        UIManager.getString("BoosterControl.local.icon.name"), 16, 16));
        // boosterControlIcons
        // .put(BoosterControl.REMOTE,
        // ImageUtils
        // .createImageIcon(BoosterControlCellRenderer.class,
        // UIManager.getString("BoosterControl.remote.icon.name"), 16, 16));

        boosterControlToolTips = new LinkedHashMap<>();
        boosterControlToolTips
            .put(BoosterControl.CONNECT, Resources.getString(BoosterControl.class, "connect.tooltip"));
        boosterControlToolTips.put(BoosterControl.LOCAL, Resources.getString(BoosterControl.class, "local.tooltip"));
        // boosterControlToolTips.put(BoosterControl.REMOTE, Resources.getString(BoosterControl.class,
        // "remote.tooltip"));

        setHorizontalAlignment(SwingConstants.LEADING);
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        // provide value == null because default processing is setText(value.toString())
        super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);

        if (value instanceof BoosterControl) {
            BoosterControl boosterControl = (BoosterControl) value;

            Icon icon = boosterControlIcons.get(boosterControl);
            setIcon(icon);

            setToolTipText(boosterControlToolTips.get(boosterControl));
        }
        else {
            setIcon(null);
            setToolTipText(null);
        }

        return this;
    }
}