package org.bidib.wizard.mvc.booster.view;

import java.awt.Component;

import javax.swing.JMenuItem;

import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.mvc.booster.controller.listener.BoosterTableControllerListener;
import org.bidib.wizard.mvc.booster.model.BoosterModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterTableMenu extends BasicPopupMenu {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterTableMenu.class);

    private JMenuItem boosterOnItem;

    private JMenuItem boosterOffItem;

    private JMenuItem commandStationOnItem;

    private JMenuItem commandStationOffItem;

    private final Component parent;

    private final BoosterTableControllerListener boosterTableController;

    private BoosterModel selectedBooster;

    public BoosterTableMenu(final Component parent, final BoosterTableControllerListener boosterTableController) {
        this.parent = parent;
        this.boosterTableController = boosterTableController;

        // booster
        boosterOnItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, "boosterOn"));
        boosterOnItem.addActionListener(e -> {
            BoosterModel boosterModel = selectedBooster;
            if (boosterModel != null) {
                LOGGER.info("Turn booster on: {}", boosterModel);
                boosterTableController.setBoosterState(boosterModel.getBooster(), BoosterStatus.ON);
            }
        });
        add(boosterOnItem);

        boosterOffItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, "boosterOff"));
        boosterOffItem.addActionListener(e -> {
            BoosterModel boosterModel = selectedBooster;
            if (boosterModel != null) {
                LOGGER.info("Turn booster off: {}", boosterModel);
                boosterTableController.setBoosterState(boosterModel.getBooster(), BoosterStatus.OFF);
            }
        });
        add(boosterOffItem);

        addSeparator();

        // command station
        commandStationOnItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, "commandStationOn"));
        commandStationOnItem.addActionListener(e -> {
            BoosterModel boosterModel = selectedBooster;
            if (boosterModel != null) {
                LOGGER.info("Turn command station on: {}", boosterModel);
                boosterTableController.setCommandStationState(boosterModel.getBooster(), CommandStationState.GO_IGN_WD);
            }
        });
        add(commandStationOnItem);

        commandStationOffItem = new JMenuItem(Resources.getString(BoosterTableMenu.class, "commandStationOff"));
        commandStationOffItem.addActionListener(e -> {
            BoosterModel boosterModel = selectedBooster;
            if (boosterModel != null) {
                LOGGER.info("Turn command station off: {}", boosterModel);
                boosterTableController.setCommandStationState(boosterModel.getBooster(), CommandStationState.STOP);
            }
        });
        add(commandStationOffItem);

        boosterOnItem.setEnabled(false);
        boosterOffItem.setEnabled(false);
        commandStationOnItem.setEnabled(false);
        commandStationOffItem.setEnabled(false);
    }

    public void prepareMenuItems(
        final BoosterModel booster, final BoosterState boosterState, final CommandStationState csState) {

        // IF2 must have special handling
        boolean boostBroadcastEnabled = false;
        if (booster != null && ProductUtils.isIF2(booster.getBooster().getUniqueId())) {
            if (SoftwareVersion
                .build(2, 10, 6).isLowerOrEqualThan(booster.getBooster().getNode().getSoftwareVersion())) {
                // BOOST_ON with broadcast is processed correct
                boostBroadcastEnabled = true;
                LOGGER.info("Set boostBroadcastEnabled because IF2 with 2.10.6 or greater detected.");
            }
        }

        this.selectedBooster = booster;

        if (boosterState != null) {
            boosterOnItem.setText(Resources.getString(BoosterTableMenu.class, "boosterOn"));
            boosterOffItem.setText(Resources.getString(BoosterTableMenu.class, "boosterOff"));
            if (BoosterState.isOffState(boosterState)) {
                boosterOnItem.setEnabled(true);
                boosterOffItem.setEnabled(false);
            }
            else {
                boosterOnItem.setEnabled(false);
                boosterOffItem.setEnabled(true);
            }
        }
        else if (boostBroadcastEnabled) {
            boosterOnItem.setText(Resources.getString(BoosterTableMenu.class, "boosterOnBroadcast"));
            boosterOffItem.setText(Resources.getString(BoosterTableMenu.class, "boosterOffBroadcast"));
            boosterOnItem.setEnabled(true);
            boosterOffItem.setEnabled(true);
        }
        else {
            boosterOnItem.setText(Resources.getString(BoosterTableMenu.class, "boosterOn"));
            boosterOffItem.setText(Resources.getString(BoosterTableMenu.class, "boosterOff"));
            boosterOnItem.setEnabled(false);
            boosterOffItem.setEnabled(false);
        }

        if (csState != null) {
            if (CommandStationState.isOffState(csState)) {
                commandStationOnItem.setEnabled(true);
                commandStationOffItem.setEnabled(false);
            }
            else {
                commandStationOnItem.setEnabled(false);
                commandStationOffItem.setEnabled(true);
            }
        }
        else {
            commandStationOnItem.setEnabled(false);
            commandStationOffItem.setEnabled(false);
        }
    }

}
