package org.bidib.wizard.mvc.loco.model;

import org.bidib.wizard.model.status.SpeedSteps;

import com.jgoodies.common.bean.Bean;

public class LocoConfigModel extends Bean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_SPEED_STEPS = "speedSteps";

    public static final String PROPERTY_CARCONTROL_ENABLED = "carControlEnabled";

    private SpeedSteps speedSteps = SpeedSteps.DCC128;

    private boolean carControlEnabled;

    public SpeedSteps getSpeedSteps() {
        return speedSteps;
    }

    public void setSpeedSteps(SpeedSteps speedSteps) {
        SpeedSteps oldValue = this.speedSteps;

        this.speedSteps = speedSteps;

        firePropertyChange(PROPERTY_SPEED_STEPS, oldValue, this.speedSteps);
    }

    /**
     * @return the carControlEnabled
     */
    public boolean isCarControlEnabled() {
        return carControlEnabled;
    }

    /**
     * @param carControlEnabled
     *            the carControlEnabled to set
     */
    public void setCarControlEnabled(boolean carControlEnabled) {
        boolean oldValue = this.carControlEnabled;

        this.carControlEnabled = carControlEnabled;

        firePropertyChange(PROPERTY_CARCONTROL_ENABLED, oldValue, carControlEnabled);
    }
}
