package org.bidib.wizard.mvc.loco.view;

import org.bidib.wizard.client.common.uils.SwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import eu.hansolo.steelseries.gauges.Radial;

public class SpeedGaugeBinding extends Radial {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpeedGaugeBinding.class);

    private static final long serialVersionUID = 1L;

    private Integer value;

    public SpeedGaugeBinding() {
    }

    public void setValueAnimated(final Integer value) {
        LOGGER.info("Set the value animated: {}", value);

        SwingUtils.executeInEDT(() -> internalSetValueAnimated(value));
    }

    private void internalSetValueAnimated(Integer value) {
        this.value = value;

        if (value == null) {
            value = 0;
        }
        double dValue = value;
        super.setValueAnimated(dValue);
    }

    public Integer getValueAnimated() {

        // return (int) super.getValue();

        return value;
    }
}
