package org.bidib.wizard.mvc.loco.view.speedo;

import java.awt.Frame;
import java.awt.Window;
import java.text.DecimalFormat;

import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.loco.model.SpeedometerProgBeanModel;
import org.oxbow.swingbits.dialog.task.TaskDialog;
import org.oxbow.swingbits.dialog.task.TaskDialog.Command;
import org.oxbow.swingbits.dialog.task.TaskDialog.StandardCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;

public class ApprovePidParamsDialog {

    private static final Logger LOGGER = LoggerFactory.getLogger(ApprovePidParamsDialog.class);

    private final PidParamsBeanModel pidParamsBeanModel;

    private int result = JOptionPane.CANCEL_OPTION;

    public ApprovePidParamsDialog(Frame frame, final SpeedometerProgBeanModel speedoProgBeanModel) {

        this.pidParamsBeanModel = new PidParamsBeanModel();

        this.pidParamsBeanModel.setCv61(speedoProgBeanModel.getCv61());
        this.pidParamsBeanModel.setCv62(speedoProgBeanModel.getCv62());
        this.pidParamsBeanModel.setCv63(speedoProgBeanModel.getCv63());

        LOGGER.info("Prepared pidParamsBeanModel: {}", pidParamsBeanModel);

        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            formBuilder =
                FormBuilder
                    .create().columns("pref, 3dlu, 30dlu, 20dlu, pref, 3dlu, pref:grow")
                    .rows("pref, 3ldu, pref, 3ldu, pref").panel(new FormDebugPanel());
        }
        else {
            formBuilder =
                FormBuilder
                    .create().columns("pref, 3dlu, 30dlu, 20dlu, pref, 3dlu, pref:grow")
                    .rows("pref, 3ldu, pref, 3ldu, pref");
        }

        ValueModel cv61ValueModel =
            new PropertyAdapter<PidParamsBeanModel>(this.pidParamsBeanModel, PidParamsBeanModel.PROPERTYNAME_CV61,
                true);

        final ValueModel cv61ConverterModel =
            new ConverterValueModel(cv61ValueModel, new StringConverter(new DecimalFormat("#")));

        JTextField cv61 = WizardComponentFactory.createTextField(cv61ConverterModel, false);
        cv61.setHorizontalAlignment(SwingConstants.RIGHT);

        formBuilder.add(Resources.getString(getClass(), "cv61")).xy(1, 1);
        formBuilder.add(cv61).xy(3, 1);

        JButton softValues = new JButton(Resources.getString(getClass(), "default"));
        softValues.addActionListener(e -> {
            // set the soft values
            pidParamsBeanModel.setCv61(Integer.valueOf(10));
            pidParamsBeanModel.setCv62(Integer.valueOf(2));
            pidParamsBeanModel.setCv63(Integer.valueOf(2));
        });
        formBuilder.add(softValues).xy(5, 1);
        // formBuilder.nextLine();

        ValueModel cv62ValueModel =
            new PropertyAdapter<PidParamsBeanModel>(this.pidParamsBeanModel, PidParamsBeanModel.PROPERTYNAME_CV62,
                true);

        final ValueModel cv62ConverterModel =
            new ConverterValueModel(cv62ValueModel, new StringConverter(new DecimalFormat("#")));

        JTextField cv62 = WizardComponentFactory.createTextField(cv62ConverterModel, false);
        cv62.setHorizontalAlignment(SwingConstants.RIGHT);

        formBuilder.add(Resources.getString(getClass(), "cv62")).xy(1, 3);
        formBuilder.add(cv62).xy(3, 3);
        // formBuilder.nextLine();

        ValueModel cv63ValueModel =
            new PropertyAdapter<PidParamsBeanModel>(this.pidParamsBeanModel, PidParamsBeanModel.PROPERTYNAME_CV63,
                true);

        final ValueModel cv63ConverterModel =
            new ConverterValueModel(cv63ValueModel, new StringConverter(new DecimalFormat("#")));

        JTextField cv63 = WizardComponentFactory.createTextField(cv63ConverterModel, false);
        cv63.setHorizontalAlignment(SwingConstants.RIGHT);

        formBuilder.add(Resources.getString(getClass(), "cv63")).xy(1, 5);
        formBuilder.add(cv63).xy(3, 5);

        // prepare the dialog
        TaskDialog dlg =
            questionDialog(frame, Resources.getString(getClass(), "title"), TaskDialog.StandardIcon.QUESTION,
                Resources.getString(getClass(), "instruction"), Resources.getString(getClass(), "message"));

        dlg.setFixedComponent(formBuilder.build());

        // if the model is valid, the write button is enabled.
        // Command okCommand = dlg.getCommands().toArray(new Command[0])[0];

        Command result = dlg.show();
        LOGGER.info("Result: {}", result.equals(StandardCommand.OK));

        if (result.equals(StandardCommand.OK)) {
            fireContinue();
        }
        else {
            fireCancel();
        }
    }

    private void fireContinue() {
        LOGGER.info("Continue operation.");

        result = JOptionPane.YES_OPTION;
    }

    private void fireCancel() {

    }

    public int getResult() {
        return result;
    }

    public PidParamsBeanModel getPidParamsBeanModel() {
        return pidParamsBeanModel;
    }

    private static TaskDialog questionDialog(Window parent, String title, Icon icon, String instruction, String text) {

        TaskDialog dlg = new TaskDialog(parent, title);
        dlg.setInstruction(instruction);
        dlg.setText(text);
        dlg.setIcon(icon);
        dlg
            .setCommands(StandardCommand.OK.derive(Resources.getString(ApprovePidParamsDialog.class, "start")),
                StandardCommand.CANCEL.derive(Resources.getString(ApprovePidParamsDialog.class, "cancel")));
        return dlg;
    }

}
