package org.bidib.wizard.mvc.locolist.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.wizard.PushToMouseWizard;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jidesoft.grid.SortableTableModel;

public class LocoListMenu extends BasicPopupMenu {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(LocoListMenu.class);

    private JMenuItem pushToMouseItem;

    private JMenuItem openLocoDialog;

    private JMenuItem openPomDialog;

    private JMenuItem deleteLocoItem;

    private final LocoTableControllerListener locoTableController;

    private final LocoTableTableModel locoTableTableModel;

    private final Component parent;

    public LocoListMenu(final Component parent, final LocoTableControllerListener locoTableController,
        final AbstractEmptyTable locoTable, final LocoTableTableModel locoTableTableModel,
        final LocoTableModel locoTableModel) {
        this.parent = parent;
        this.locoTableController = locoTableController;
        this.locoTableTableModel = locoTableTableModel;

        final SortableTableModel sortableTableModel = (SortableTableModel) locoTable.getModel();

        openLocoDialog = new JMenuItem(Resources.getString(LocoListMenu.class, "openLocoDialog") + " ...");

        openLocoDialog.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                LocoListModel locoModel = getSelectedRow(locoTable, sortableTableModel);
                if (locoModel != null) {
                    fireOpenLocoDialog(locoModel);
                }
            }

        });
        add(openLocoDialog);

        openPomDialog = new JMenuItem(Resources.getString(LocoListMenu.class, "openPomDialog") + " ...");

        openPomDialog.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                LocoListModel locoModel = getSelectedRow(locoTable, sortableTableModel);
                if (locoModel != null) {
                    fireOpenPomDialog(locoModel);
                }
            }

        });
        add(openPomDialog);

        pushToMouseItem = new JMenuItem(Resources.getString(getClass(), "pushToMouse") + " ...");

        pushToMouseItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                firePushToMouse(locoTableModel);
            }

        });
        add(pushToMouseItem);

        addSeparator();

        deleteLocoItem = new JMenuItem(Resources.getString(getClass(), "deleteLoco") + " ...");

        deleteLocoItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                LocoListModel locoModel = getSelectedRow(locoTable, sortableTableModel);
                if (locoModel != null) {
                    fireDeleteLoco(locoModel);
                }
            }

        });
        add(deleteLocoItem);
    }

    private LocoListModel getSelectedRow(
        final AbstractEmptyTable locoTable, final SortableTableModel sortableTableModel) {
        int selectedRow = locoTable.getSelectedRow();
        selectedRow = sortableTableModel.getActualRowAt(selectedRow);

        if (selectedRow > -1) {
            LocoListModel locoModel = (LocoListModel) locoTableTableModel.getListModel().getElementAt(selectedRow);
            return locoModel;
        }
        return null;
    }

    private void fireOpenLocoDialog(final LocoListModel locoModel) {

        locoTableController.openLocoDialog(locoModel);
    }

    private void fireOpenPomDialog(final LocoListModel locoModel) {

        locoTableController.openPomDialog(locoModel);
    }

    private void firePushToMouse(final LocoTableModel locoTableModel) {

        final PushToMouseWizard nodeScriptWizard = new PushToMouseWizard();
        nodeScriptWizard.showWizard(locoTableController, locoTableModel);
    }

    private void fireDeleteLoco(final LocoListModel locoModel) {

        boolean delete =
            TaskDialogs
                .ask(JOptionPane.getFrameForComponent(parent), Resources.getString(LocoListMenu.class, "deleteLoco"),
                    Resources.getString(LocoListMenu.class, "deleteLocoText", locoModel.getAddress()));

        if (delete) {
            locoTableController.deleteLoco(locoModel);
        }
    }

}
