package org.bidib.wizard.mvc.locolist.view.wizard;

import java.awt.Dimension;
import java.awt.Font;

import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;

import org.bidib.wizard.api.locale.Resources;

import com.jidesoft.wizard.GraphicLeftPane;
import com.jidesoft.wizard.WelcomeWizardPage;

public class WelcomePage extends WelcomeWizardPage {
    private static final long serialVersionUID = 1L;

    public WelcomePage() {
        super(Resources.getString(WelcomePage.class, "title"), Resources.getString(WelcomePage.class, "description"));
    }

    @Override
    protected void initContentPane() {
        super.initContentPane();
        addHtmlText(Resources.getString(WelcomePage.class, "content.text"));
        addSpace();
        addText(Resources.getString(WelcomePage.class, "content.continue"));
    }

    public void addHtmlText(String text) {

        Font font = UIManager.getFont("Label.font");
        JTextPane arg2 = new HtmlTextPane();
        arg2.setContentType("text/html");
        arg2.setText("<html>" + text + "</html>");
        arg2.setEditable(false);

        arg2.setMinimumSize(new Dimension(50, 150));

        if (GraphicLeftPane.b == 0) {

            this.addComponent(arg2);
        }

    }

    public static final class HtmlTextPane extends JTextPane {
        @Override
        public void updateUI() {
            super.updateUI();
            putClientProperty(JEditorPane.HONOR_DISPLAY_PROPERTIES, true);
        }
    }
}